/**
 ** Copyright (c) 1996  En Garde Systems, Inc. (EGS) 
 **
 ** Users and possessors of this source code are hereby granted a
 ** nonexclusive, royalty-free copyright and design patent license to
 ** use this code in individual software provided that the above copyright
 ** notice and this paragraph are included in their entirety.  License is
 ** not granted for commercial resale, in whole or in part, without prior
 ** written permission from EGS.  This source is provided "AS IS"
 ** without express or implied warranty of any kind.
 **
 ** In the case of superceding copyright notices, only the modifications to
 ** the original software are covered by this notice.
 **
 ** For further information contact:
 **     E-Mail:     info@EnGarde.com
 **
 **     Surface Mail:   ATTN: PICS Research
 **             En Garde Systems, Inc.
 **             2101 White Cloud NE
 **             Albuquerque, NM 87112
 **             (505) 275-8655
 **/

/* 
 * The point of this is to read packets off of the live network, and
 * interpolate them in some way. Most likely, we'll spit out live information
 * about "New connection from..." and UDP packet info. Then, we'll also dump
 * this stuff out to a logfile. If the program is invoked with a filename,
 * We'll read that file, and spit out all the connections. The user can then
 * monitor individual connections from the command line.
 */

#include <stdio.h>
#include <fcntl.h>
#include <sys/signal.h>

#include <sys/types.h>
#include <time.h>
#include <sys/time.h>

static void usage();

int ignore_zero = 0;
int ignore_user = 0;

time_t time_offset=0;

extern int reverseFlag;

main(argc, argv)
int argc;
char *argv[];
{
  int dump=0;
  char *input_filename=NULL, *output_filename=NULL;
  int con_id=-1, c;
  extern int optind, opterr;
  extern char *optarg;
  extern void cleanup_output();
  struct tm tm_offset;

  while ((c = getopt(argc, argv, "t:i:o:c:hzud:r")) != -1) {
	switch(c) {
	  case 't':
		if (con_id < 0) {
		  fprintf(stderr,"Select a connection before setting a time offset\n");
		  usage(argv[0]);
		  exit(1);
		}
		strptime(optarg,"%D %T",&tm_offset);
		time_offset = timelocal(&tm_offset);
		break;
	  case 'i':
		if (output_filename != NULL) {
		  fprintf(stderr, "Can't combine -i and -o flags\n");
		  usage(argv[0]);
		  exit(1);
		}
		input_filename = optarg;
		break;
	  case 'o':
		if (input_filename != NULL) {
		  fprintf(stderr, "Can't combine -i and -o flags\n");
		  usage(argv[0]);
		  exit(1);
		}
		if (con_id >= 0) {
		  fprintf(stderr, "Can't combine -c and -o flags\n");
		  usage(argv[0]);
		  exit(1);
		}
		output_filename = optarg;
		break;
	  case 'c':
		if (output_filename != NULL) {
		  fprintf(stderr, "Can't combine -c and -o flags\n");
		  usage(argv[0]);
		  exit(1);
		}
		if ((con_id = atoi(optarg)) < 0) {
		  fprintf(stderr, "Invalid connection ID\n");
		  usage(argv[0]);
		  exit(1);
		}
		break;
	  case 'd':
		if (output_filename != NULL) {
		  fprintf(stderr, "Can't combine -d and -o flags\n");
		  usage(argv[0]);
		  exit(1);
		}
		if ((con_id = atoi(optarg)) < 0) {
		  fprintf(stderr, "Invalid connection ID\n");
		  usage(argv[0]);
		  exit(1);
		}
		dump++;
		break;
	  case 'z':
		ignore_zero = 1;
		break;
	  case 'u':
		ignore_user = 1;
		break;
	  case 'h':
		usage(argv[0]);
		exit(0);
		break;
	  case '?':
		usage(argv[0]);
		exit(1);
	  case 'r':
		reverseFlag=1;
		break;
	  default:
		break;
	}
  } /* of while */
  if (optind < argc) {
	fprintf(stderr, "Invalid number of arguments\n");
	usage(argv[0]);
	exit(1);
  }
  if (con_id >= 0 && input_filename==NULL) {
	fprintf(stderr, "Must provide an input file to show a connection id\n");
	usage(argv[0]);
	exit(1);
  }

  /* Figure out what mode we're in, and do what we're supposed to! */

  if (input_filename!=NULL && con_id < 0) {  /* MODE 1: Spit out con_ids */
	summarize_logfile(input_filename);
	exit(0);
  }

  signal(SIGINT, cleanup_output);
  if (input_filename !=NULL && con_id >= 0 && dump==0) { 
	/* MODE 2: Watch specific conn */
	display_connection(input_filename, con_id);
	cleanup_output();
	exit(0);
  }

  if (input_filename != NULL && con_id >=0 && dump) {
	/* MODE 3: Dump A/B sides to a connection */
	dump_connection(input_filename, con_id);
	exit(0);
  }

  parse_stdin(output_filename);
  exit(0);
}

static void 
usage(program)
char *program;
{
  fprintf(stderr, "Usage: %s [ -i filename [ -z ] ] [ -o filename ] [ -c conid [ -t time ] ]\n", program);
  fprintf(stderr, "Options:\n");
  fprintf(stderr, "-i filename            : List connection IDs contained within a rawlog\n");
  fprintf(stderr, "-z                     : Skip zero sized connections in output\n");
  fprintf(stderr, "-o filename            : Copy tcpdump raw input to this output file\n");
  fprintf(stderr, "-c conid               : Watch a specific connection ID.\n");
  fprintf(stderr, "-r                     : When watching, reverse the client/server direction\n");
  fprintf(stderr, "-d conid               : Dump server and client text to separate files\n");
  fprintf(stderr, "-u                     : Ignore user data for a watched connection\n");
  fprintf(stderr, "-t \"MM/DD/YY HH:MM:SS\" : Set time offset for a watched connection\n");
  return;
}
