/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/07 15:06:26 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/themes/theme_priv.h,v $
    CVS/RCS Revision: $Revision: 1.4.2.8 $
    Status:           $State: Exp $
*/

#ifndef THEME_PRIV_H
#define THEME_PRIV_H

#include <vector>
#include <string>

#include "pgtheme.h"

class THEME_FONT {
public:
	std::string name;
	std::string value;
	int size;
	TTF_Font* font;
};

class THEME_COLOR {
public:
	SDL_Color c;
	Uint32 val;
};

class THEME_STRING {
public:
	virtual ~THEME_STRING() {}
	
	std::string name;
	std::string value;
};

class THEME_FILENAME {
public:
	THEME_FILENAME() {
		surface = NULL;
	}

	virtual ~THEME_FILENAME() {
		SDL_FreeSurface(surface);
	}
	
	std::string name;
	std::string value;
	Uint32 colorkey;
	bool hasColorKey;
	SDL_Surface* surface;
};

class THEME_PROPERTY {
public:
    std::string name;
    long value;
};

class THEME_GRADIENT {
public:
	std::string name;
	THEME_COLOR color[4];
	PG_Gradient gradient;
};

class THEME_OBJECT {
public:

	THEME_OBJECT();
	virtual ~THEME_OBJECT();
	
	SDL_Surface* FindSurface(const char* name);
	PG_Gradient* FindGradient(const char* name);
	long FindProperty(const char* name);
	const char* FindString(const char* name);
	THEME_FONT* font;
	
	std::string type;
	std::string name;
	std::vector<THEME_STRING*> strings;
	std::vector<THEME_FILENAME*> filename;
	std::vector<THEME_GRADIENT*> gradient;
	std::vector<THEME_PROPERTY*> property;
};

class THEME_WIDGET {
public:

	THEME_WIDGET() {};
	virtual ~THEME_WIDGET();
	
	THEME_OBJECT* FindObject(const char* objectname);
	
    std::string type;
    std::vector<THEME_OBJECT*> object;
};

class THEME_THEME : public PG_Theme {
public:

	THEME_THEME() {
		defaultfont = NULL;
	};
	
	virtual ~THEME_THEME();

	TTF_Font* FindDefaultFont();
	TTF_Font* FindFont(const char* fontname);
	TTF_Font* FindFont(const char* widgettype, const char* objectname);
	SDL_Surface* FindSurface(const char* widgettype, const char* object, const char* name);
	PG_Gradient* FindGradient(const char* widgettype, const char* object, const char* name);
	long FindProperty(const char* widgettype, const char* object, const char* name);
	SDL_Color* FindColor(const char* widgettype, const char* object, const char* name);
	const char* FindString(const char* widgettype, const char* object, const char* name);

	THEME_FONT* defaultfont;
		
	std::string title;
	std::string description;
	std::string author;
	std::string email;
	
	std::vector<THEME_WIDGET*> widget;
	std::vector<THEME_FILENAME*> filecache;
	std::vector<THEME_FONT*> fontcache;

	THEME_WIDGET* FindWidget(const char* widgettype);
	THEME_OBJECT* FindObject(const char* widgettype, const char* objectname);

	THEME_FILENAME* FindInSurfaceCache(const char* name);

	THEME_FILENAME* AddToCache(THEME_FILENAME* filename);
	THEME_FONT* AddToCache(THEME_FONT* font);
};

#endif // THEME_PRIV_H
