/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/06/07 14:34:55 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/themes/theme_priv.cpp,v $
    CVS/RCS Revision: $Revision: 1.6.2.12 $
    Status:           $State: Exp $
*/

#include "theme_priv.h"

THEME_THEME::~THEME_THEME() {
	Uint32 i;

	// clean up the filecache and del the surfaces
	for(i=0; i<filecache.size(); i++) {
		delete filecache[i];
		filecache[i] = NULL;
	}
	filecache.clear();

	for(i=0; i<widget.size(); i++) {
		delete widget[i];
		widget[i] = NULL;
	}
	widget.clear();

	for(i=0; i<fontcache.size(); i++) {
		TTF_Font* f = fontcache[i]->font;
		if(f != NULL) {
			TTF_CloseFont(f);
			delete fontcache[i];
		}
		fontcache[i] = NULL;
	}
	fontcache.clear();
}

THEME_WIDGET* THEME_THEME::FindWidget(const char* widgettype) {
	for(Uint32 i=0; i<widget.size(); i++) {
		if(widget[i]->type == (std::string)widgettype) {
			return widget[i];
		}
	}
	
	return NULL;
}

THEME_OBJECT* THEME_THEME::FindObject(const char* widgettype, const char* objectname) {
	THEME_WIDGET* widget = FindWidget(widgettype);
	
	if(widget == NULL) {
		return NULL;
	}
	
	THEME_OBJECT* object = widget->FindObject(objectname);
	
	return object;
}

SDL_Surface* THEME_THEME::FindSurface(const char* widgettype, const char* objectname, const char* name) {
	THEME_OBJECT* object = FindObject(widgettype, objectname);
	
	if(object == NULL) {
		return NULL;
	}
	
	return object->FindSurface(name);
}

PG_Gradient* THEME_THEME::FindGradient(const char* widgettype, const char* objectname, const char* name) {
	THEME_OBJECT* object = FindObject(widgettype, objectname);
	
	if(object == NULL) {
		return NULL;
	}

	return object->FindGradient(name);
}

long THEME_THEME::FindProperty(const char* widgettype, const char* objectname, const char* name) {
	THEME_OBJECT* object = FindObject(widgettype, objectname);
	
	if(object == NULL) {
		return -1;
	}

	return object->FindProperty(name);
}

const char* THEME_THEME::FindString(const char* widgettype, const char* objectname, const char* name) {
	THEME_OBJECT* object = FindObject(widgettype, objectname);
	
	if(object == NULL) {
		return NULL;
	}

	return object->FindString(name);
}

TTF_Font* THEME_THEME::FindDefaultFont() {
	if(!defaultfont) {
		return NULL;
	}
	
	return defaultfont->font;
}

TTF_Font* THEME_THEME::FindFont(const char* fontname) {

	// lookup the val (ugly algo)
	// also ugly cut 'n paste :)

	for(Uint32 i=0; i<fontcache.size(); i++) {
		if(fontcache[i]->name == (std::string)fontname) {
			return fontcache[i]->font;
		}
	}
	return NULL;
}

TTF_Font* THEME_THEME::FindFont(const char* widgettype, const char* objectname) {
	THEME_OBJECT* o = FindObject(widgettype, objectname);

	if(o == NULL) {
		return NULL;
	}
	
	if(!o->font) {
		return NULL;
	}
		
	return o->font->font;
}

THEME_FILENAME* THEME_THEME::FindInSurfaceCache(const char* name) {
	std::string val = name;
	THEME_FILENAME* found = NULL;
	
	// lookup the val (ugly algo)
	for(Uint32 i=0; i<filecache.size() && !found; i++) {
		if(filecache[i]->value == val) {
			found = filecache[i];
			break;
		}
	}

	return found;
}

THEME_FILENAME* THEME_THEME::AddToCache(THEME_FILENAME* filename) {
	std::string val = filename->value;
	
	// insert new file
	filecache.insert(filecache.end(), filename);
	return filename;
}

THEME_FONT* THEME_THEME::AddToCache(THEME_FONT* font) {
	std::string val = font->name;
	THEME_FONT* found = NULL;
	
	// lookup the val (ugly algo)
	for(Uint32 i=0; i<fontcache.size() && !found; i++) {
		if(fontcache[i]->name == val) {
			found = fontcache[i];
			break;
		}
	}
	
	// file found -> return old reference
	if(found) {
		TTF_CloseFont(font->font);
		font->font = found->font;
		return font;
	}
	
	// insert new file
	fontcache.insert(fontcache.end(), font);
	return font;
}

THEME_WIDGET::~THEME_WIDGET() {
	for(Uint32 i=0; i<object.size(); i++) {
		delete object[i];
		object[i] = NULL;
	}
	object.clear();
}

THEME_OBJECT* THEME_WIDGET::FindObject(const char* objectname) {
	for(Uint32 i=0; i<object.size(); i++) {
		if(object[i]->name == (std::string)objectname) {
			return object[i];
		}
	}
	
	return NULL;
}

THEME_OBJECT::THEME_OBJECT() {
	font = NULL;
}

THEME_OBJECT::~THEME_OBJECT() {
	Uint32 i;

	filename.clear();

	for(i=0; i<gradient.size(); i++) {
		delete gradient[i];
	}
	gradient.clear();

	for(i=0; i<property.size(); i++) {
		delete property[i];
		property[i] = NULL;
	}
	property.clear();

	for(i=0; i<strings.size(); i++) {
		delete strings[i];
		strings[i] = NULL;
	}
	strings.clear();
}

SDL_Surface* THEME_OBJECT::FindSurface(const char* name) {
	SDL_Surface* result = NULL;

	for(Uint32 i=0; i<filename.size(); i++) {
		if(filename[i]->name == (std::string)name) {
			result = filename[i]->surface;
			return result;
		}
	}
	
	return NULL;
}

PG_Gradient* THEME_OBJECT::FindGradient(const char* name) {
	for(Uint32 i=0; i<gradient.size(); i++) {
		if(gradient[i]->name == (std::string)name) {
			return &(gradient[i]->gradient);
		}
	}
	
	return NULL;
}

SDL_Color* THEME_THEME::FindColor(const char* widgettype, const char* object, const char* name) {
	static SDL_Color c;
	long b = FindProperty(widgettype, object, name);

	if(b == -1) {
		return NULL;
	}

#if SDL_BYTEORDER == SDL_LIL_ENDIAN
	c.r = ((Uint32)b >> 16) & 0xFF;
	c.g = ((Uint32)b >> 8) & 0xFF;
	c.b = (Uint32)b & 0xFF;
#else
	c.r = ((Uint32)b >> 8) & 0xFF;
	c.g = ((Uint32)b >> 16) & 0xFF;
	c.b = ((Uint32)b >> 24) & 0xFF;
#endif

	return &c;
}

long THEME_OBJECT::FindProperty(const char* name) {
	for(Uint32 i=0; i<property.size(); i++) {
		if(property[i]->name == (std::string)name) {
			return property[i]->value;
		}
	}
	
	return -1;
}

const char* THEME_OBJECT::FindString(const char* name) {
	for(Uint32 i=0; i<strings.size(); i++) {
		if(strings[i]->name == (std::string)name) {
			return strings[i]->value.c_str();
		}
	}
	
	return NULL;
}

