/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/06/12 11:43:38 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pgrectlist.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.21 $
    Status:           $State: Exp $
*/

#include "paragui.h"
#include "pgrectlist.h"
#include "pgwidget.h"

#include <algorithm>


PG_RectList::PG_RectList() {
}

PG_RectList::~PG_RectList() {
}

PG_RectList PG_RectList::Intersect(PG_Rect* rect, int first, int last) {
	int s = (last == -1) ? size() : last;
	PG_RectList result;
	PG_Widget* testwidget;
	PG_Rect testrect;

	// loop through all rects
	for(int i=first; i<s; i++) {

		// get the next rectangle to test
		testwidget = (*this)[i];

		if(!testwidget->IsVisible()) {
			continue;
		}

		testrect = testwidget->GetClipRect();

		// check if there is a possible intersection
		if( (testrect.x + testrect.w < rect->x) || (testrect.x > rect->x + rect->w) ) {
			continue;
		}

		if( (testrect.y + testrect.h < rect->y) || (testrect.y > rect->y + rect->h) ) {
			continue;
		}

		if(! (testrect.IntersectRect(*rect).IsNull()) ) {
			// append the matching rectangle
			result.Add(testwidget);
		}
	}

	return result;
}

PG_Widget* PG_RectList::IsInside(PG_Point p) {
	PG_Widget* result = NULL;
	PG_Widget* testrect;

	// loop down all rects till we find a match
	for(int i=size()-1; i>=0; i--) {

		testrect = (*this)[i];

		// check if the tested rect is visible
		if(!testrect->IsVisible()) {
			continue;
		}

		// check for a match
		if(testrect->GetClipRect().IsInside(p)) {
			result = testrect;
			break;
		}
	}

	return result;
}

void PG_RectList::Add(PG_Widget* rect) {
	indexmap[rect] = size();
	push_back(rect);
}

void PG_RectList::UpdateIndexMap() {
	indexmap.clear();

	int index = 0;
	for(iterator i = begin(); i != end(); i++) {
		indexmap[(*i)] = index;
		index++;
	}
}

bool PG_RectList::Remove(PG_Rect* rect) {
	iterator mark = end();

	int index = 0;
	for(iterator i = begin(); i != end(); i++) {
		indexmap.erase((*i));
		if(*i == rect) {
			mark = i;
		}
		else {
			indexmap[(*i)] = index;
			index++;
		}
	}

	if(mark != end()) {
		erase(mark);
		return true;
	}

	return false;
}

int PG_RectList::FindIndexOf(PG_Rect* rect) {
	int index = -1;

	PG_RectListMap::iterator im = indexmap.find(rect);

	if(im != indexmap.end()) {
		index = (*im).second;
	}

	return index;
}

void PG_RectList::Blit(const PG_Rect& rect) {
	PG_RectList* childs;

	// blit all objects in the list
	for(iterator i = begin(); i != end(); i++) {

		if(!(*i)->IsVisible()) {
			continue;
		}

		(*i)->Blit(false, false);

		// blit all childs of the widget
		childs = (*i)->GetChildList();
		if(childs) {
			PG_RectList list = childs->Intersect((PG_Rect*)&rect);
			list.Blit(rect);
		}
	}
}

void PG_RectList::Blit() {
	// blit all objects in the list
	for(iterator i = begin(); i != end(); i++) {
		if(!(*i)->IsVisible()) {
			continue;
		}

		(*i)->Blit(true, false);
	}
}

bool PG_RectList::BringToFront(PG_Widget* rect) {
	PG_RectListMap::iterator i = indexmap.find(rect);

	if(i == indexmap.end()) {
		return false;
	}

	Remove(rect);
	Add(rect);
	
	return true;
}

bool PG_RectList::SendToBack(PG_Widget* rect) {
	if(!Remove(rect)) {
		return false;
	}

	insert(begin(), rect);
	UpdateIndexMap();

	return true;
}
