/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/09 10:05:35 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pgprogressbar.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.14 $
    Status:           $State: Exp $
*/

#include "pgapplication.h"
#include "pgprogressbar.h"

PG_ProgressBar::PG_ProgressBar(PG_Widget* parent, const PG_Rect& r, const char* style) :
PG_StaticFrame(parent, r) {

	my_percentCurrent = 0;

	my_colorText.r = 0xFF;
	my_colorText.g = 0xFF;
	my_colorText.b = 0xFF;

	// fill in default gradient
	my_pbGradient.colors[0].r = 0x00;
	my_pbGradient.colors[0].g = 0x00;
	my_pbGradient.colors[0].b = 0x00;

	my_pbGradient.colors[1].r = 0x00;
	my_pbGradient.colors[1].g = 0x00;
	my_pbGradient.colors[1].b = 0xFF;

	my_pbGradient.colors[2].r = 0x00;
	my_pbGradient.colors[2].g = 0x00;
	my_pbGradient.colors[2].b = 0x00;

	my_pbGradient.colors[3].r = 0x00;
	my_pbGradient.colors[3].g = 0x00;
	my_pbGradient.colors[3].b = 0xFF;

	my_pbBackground = NULL;
	my_pbBackmode = BKMODE_TILE;
	my_pbBlend = 255;
	my_bordersize = 1;

	LoadThemeStyle(style);
}

PG_ProgressBar::~PG_ProgressBar() {}

void PG_ProgressBar::LoadThemeStyle(const char* widgettype) {
	int b;
	PG_Theme* t = PG_Application::GetTheme();

	PG_StaticFrame::LoadThemeStyle(widgettype, "Background");

	my_pbBackground = t->FindSurface(widgettype, "Indicator", "background");

	PG_Gradient* g = t->FindGradient(widgettype, "Indicator", "gradient");
	
	if(g) {
		my_gradient = *g;
	}

	b = t->FindProperty(widgettype, "Indicator", "backmode");
	
	if(b != -1) {
		my_pbBackmode = b;
	}

	b = t->FindProperty(widgettype, "Indicator", "blend");
	
	if(b != -1) {
		my_pbBlend = b;
	}
}

void PG_ProgressBar::eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst) {
	PG_Rect pr(
		my_xpos + 1,
		my_ypos + 2,
		my_width - 2,
		my_height - 4);

	PG_Rect my_src, my_dst;
	static char buf[6];

	// get length of progress indicator

	int l = (int)(((double)pr.my_width / 100.0) * my_percentCurrent);
	pr.my_width = l;

	// draw our superclass
	PG_StaticFrame::eventBlit(srf, src, dst);

	// draw the gradient
	SDL_Surface* ind = CreateThemedSurface(
		pr,
		&my_pbGradient,
		my_pbBackground,			// currently no background
		my_pbBackmode,	// backmode
		my_pbBlend);			// background blend

	GetClipRects(my_src, my_dst, pr);
	PG_BlitSurface(ind, my_src, my_srfScreen, my_dst);
	
	DeleteThemedSurface(ind);

	// draw the percentage
	sprintf(buf, "%i%%", (int)my_percentCurrent);

	int w,h;
	GetTextSize(buf, w, h, GetFont());

	pr.x = (my_width - w)/2;
	pr.y = (my_height - h)/2;

	DrawText(pr.x, pr.y, buf, GetTextColor(), GetFont());
}

// Why a double? -Dave
void PG_ProgressBar::SetProgress(double p) {
	if(p < 0) p = 0;
	if(p >100) p = 100;

	my_percentCurrent = p;
	Update();
}
