/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/06/13 13:51:49 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pgmessagebox.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.18 $
    Status:           $State: Exp $
*/

#include "pgmessagebox.h"
#include "pgwidget.h"
#include "rendertextrect.h"

//create PopUp and 2 Buttons
PG_MessageBox::PG_MessageBox(PG_Widget* parent, const PG_Rect& r, char* windowtitle, char* windowtext, const PG_Rect& btn1, char* btn1text, const PG_Rect& btn2, char* btn2text, int textalign, const char* style) :
PG_Window(parent, r, windowtitle, true) {

	my_btnok = new PG_Button(this, 1, btn1, btn1text);
	my_btncancel = new PG_Button(this, 2, btn2, btn2text);

	Init(windowtitle, windowtext, textalign, style);
}

PG_MessageBox::PG_MessageBox(PG_Widget* parent, const PG_Rect& r, char* windowtitle, char* windowtext, const PG_Rect& btn1, char* btn1text, int textalign, const char* style) :
PG_Window(parent, r, windowtitle, true) {

	my_btnok = new PG_Button(this, 1, btn1, btn1text);
	my_btncancel = NULL;

	Init(windowtitle, windowtext, textalign, style);
}

//Delete the Buttons
PG_MessageBox::~PG_MessageBox() {
	delete my_btnok;
	delete my_btncancel;
}

void PG_MessageBox::Init(char* windowtitle, char* windowtext, int textalign, const char* style) {
	buttonflag=0;

	my_msgtext[0] = 0;
	my_windowtitle[0] = 0;

	if(windowtext != NULL) {
		strcpy(my_msgtext, windowtext);
	}

	if(windowtitle != NULL) {
		strcpy(my_windowtitle, windowtitle);
	}

	my_msgalign = textalign;

	LoadThemeStyle(style);
}


void PG_MessageBox::LoadThemeStyle(const char* widgettype) {
	PG_Window::LoadThemeStyle(widgettype);
	my_btnok->LoadThemeStyle(widgettype, "Button1");
	my_btncancel->LoadThemeStyle(widgettype, "Button2");
}


void PG_MessageBox::eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst) {
	PG_Window::eventBlit(srf, src, dst);

	// render text
	if((src.w == my_width) && (src.h == my_height)) {
		PG_Rect rect(10, 40, my_width - 20, my_height - 50);
		DrawText(rect, my_msgtext, GetTextColor(), my_msgalign, GetFont());
	}
}

//Event?
bool PG_MessageBox::eventButtonClick(int id, PG_Widget* widget) {
	//Button clicked?
	if(widget==my_btnok || widget==my_btncancel) {
		//Set Buttonflag to ButtonID
		buttonflag=id;
		return true;
	}
	return false;
}

int PG_MessageBox::WaitForClick() {
	int help;
	SDL_Event event;

	//While no Button is clicked
	while(!buttonflag){

		// update the screen if we are in OpenGL mode
		if(PG_Application::GetGLMode()) {
			Update();
			SDL_GL_SwapBuffers();
		}

		//Handle Event
		SDL_WaitEvent(&event);
		ProcessEvent(&event);
	}

	help = buttonflag;
	//Reset buttonflag
	buttonflag = 0;

	// clean the event queue
	while(SDL_PollEvent(&event));

	return help;
}
