/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/22 09:34:41 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pglistboxitem.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.8 $
    Status:           $State: Exp $
*/

#include "pglistboxitem.h"
#include "pglistbox.h"

PG_ListBoxItem::PG_ListBoxItem(int height, char* text, SDL_Surface* icon, void* userdata, const char* style) : PG_ListBoxBaseItem(height, userdata) {

	for(int i=0; i<3; i++) {
		my_background[i] = NULL;
		my_bkmode[i] = BKMODE_TILE;
		my_blend[i] = 0;
	}

	SetText(text);
	LoadThemeStyle(style, "ListBoxItem");

	my_srfHover = CreateThemedSurface(
				PG_Rect(0, 0, my_width, my_itemheight),
				my_gradient[2],
				my_background[2],
				my_bkmode[2],
				my_blend[2]);

	my_srfSelected = CreateThemedSurface(
				PG_Rect(0, 0, my_width, my_itemheight),
				my_gradient[1],
				my_background[1],
				my_bkmode[1],
				my_blend[1]);
}

PG_ListBoxItem::~PG_ListBoxItem() {
	DeleteThemedSurface(my_srfHover);
	DeleteThemedSurface(my_srfSelected);
}

void PG_ListBoxItem::eventSizeWindow(int w, int h) {
	DeleteThemedSurface(my_srfHover);
	DeleteThemedSurface(my_srfSelected);

	my_srfHover = CreateThemedSurface(
				PG_Rect(0, 0, w, my_itemheight),
				my_gradient[2],
				my_background[2],
				my_bkmode[2],
				my_blend[2]);

	my_srfSelected = CreateThemedSurface(
				PG_Rect(0, 0, w, my_itemheight),
				my_gradient[1],
				my_background[1],
				my_bkmode[1],
				my_blend[1]);
}

void PG_ListBoxItem::eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst) {
	SDL_Surface* temp = NULL;

	if((dst.my_width == 0) || (dst.my_height == 0)) {
		return;
	}

	PG_Rect my_src = src;
	PG_Rect my_dst = dst;

	temp = NULL;

	if(my_hover) {
		/*temp = CreateThemedSurface(
				PG_Rect(0, 0, my_width, my_itemheight),
				my_gradient[2],
				my_background[2],
				my_bkmode[2],
				my_blend[2]);*/
		PG_DrawObject::eventBlit(my_srfHover, src, dst);
	}
	if(my_selected) {
		/*temp = CreateThemedSurface(
				PG_Rect(0, 0, my_width, my_itemheight),
				my_gradient[1],
				my_background[1],
				my_bkmode[1],
				my_blend[1]);*/
		PG_DrawObject::eventBlit(my_srfSelected, src, dst);
	}

	PG_Label::eventBlit(NULL, my_src, my_dst);
}

void PG_ListBoxItem::LoadThemeStyle(const char* widgettype, const char* objectname) {
	int b;
	long c;
	static char prop[80];

	PG_Theme* t = PG_Application::GetTheme();
	
	SetFont(t->FindFont(widgettype, objectname));

	for(int i=0; i<3; i++) {
		sprintf(prop, "background%i", i);
		my_background[i] = t->FindSurface(widgettype, objectname, prop);
	
		sprintf(prop, "blend%i", i);
		b = t->FindProperty(widgettype, objectname, prop);
	
		if(b != -1) {
			my_blend[i] = b;
		}

		sprintf(prop, "backmode%i", i);
		b = t->FindProperty(widgettype, objectname, prop);
	
		if(b != -1) {
			my_bkmode[i] = b;
		}
	
		sprintf(prop, "gradient%i", i);
		PG_Gradient* g = t->FindGradient(widgettype, objectname, prop);
	
		if(g) {
			my_gradient[i] = g;
		}
	
	}	
	c = t->FindProperty(widgettype, objectname, "textcolor");
	if(c != -1) SetTextColor((Uint32)c);
}
