/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/09 18:28:12 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pglabel.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.21 $
    Status:           $State: Exp $
*/

#include "paragui.h"
#include "pglabel.h"
#include <string.h>
#include <stdarg.h>

PG_Label::PG_Label(PG_Widget* parent, const PG_Rect& r, char* text, const char* style) :
PG_Widget(parent, r) {

	my_alignment = PG_TA_CENTER;
	my_srfIcon = NULL;
	my_freeIcon = false;
	my_textLabel = "";
	my_indent = 0;

	SetText(text);
	LoadThemeStyle(style);
}

PG_Label::~PG_Label() {

	if(my_freeIcon && my_srfIcon) {
		SDL_FreeSurface(my_srfIcon);
		my_srfIcon = NULL;
	}
}

void PG_Label::LoadThemeStyle(const char* style) {
	PG_Label::LoadThemeStyle("Label", "Label");
	PG_Label::LoadThemeStyle(style, "Label");
}

void PG_Label::LoadThemeStyle(const char* widgettype, const char* object) {
	const char* s = NULL;
	int b = -1;

	PG_Theme* t = PG_Application::GetTheme();

	s = t->FindString(widgettype, object, "label");

	if(s != NULL) {
		SetText((char*)s);
	}

	b = t->FindProperty(widgettype, object, "alignment");
	
	if(b != -1) {
		SetAlignment(b);
	}

	PG_Widget::LoadThemeStyle(widgettype, object);
}

void PG_Label::eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst) {
	int xshift = my_indent;

	// should we blit an icon ?
	if(my_srfIcon != NULL) {
		xshift = my_srfIcon->w + my_indent;

		PG_Rect icon_rect(
						my_xpos + my_indent,
						my_ypos + (my_height - my_srfIcon->h)/2,
						my_srfIcon->w,
						my_srfIcon->h);

		PG_Rect icon_src;
		PG_Rect icon_dst;

		GetClipRects(icon_src, icon_dst, icon_rect);

		PG_DrawObject::eventBlit(my_srfIcon, icon_src, icon_dst);
	}

	int wl;
	int hl;
	GetTextExtend(my_textLabel.c_str(), wl, hl);

	switch (my_alignment) {
		case PG_TA_LEFT:
		my_rectLabel.my_xpos = xshift;
		my_rectLabel.my_ypos = (my_height - hl) / 2;
		break;

		case PG_TA_RIGHT:
		my_rectLabel.my_xpos = (my_width - wl);
		my_rectLabel.my_ypos = (my_height - hl) / 2;
		break;

		case PG_TA_CENTER:
		my_rectLabel.my_xpos = (my_width - wl) / 2;
		my_rectLabel.my_ypos = (my_height - hl) / 2;
		break;
	}

	DrawText(my_rectLabel.x, my_rectLabel.y, my_textLabel.c_str(), GetTextColor(), GetFont());
}

/**  */
void PG_Label::eventDraw(SDL_Surface* surface, const PG_Rect& rect) {
}

/**  */
const char* PG_Label::GetText() {
	return my_textLabel.c_str();
}

void PG_Label::SetText(char* text) {

	if(text == NULL) {
		return;
	}

	my_textLabel = text;
	Update();
}

void PG_Label::SetTextFormat(char* text, ...) {
	va_list ap;
	va_start(ap, text);
	char temp[256];

	if(text == NULL) {
		return;
	}

	if(text[0] == 0) {
		return;
	}

	vsprintf(temp, text, ap);
	SetText(temp);
	va_end(ap);

}

void PG_Label::SetAlignment(int a) {
	my_alignment = a;
	Update();
}

void PG_Label::GetTextExtend(const char* text, int& width, int &height) {
	GetTextSize(text, width, height, GetFont());
}

SDL_Surface* PG_Label::SetIcon(SDL_Surface* icon) {

	if(my_freeIcon && my_srfIcon) {
		SDL_FreeSurface(my_srfIcon);
	}

	my_srfIcon = icon;
	my_freeIcon = false;

	Update();

	return my_srfIcon;
}

SDL_Surface* PG_Label::SetIcon(char* filename) {

	if(my_freeIcon && my_srfIcon) {
		SDL_FreeSurface(my_srfIcon);
		my_srfIcon = NULL;
	}

	my_srfIcon = PG_LoadImage(PG_Application::GetRelativePath(filename));
	my_freeIcon = true;

	return my_srfIcon;
}

void PG_Label::SetIndent(int indent) {
	my_indent = indent;
}
