/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/11 13:45:17 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pggradientwidget.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.14 $
    Status:           $State: Exp $
*/

#include "pggradientwidget.h"
#include "pgapplication.h"
#include "parastretch.h"
#include <iostream>

PG_GradientWidget::PG_GradientWidget(PG_Widget* parent, const PG_Rect& r, bool bCreateSurface, const char* style) :
PG_WidgetDnD(parent, -1, r, bCreateSurface) {
	Init(style);
}

PG_GradientWidget::PG_GradientWidget(PG_Widget* parent, const PG_Rect& r, const char* style) :
PG_WidgetDnD(parent, -1, r, true) {
	Init(style);
}

void PG_GradientWidget::Init(const char* style) {
	SetDrop(false);
	SetDrag(false);

	my_backgroundFree = false;

	my_background = NULL;
	my_blendLevel = 0;
	my_backgroundMode = BKMODE_TILE;
	my_bordersize = 0;

	LoadThemeStyle(style);
}

PG_GradientWidget::~PG_GradientWidget() {
	FreeSurface();
}

void PG_GradientWidget::LoadThemeStyle(const char* widgettype) {
	PG_GradientWidget::LoadThemeStyle(widgettype, "GradientWidget");
	PG_Widget::LoadThemeStyle(widgettype);
}

void PG_GradientWidget::LoadThemeStyle(const char* widgettype, const char* objectname) {
	int b;
	long c;

	PG_Theme* t = PG_Application::GetTheme();
	
	SetFont(t->FindFont(widgettype, objectname));

	SetBackground(t->FindSurface(widgettype, objectname, "background"));
	
	b = t->FindProperty(widgettype, objectname, "blend");
	
	if(b != -1) {
		SetBackgroundBlend(b);
	}

	b = t->FindProperty(widgettype, objectname, "bordersize");

	if(b != -1) {
		my_bordersize = b;
	}
	
	b = t->FindProperty(widgettype, objectname, "backmode");
	
	if(b != -1) {
		my_backgroundMode = b;
	}
	
	PG_Gradient* g = t->FindGradient(widgettype, objectname, "gradient");
	
	if(g) {
		my_gradient = *g;
	}
	
	c = t->FindProperty(widgettype, objectname, "transparency");
	if(c != -1) SetTransparency((Uint32)c);
	
	PG_Widget::LoadThemeStyle(widgettype, objectname);

	int w = t->FindProperty(widgettype, objectname, "width"); if (w==-1) w=Width();
	int h = t->FindProperty(widgettype, objectname, "height"); if (h==-1) h=Height();

	if((w != Width()) || (h != Height())) {
		SizeWindow(w, h);
	}
}

/**  */
void PG_GradientWidget::eventDraw(SDL_Surface* surface, const PG_Rect& rect) {

	DrawThemedSurface(
		surface,
		rect,
		&my_gradient,
		my_background,
		my_backgroundMode,
		my_blendLevel);

	if(my_bordersize > 0) {
		DrawBorder(rect, my_bordersize);
	}
}

bool PG_GradientWidget::SetBackground(const char* filename, int mode) {

	// try to load the file
	SDL_Surface* temp = PG_LoadImage(PG_Application::GetRelativePath((char*)filename));

	// success ?
	if(!temp) {
		return false;
	}

	// free previous surface
	FreeSurface();

	// mark my_background to be freed on destruction
	my_backgroundFree = true;
	my_backgroundMode = mode;
	
	my_background = SDL_ConvertSurface(temp, my_srfObject->format, SDL_SWSURFACE);
	SDL_FreeSurface(temp);
	
	return (my_background != NULL);
}


bool PG_GradientWidget::SetBackground(SDL_Surface* surface, int mode) {

	if(!surface) {
		return false;
	}

	FreeSurface();

	my_background = surface;
	my_backgroundFree = false;
	my_backgroundMode = mode;

	return true;
}


void PG_GradientWidget::SetBackgroundBlend(Uint8 backblend) {
	my_blendLevel = backblend;
}

void PG_GradientWidget::FreeSurface() {

	// check if we have to free a previous surface
	
	if (my_backgroundFree && my_background != NULL) {
		SDL_FreeSurface(my_background);
		my_background = NULL;
		my_backgroundFree = false;
	}
}

void PG_GradientWidget::SetGradient(PG_Gradient& grad) {
	my_gradient = grad;
}
