/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <pan/base/debug.h>
#include <pan/base/pan-i18n.h>
#include <pan/base/newsrc-port.h>
#include <pan/base/util-file.h>

#include <pan/globals.h>
#include <pan/newsrc-ui.h>
#include <pan/util.h>

/*********************
**********************  BEGINNING OF SOURCE
*********************/

static void
newsrc_import_dialog_response_cb (GtkDialog * dialog, int response, gpointer data)
{
	Server * server = SERVER(data);

	g_return_if_fail (server != NULL);

	if (response == GTK_RESPONSE_OK)
	{
		GtkEntry * entry = GTK_ENTRY (gtk_object_get_data (GTK_OBJECT(dialog), "file_entry"));
		const char * filename = gtk_entry_get_text (entry);
		newsrc_import (server, filename, FALSE);
	}

        gtk_widget_destroy (GTK_WIDGET(dialog));
}

void
newsrc_import_dialog (Server * server)
{
	GtkWidget * hbox;
	GtkWidget * dialog;
	GtkWidget * w;
	GtkWidget * file_entry;
	char * s;

	pan_lock ();

	dialog = gtk_dialog_new_with_buttons (_("Pan: Import .newsrc File"),
	                                      GTK_WINDOW(Pan.window),
	                                      GTK_DIALOG_DESTROY_WITH_PARENT,
	                                      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	                                      GTK_STOCK_OK, GTK_RESPONSE_OK,
	                                      NULL);

	hbox = gtk_hbox_new (FALSE, GUI_PAD_SMALL);

	s = _("Select .newsrc File to Read:");
	w = gtk_label_new (s);
	gtk_box_pack_start (GTK_BOX(hbox), w, FALSE, FALSE, 0);
	file_entry = gtk_entry_new ();
	g_signal_connect (GTK_OBJECT(dialog), "response",
	                  G_CALLBACK (newsrc_import_dialog_response_cb), server);
	gtk_box_pack_start (GTK_BOX(hbox), file_entry, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, 0, 0, 0);
	gtk_object_set_data (GTK_OBJECT(dialog), "file_entry", file_entry);

	gtk_widget_show_all (dialog);
	pan_unlock();
}

/*****
******
*****/

static void
newsrc_export_dialog_response_cb (GtkDialog * dialog, int response, gpointer data)
{
	Server * server = SERVER(data);

	g_return_if_fail (server != NULL);

	if (response == GTK_RESPONSE_OK)
	{
		GtkEntry * entry = GTK_ENTRY (gtk_object_get_data (GTK_OBJECT(dialog), "file_entry"));
		const char * filename = gtk_entry_get_text (entry);
		newsrc_export (server, filename, FALSE);
	}

        gtk_widget_destroy (GTK_WIDGET(dialog));
}
void
newsrc_export_dialog (Server * server)
{
	GtkWidget * hbox;
	GtkWidget * dialog;
	GtkWidget * w;
	GtkWidget * file_entry;
	char * s;

	pan_lock ();

	dialog = gtk_dialog_new_with_buttons (_("Pan: Export .newsrc File"),
	                                      GTK_WINDOW(Pan.window),
	                                      GTK_DIALOG_DESTROY_WITH_PARENT,
	                                      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	                                      GTK_STOCK_OK, GTK_RESPONSE_OK,
	                                      NULL);

	hbox = gtk_hbox_new (FALSE, GUI_PAD_SMALL);

	s = _("Select .newsrc File to Write:");
	w = gtk_label_new (s);
	gtk_box_pack_start (GTK_BOX(hbox), w, FALSE, FALSE, 0);
	file_entry = gtk_entry_new ();
	pan_gtk_entry_set_text (file_entry, g_get_home_dir());
	g_signal_connect (GTK_OBJECT(dialog), "response",
	                  G_CALLBACK(newsrc_export_dialog_response_cb), server);
	gtk_box_pack_start (GTK_BOX(hbox), file_entry, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, 0, 0, 0);
	gtk_object_set_data (GTK_OBJECT(dialog), "file_entry", file_entry);
	gtk_widget_show_all (dialog);
	pan_unlock();
}
