/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __GUI_H__
#define __GUI_H__

#include <gtk/gtkwidget.h>

#include <pan/base/article.h>
#include <pan/base/group.h>
#include <pan/base/status-item.h>
#include <pan/filters/filter.h>

extern GtkWidget * groups_vbox;
extern GtkWidget * articlelist_ctree;
extern GtkWidget * text_box;

enum {
	GUI_PANED = 1,
	GUI_NOTEBOOK
};

enum {
	GROUPS_PANE = 0,
	HEADERS_PANE,
	BODY_PANE
};

void pan_widget_set_font (GtkWidget* w, const char* font_name);

void gui_layout_clear_workarea (void);
void gui_layout_set_mode (int type);


void gui_construct (const gchar *geometry);

void gui_page_set (int page);

void gui_restore_column_widths    (GtkWidget * clist, const gchar * key);

void gui_save_column_widths       (GtkWidget * clist, const gchar * key);

gboolean gui_restore_window_size      (GtkWidget * window, const gchar * key);

void gui_save_window_size         (GtkWidget * window, const gchar * key);

void gui_set_connecting_flag (gboolean is_connecting);
void gui_inc_connection_size (int inc);
void gui_set_queue_size (guint running, guint total);

void gui_queue_add (GSourceFunc func, gpointer user_data);

GdkColormap* cmap;

void gui_edit_current_filter (void);

#endif /* __GUI_H__ */
