#ifndef __GROUP_STORE_H__
#define __GROUP_STORE_H__

#include <gtk/gtktreemodel.h>
#include <gtk/gtktreesortable.h>
#include <pan/base/group.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define PAN_TYPE_GROUP_STORE	        (group_store_get_type ())
#define GROUP_STORE(obj)	        (GTK_CHECK_CAST ((obj), PAN_TYPE_GROUP_STORE, GroupStore))
#define GROUP_STORE_CLASS(klass)        (GTK_CHECK_CLASS_CAST ((klass), PAN_TYPE_GROUP_STORE, GroupStoreClass))
#define PAN_IS_GROUP_STORE(obj)	        (GTK_CHECK_TYPE ((obj), PAN_TYPE_GROUP_STORE))
#define PAN_IS_GROUP_STORE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), PAN_TYPE_GROUP_STORE))
#define GROUP_STORE_GET_CLASS(obj)      (GTK_CHECK_GET_CLASS ((obj), PAN_TYPE_GROUP_STORE, GroupStoreClass))

typedef struct _GroupStore       GroupStore;
typedef struct _GroupStoreClass  GroupStoreClass;

enum {
	GROUP_STORE_COLUMN_GROUP_POINTER,
	GROUP_STORE_COLUMN_SUBSCRIBED,
	GROUP_STORE_COLUMN_NAME,
	GROUP_STORE_COLUMN_UNREAD,
	GROUP_STORE_COLUMN_TOTAL,
	GROUP_STORE_COLUMN_DESCRIPTION,
	GROUP_STORE_COLUMN_QTY
};

struct _GroupStore
{
	GObject parent;

	/*< private >*/
	GPtrArray * groups;
	gint stamp;
};

struct _GroupStoreClass
{
	GObjectClass parent_class;
};


GtkType       group_store_get_type            (void);

GroupStore  * group_store_new                 (void);

void          group_store_set_groups          (GroupStore   * group_store,
                                               Group       ** groups,
                                               int            group_qty);

void          group_store_remove_group        (GroupStore   * group_store,
                                               const Group  * group);

gboolean      group_store_fire_group_changed  (GroupStore   * group_store,
                                               const Group  * group);

gboolean      group_store_get_iter_to_group   (GroupStore   * group_store,
                                               const Group  * group,
                                               GtkTreeIter  * iter);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GROUP_STORE_H__ */
