/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1994 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

/*
 * This file contains function prototypes, global variable declarations,
 * and #defined masks and macros for manipulating the flags member
 * of a struct inst.
 */

/************************************************************************/
/*	Copyright for PILOTDIS - modified from original m68k program	*/
/*	Copyright (C) 1998 David Griffiths				*/
/*									*/
/*	Copyright for PILOTDIS - modified from original m68k program	*/
/*	Copyright (C) 1999 Nick Spence					*/
/*									*/
/*	Copyright for PILOTDIS - modified from original m68k program	*/
/*	Copyright (C) 2000 Ali Akcaagac					*/
/************************************************************************/

#ifndef DIS_H
#define DIS_H

/************************************************************************/
/*	normal includes							*/
/************************************************************************/
#include <stdio.h>
#include <limits.h>
#include <setjmp.h>

/************************************************************************/
/*	eight bits here							*/
/************************************************************************/
#define BYTE			0x00
#define WORD			0x01
#define LONGWORD		0x02
#define DOUBLELONGWORD		0x04
#define SINGLE			0x08
#define DOUBLE			0x10
#define EXTENDED		0x20
#define PACKED			0x40
#define PWORD			WORD
#define PLONGWORD		LONGWORD
#define PDOUBLELONGWORD		DOUBLELONGWORD
#define PSINGLE			SINGLE
#define PDOUBLE			DOUBLE
#define PEXTENDED		EXTENDED
#define PPACKED			PACKED
#define PBYTE			0x80
#define size2f(s)		((s) == BYTE ? PBYTE : (s))
#define ISINTEGRAL(s)		((s) <= DOUBLELONGWORD)

/************************************************************************/
/*	four bits here							*/
/************************************************************************/
#define MAXOPSMASK		15		/* 4 bits => 1111 base 2 */
#define f2sharps(f)		(((f) >> 8) & MAXOPSMASK)
#define sharp2f(arg)		(1 << (8 + (arg) - 1))

#define f2ops(f)		((f) >> 12)
#define ops2f(n)		((n) << 12)

#define FROM			0
#define TO			1

#define MC68000			0x0001
#define MC68008			0x0002
#define MC68010			0x0004
#define MC68020			0x0008
#define MC68030			0x0010
#define MC68040			0x0020
#define CPU(m)			((m) & 0x3f)

#define MC68851			0x8000
#define PMMU(m)			((m) & MC68851)
#define MC68881			0x4000
#define MC68882			0x2000
#define FPU(m)			((m) & (MC68881 | MC68882))

#define FIRSTPASS		1
#define LASTPASS		2
#define DEBUGPASS		3
#define DCLABELSPASS		4

#define INCONSISTENT		1
#define CONSISTENT		2

#define MAXLABELLEN		16

#define FORMFEED		0x0C

typedef unsigned short		m68kword;	/* at least 16 bits */
#if UINT_MAX >= 4294967295U
typedef unsigned int		u32bit_t;
#else
typedef unsigned long		u32bit_t;
#endif
typedef u32bit_t		m68kaddr;	/* at least 32 bits */

#define WORDSIZE		2

extern char			*patchlevel;

extern FILE			*infp;
extern FILE			*outfp;
extern char			*cc[];
extern char			*bitd[];
extern char			*bitf[];
extern char			buf1[];
extern char			buf2[];
extern char			buf3[];

extern int			pass;
extern int			valid;
extern int			rtsflag;

extern m68kaddr			pc;
extern m68kaddr			ppc;
extern m68kaddr			initialpc;
extern int			chip;
extern int			lower;
extern int			pilamode;
extern int			codeonly;
extern int			seperator;
extern int			hexonly;
extern int			deconly;
extern int			verbose;
extern int			minlen;
extern int			onepass;
extern int			sp;
extern int			odd;
extern int			linkfallthrough;
extern int			use_isprint;
extern int			fdigits;
extern size_t			slenprint;
extern int			globalxref;
extern int			labelxref;
#ifndef NOBAD
extern int			dobad;
#endif
extern char			*afile;
extern char			*bfile;
extern char			*ffile;
extern char			*gfile;
extern char			*ifile;
extern char			*jfile;
extern char			*nfile;
extern char			*nsfile;
extern char			*tfile;

extern jmp_buf			jmp;
extern char			*sfile;
extern char			*vfile;

extern m68kaddr			curoffset;
extern short			flags;
extern m68kaddr			required[3];
extern int			pcrelative;

/************************************************************************/
/*	normal structures						*/
/************************************************************************/
struct inst {
	short			size;
	short			flags;
	m68kaddr		*required;
	short			labelnum;
	char			*labelname;
	short			labellines;
	short			eatype;
	short			ealabelnum;
};

struct globaluse {
	m68kaddr		addr;
	int			eatype;
};

struct global {
	long			offset;
	char			*name;
	struct globaluse	*used;
	int			numused;
	struct global		*next;
};

extern struct global		*globals;
extern struct inst		*insts;
extern m68kaddr			maxoffset;

/************************************************************************/
/*	effective address usage						*/
/************************************************************************/
#define EABRA			0x0001
#define EASUB			0x0002
#define EALD			0x0003
#define EARD			0x0004
#define EAWR			0x0005

/************************************************************************/
/*	the lowest 2 bits of flags hold the number of dependencies	*/
/*	so we start with 4 below.
/************************************************************************/
#define ISBRA			0x0004
#define ISBSR			0x0008
#define ISBRcc			0x0010
#define ISDBcc			0x0020
#define ISRTS			0x0040
#define ISJMP			0x0080
#define ISJSR			0x0100
#define ISLINK			0x0200
#define ISUNLK			0x0400
#define ISLABEL			0x0800
#define ISGOOD			0x1000
#define ISFPU			0x2000

/************************************************************************/
/*	these are overloaded for floating-point constants.		*/
/************************************************************************/
#define L_ISSINGLE		ISBRA
#define L_ISDOUBLE		ISBSR
#define L_ISEXTENDED		ISBRcc
#define L_ISPACKED		ISDBcc

extern m68kaddr			nextlabel(m68kaddr);

#ifdef DEBUG
extern int			debug;
#endif

struct cp {
	char			*prefix;
	void			(*gen)(m68kword);
	char			*(*cc)(unsigned int);
};

extern struct cp		coproc[];

/************************************************************************/
/*	pgen.c functions						*/
/************************************************************************/
extern void			pgen(m68kword);
extern char			*pcc(unsigned);

/************************************************************************/
/*	fgen.c functions						*/
/************************************************************************/
extern void			fgen(m68kword);
extern char			*fcc(unsigned);
extern int			flis2type(int);
extern int			ftype2lis(int);
extern size_t			fsizeof(int);

/************************************************************************/
/*	inst2.c functions						*/
/************************************************************************/
extern void			bit_dynamic(m68kword);
extern void			bit_static(m68kword);
extern void			biti_reg(const char *, int, const char *);
extern void			biti_size(const char *, m68kword);
extern void			cmp2_chk2(m68kword);
extern void			movep(m68kword);
extern void			cas(m68kword);
extern void			cas2(m68kword);
extern void			moves(m68kword);
extern void			move(m68kword, int);
extern void			misc_size(const char *, m68kword);
extern void			misc_ea(const char *, m68kword, int);
extern void			chk(m68kword);
extern void			lea(m68kword);
extern void			link(m68kword, int);
extern void			unlk(m68kword);
extern void			swap(m68kword);
extern void			bkpt(m68kword);
extern void			trap(m68kword);
extern void			stop_rtd(const char *);
extern void			movec(int);
extern void			ext(m68kword);
extern void			movereg(m68kword, const char *, int);
extern void			moveusp(m68kword, int);
extern void			movem(m68kword, int);
extern void			dbcc(m68kword);
extern void			trapcc(m68kword);
extern void			scc(m68kword);
extern void			pack_unpk(const char *, m68kword);
extern void			addq_subq(m68kword);
extern void			op1(const char *, m68kword);
extern void			op2(const char *, m68kword);
extern void			op2long(const char *, m68kword);
extern void			opa(const char *, m68kword);
extern void			opx(const char *, m68kword, int, int);
extern void			exg(m68kword, char, char);
extern void			bitfield(m68kword);
extern void			getshiftname(char *, int, int);
extern void			shift(m68kword);
extern void			cptrapcc(struct cp *, m68kword);
extern void			cpdbcc(struct cp *, m68kword);
extern void			cpbcc(struct cp *, m68kword);
extern void			cpscc(struct cp *, m68kword);
extern void			cpsave(const char *, m68kword);
extern void			cprestore(const char *, m68kword);

/************************************************************************/
/*	inst1.c functions						*/
/************************************************************************/
extern void			bit_movep_immediate(m68kword);
extern void			movebyte(m68kword);
extern void			movelong(m68kword);
extern void			moveword(m68kword);
extern void			misc(m68kword);
extern void			addq_subq_scc_dbcc_trapcc(m68kword);
extern int			bcc_bsr(m68kword);
extern void			moveq(m68kword);
extern void			or_div_sbcd(m68kword);
extern void			sub_subx(m68kword);
extern void			aline(m68kword);
extern void			cmp_eor(m68kword);
extern void			and_mul_abcd_exg(m68kword);
extern void			add_addx(m68kword);
extern void			shift_rotate_bitfield(m68kword);
extern void			coprocessor(m68kword);
extern void			fline(m68kword);

/************************************************************************/
/*	afline.c functions						*/
/************************************************************************/
extern char			*trapname(long);

/************************************************************************/
/*	utils.c functions						*/
/************************************************************************/
extern char			*labelname(m68kaddr);
extern struct global		*addglobal(long, char*);
extern char			*useglobal(long, m68kaddr, int);
extern char			*globalname(long);
extern int			immsprintf(char *, long);
extern long			signextend(long, int);
extern int			nextword(m68kword *);
extern long			getval(int, int *);
extern char			*Areg(int);
extern void			Areg2(char [], char, int);
extern int			fpoint(u32bit_t *, int, char *);
extern int			getea(char *, int, int, int, int);
extern void			instprint(int, const char *, ...);
extern char			*regbyte(char *, unsigned char, char *, int);
extern void			revbits(unsigned long *, size_t);

/************************************************************************/
/*	dis.c functions							*/
/************************************************************************/
extern void			jumpfree(void);
extern void			disassemble(void);
extern void			rotdash(int);

#endif /* DIS_H */
