-module(megaco_text_parser_prev3c).
-export([parse/1, parse_and_scan/1, format_error/1]).
-file("megaco_text_parser_prev3c.yrl", 1653).

%% The following directive is needed for (significantly) faster compilation
%% of the generated .erl file by the HiPE compiler.  Please do not remove.
-compile([{hipe,[{regalloc,linear_scan}]}]).

-include("megaco_text_parser_prev3c.hrl").



-file("/ldisk/daily_build/otp_prebuild_r11b.2007-06-11_19/otp_src_R11B-5/bootstrap/lib/parsetools/include/yeccpre.hrl", 0).
%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved via the world wide web at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Initial Developer of the Original Code is Ericsson Utvecklings AB.
%% Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
%% AB. All Rights Reserved.''
%% 
%%     $Id $
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The parser generator will insert appropriate declarations before this line.%

parse(Tokens) ->
    yeccpars0(Tokens, false).

parse_and_scan({F, A}) -> % Fun or {M, F}
    yeccpars0([], {F, A});
parse_and_scan({M, F, A}) ->
    yeccpars0([], {{M, F}, A}).

format_error(Message) ->
    case io_lib:deep_char_list(Message) of
	true ->
	    Message;
	_ ->
	    io_lib:write(Message)
    end.

% To be used in grammar files to throw an error message to the parser
% toplevel. Doesn't have to be exported!
-compile({nowarn_unused_function,{return_error,2}}).
return_error(Line, Message) ->
    throw({error, {Line, ?MODULE, Message}}).

yeccpars0(Tokens, MFA) ->
    try yeccpars1(Tokens, MFA, 0, [], [])
    catch 
        throw: {error, {_Line, ?MODULE, _M}} = Error -> 
                   Error % probably from return_error/1
    end.

% Don't change yeccpars1/6 too much, it is called recursively by yeccpars2/8!
yeccpars1([Token | Tokens], Tokenizer, State, States, Vstack) ->
    yeccpars2(State, element(1, Token), States, Vstack, Token, Tokens,
	      Tokenizer);
yeccpars1([], {F, A}, State, States, Vstack) ->
    case apply(F, A) of
        {ok, Tokens, _Endline} ->
	    yeccpars1(Tokens, {F, A}, State, States, Vstack);
        {eof, _Endline} ->
            yeccpars1([], false, State, States, Vstack);
        {error, Descriptor, _Endline} ->
            {error, Descriptor}
    end;
yeccpars1([], false, State, States, Vstack) ->
    yeccpars2(State, '$end', States, Vstack, {'$end', 999999}, [], false).

% For internal use only.
yeccerror(Token) ->
    {error,
     {element(2, Token), ?MODULE,
      ["syntax error before: ", yecctoken2string(Token)]}}.

yecctoken2string({atom, _, A}) -> io_lib:write(A);
yecctoken2string({integer,_,N}) -> io_lib:write(N);
yecctoken2string({float,_,F}) -> io_lib:write(F);
yecctoken2string({char,_,C}) -> io_lib:write_char(C);
yecctoken2string({var,_,V}) -> io_lib:format('~s', [V]);
yecctoken2string({string,_,S}) -> io_lib:write_string(S);
yecctoken2string({reserved_symbol, _, A}) -> io_lib:format('~w', [A]);
yecctoken2string({_Cat, _, Val}) -> io_lib:format('~w', [Val]);
yecctoken2string({'dot', _}) -> io_lib:format('~w', ['.']);
yecctoken2string({'$end', _}) ->
    [];
yecctoken2string({Other, _}) when is_atom(Other) ->
    io_lib:format('~w', [Other]);
yecctoken2string(Other) ->
    io_lib:write(Other).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



-file("./megaco_text_parser_prev3c.erl", 106).

yeccpars2(0, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [0 | __Ss], [__T | __Stack]);
yeccpars2(0, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_0_(__Stack),
 yeccpars2(1, __Cat, [0 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(1, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 5, [1 | __Ss], [__T | __Stack]);
yeccpars2(1, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_1_(__Stack),
 yeccpars2(4, __Cat, [1 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(2, '$end', _, __Stack, _, _, _) ->
 {ok, hd(__Stack)};
yeccpars2(2, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(3, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_3_(__Stack),
 yeccpars2(yeccgoto(optSep, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(4, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(5, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 6, [5 | __Ss], [__T | __Stack]);
yeccpars2(5, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(6, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(7, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [7 | __Ss], [__T | __Stack]);
yeccpars2(7, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(8, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_8_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(9, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_9_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(10, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_10_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(11, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_11_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(12, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_12_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(13, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_13_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(14, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_14_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(15, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_15_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(16, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_16_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(17, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_17_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(18, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_18_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(19, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_19_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(20, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_20_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(21, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_21_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(22, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_22_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(23, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_23_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(24, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_24_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(25, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_25_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(26, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_26_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(27, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_27_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(28, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_28_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(29, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_29_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(30, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_30_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(31, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_31_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(32, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_32_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(33, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_33_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(34, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_34_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(35, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_35_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(36, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_36_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(37, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_37_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(38, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_38_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(39, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_39_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(40, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_40_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(41, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_41_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(42, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_42_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(43, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_43_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(44, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_44_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(45, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_45_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(46, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_46_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(47, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_47_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(48, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_48_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(49, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_49_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(50, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_50_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(51, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_51_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(52, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_52_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(53, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_53_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(54, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_54_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(55, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_55_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(56, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_56_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(57, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_57_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(58, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_58_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(59, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_59_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(60, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_60_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(61, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_61_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(62, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_62_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(63, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_63_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(64, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_64_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(65, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_65_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(66, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_66_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(67, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_67_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(68, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_68_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(69, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_69_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(70, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_70_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(71, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_71_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(72, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_72_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(73, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_73_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(74, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_74_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(75, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_75_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(76, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_76_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(77, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_77_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(78, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_78_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(79, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_79_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(80, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [80 | __Ss], [__T | __Stack]);
yeccpars2(80, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(81, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [81 | __Ss], [__T | __Stack]);
yeccpars2(81, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(82, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [82 | __Ss], [__T | __Stack]);
yeccpars2(82, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(83, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [83 | __Ss], [__T | __Stack]);
yeccpars2(83, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_83_(__Stack),
 yeccpars2(84, __Cat, [83 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(84, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_84_(__Stack),
 __Nss = lists:nthtail(7, __Ss),
 yeccpars2(yeccgoto(authenticationHeader, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(85, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [85 | __Ss], [__T | __Stack]);
yeccpars2(85, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [85 | __Ss], [__T | __Stack]);
yeccpars2(85, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [85 | __Ss], [__T | __Stack]);
yeccpars2(85, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_85_(__Stack),
 yeccpars2(88, __Cat, [85 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(86, endOfMessage, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [86 | __Ss], [__T | __Stack]);
yeccpars2(86, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(87, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_87_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(megacoMessage, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(88, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'MtpAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 958, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(89, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 117, [89 | __Ss], [__T | __Stack]);
yeccpars2(89, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 118, [89 | __Ss], [__T | __Stack]);
yeccpars2(89, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 119, [89 | __Ss], [__T | __Stack]);
yeccpars2(89, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 120, [89 | __Ss], [__T | __Stack]);
yeccpars2(89, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 121, [89 | __Ss], [__T | __Stack]);
yeccpars2(89, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(90, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(91, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(92, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [92 | __Ss], [__T | __Stack]);
yeccpars2(92, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(93, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_93_(__Stack),
 yeccpars2(95, __Cat, [93 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(94, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_94_(__Stack),
 yeccpars2(103, __Cat, [94 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(95, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(96, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_96_(__Stack),
 yeccpars2(97, __Cat, [96 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(97, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_97_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(98, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [98 | __Ss], [__T | __Stack]);
yeccpars2(98, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_98_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(99, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [99 | __Ss], [__T | __Stack]);
yeccpars2(99, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(100, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_100_(__Stack),
 yeccpars2(yeccgoto(portNumber, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(101, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_101_(__Stack),
 yeccpars2(102, __Cat, [101 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(102, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_102_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(103, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_103_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(104, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 105, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(105, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 106, [105 | __Ss], [__T | __Stack]);
yeccpars2(105, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_105_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(106, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(107, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_107_(__Stack),
 yeccpars2(108, __Cat, [107 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(108, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_108_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(109, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_109_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(110, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_110_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(111, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_111_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(112, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_112_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(113, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_113_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(114, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 118, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 119, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 120, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 121, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_114_(__Stack),
 yeccpars2(yeccgoto(transactionList, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(115, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_115_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(message, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(116, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_116_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(117, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 887, [117 | __Ss], [__T | __Stack]);
yeccpars2(117, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(118, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 949, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(119, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 817, [119 | __Ss], [__T | __Stack]);
yeccpars2(119, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(120, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 809, [120 | __Ss], [__T | __Stack]);
yeccpars2(120, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(121, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 122, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 123, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(122, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 801, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(123, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 125, [123 | __Ss], [__T | __Stack]);
yeccpars2(123, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(124, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 795, [124 | __Ss], [__T | __Stack]);
yeccpars2(124, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_124_(__Stack),
 yeccpars2(794, __Cat, [124 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(125, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 126, [125 | __Ss], [__T | __Stack]);
yeccpars2(125, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(126, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(127, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_127_(__Stack),
 yeccpars2(yeccgoto(contextID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(128, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 129, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(129, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 145, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 146, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 147, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 148, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 149, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 150, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 151, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 152, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 153, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 154, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 155, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 156, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 157, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 158, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 159, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(130, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_130_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(131, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(132, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(133, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_133_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(134, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(135, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_135_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(136, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_136_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(137, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_137_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(138, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(139, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_139_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(140, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(141, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 567, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(142, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(143, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 564, [143 | __Ss], [__T | __Stack]);
yeccpars2(143, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_143_(__Stack),
 yeccpars2(563, __Cat, [143 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(144, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 562, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(145, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_145_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(146, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 559, [146 | __Ss], [__T | __Stack]);
yeccpars2(146, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(147, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 556, [147 | __Ss], [__T | __Stack]);
yeccpars2(147, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(148, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 555, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(149, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 504, [149 | __Ss], [__T | __Stack]);
yeccpars2(149, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(150, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_150_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(151, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_151_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(152, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 500, [152 | __Ss], [__T | __Stack]);
yeccpars2(152, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(153, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_153_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(154, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_154_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(155, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 464, [155 | __Ss], [__T | __Stack]);
yeccpars2(155, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(156, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 462, [156 | __Ss], [__T | __Stack]);
yeccpars2(156, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(157, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 412, [157 | __Ss], [__T | __Stack]);
yeccpars2(157, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(158, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 180, [158 | __Ss], [__T | __Stack]);
yeccpars2(158, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(159, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 160, [159 | __Ss], [__T | __Stack]);
yeccpars2(159, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(160, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OnewayBothToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 168, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OnewayExternalToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 169, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 170, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 171, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(161, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(topologyDescComp, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(162, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 176, [162 | __Ss], [__T | __Stack]);
yeccpars2(162, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_162_(__Stack),
 yeccpars2(175, __Cat, [162 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(163, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_163_(__Stack),
 yeccpars2(yeccgoto(topologyDescComp, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(164, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_164_(__Stack),
 yeccpars2(yeccgoto(terminationID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(165, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_165_(__Stack),
 yeccpars2(yeccgoto(topologyDescComp, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(166, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_166_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(167, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_167_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(168, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_168_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(169, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_169_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(170, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_170_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(171, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 172, [171 | __Ss], [__T | __Stack]);
yeccpars2(171, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_171_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(172, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(173, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_173_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(eventStream, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(174, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_174_(__Stack),
 yeccpars2(yeccgoto(streamID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(175, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 179, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(176, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnewayBothToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 168, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnewayExternalToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 169, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 170, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 171, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(177, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 176, [177 | __Ss], [__T | __Stack]);
yeccpars2(177, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_177_(__Stack),
 yeccpars2(178, __Cat, [177 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(178, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_178_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(topologyDescCompList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(179, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_179_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(180, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [180 | __Ss], [__T | __Stack]);
yeccpars2(180, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(181, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_181_(__Stack),
 yeccpars2(yeccgoto(termIDList, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(182, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_182_(__Stack),
 yeccpars2(190, __Cat, [182 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(183, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(184, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_184_(__Stack),
 yeccpars2(185, __Cat, [184 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(185, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 189, [185 | __Ss], [__T | __Stack]);
yeccpars2(185, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(186, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(187, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [187 | __Ss], [__T | __Stack]);
yeccpars2(187, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_187_(__Stack),
 yeccpars2(188, __Cat, [187 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(188, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_188_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(terminationIDListRepeat, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(189, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_189_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(termIDList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(190, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_190_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(subtractRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(191, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 193, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(192, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 411, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(193, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 194, [193 | __Ss], [__T | __Stack]);
yeccpars2(193, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(194, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_194_(__Stack),
 yeccpars2(206, __Cat, [194 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(195, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_195_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(196, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_196_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(197, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_197_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(198, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_198_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(199, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_199_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(200, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_200_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(201, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_201_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(202, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_202_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(203, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 403, [203 | __Ss], [__T | __Stack]);
yeccpars2(203, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_203_(__Stack),
 yeccpars2(402, __Cat, [203 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(204, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(205, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 399, [205 | __Ss], [__T | __Stack]);
yeccpars2(205, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_205_(__Stack),
 yeccpars2(398, __Cat, [205 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(206, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 397, [206 | __Ss], [__T | __Stack]);
yeccpars2(206, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(207, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_207_(__Stack),
 yeccpars2(yeccgoto(indAuddigitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(208, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_208_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(209, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 386, [209 | __Ss], [__T | __Stack]);
yeccpars2(209, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_209_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(210, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 377, [210 | __Ss], [__T | __Stack]);
yeccpars2(210, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 378, [210 | __Ss], [__T | __Stack]);
yeccpars2(210, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_210_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(211, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 317, [211 | __Ss], [__T | __Stack]);
yeccpars2(211, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_211_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(212, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_212_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(213, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_213_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(214, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_214_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(215, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 313, [215 | __Ss], [__T | __Stack]);
yeccpars2(215, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_215_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(216, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 223, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_216_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(217, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 218, [217 | __Ss], [__T | __Stack]);
yeccpars2(217, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_217_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(218, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(219, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_219_(__Stack),
 yeccpars2(yeccgoto(pkgdName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(220, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 221, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(221, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_221_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudstatisticsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(222, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_222_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudsignalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(223, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 229, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 230, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(224, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_224_(__Stack),
 yeccpars2(yeccgoto(indAudsignalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(225, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 239, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_225_(__Stack),
 yeccpars2(yeccgoto(signalRequest, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(226, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalName, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(227, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 238, [227 | __Ss], [__T | __Stack]);
yeccpars2(227, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(228, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_228_(__Stack),
 yeccpars2(yeccgoto(indAudsignalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(229, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_229_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(optIndAudsignalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(230, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 231, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_230_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(231, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(232, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 234, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_232_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudsignalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(233, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_233_(__Stack),
 yeccpars2(yeccgoto(signalListId, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(234, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(235, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalListParm, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(236, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 237, [236 | __Ss], [__T | __Stack]);
yeccpars2(236, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(237, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_237_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudsignalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(238, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_238_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optIndAudsignalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(239, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 242, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 243, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'IntsigDelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 246, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 247, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 248, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 249, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(240, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 309, [240 | __Ss], [__T | __Stack]);
yeccpars2(240, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_240_(__Stack),
 yeccpars2(308, __Cat, [240 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(241, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 285, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(242, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 277, [242 | __Ss], [__T | __Stack]);
yeccpars2(242, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_242_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(243, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 275, [243 | __Ss], [__T | __Stack]);
yeccpars2(243, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_243_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(244, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 273, [244 | __Ss], [__T | __Stack]);
yeccpars2(244, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(245, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_245_COMMA(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'COMMA', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(245, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_245_RBRKT(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'RBRKT', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(245, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_245_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(246, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 260, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_246_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(247, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 257, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_247_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(248, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 252, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_248_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(249, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 250, [249 | __Ss], [__T | __Stack]);
yeccpars2(249, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_249_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(250, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(251, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_251_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(252, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [252 | __Ss], [__T | __Stack]);
yeccpars2(252, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 255, [252 | __Ss], [__T | __Stack]);
yeccpars2(252, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 256, [252 | __Ss], [__T | __Stack]);
yeccpars2(252, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(253, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_253_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(254, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_254_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(255, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_255_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(256, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_256_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(257, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(258, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_258_(__Stack),
 yeccpars2(yeccgoto(requestID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(259, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_259_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(260, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 261, [260 | __Ss], [__T | __Stack]);
yeccpars2(260, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(261, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 263, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'IterationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 265, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 267, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(262, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 269, [262 | __Ss], [__T | __Stack]);
yeccpars2(262, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_262_(__Stack),
 yeccpars2(268, __Cat, [262 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(263, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_263_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(264, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_264_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(265, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_265_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(266, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_266_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(267, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_267_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(268, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 272, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(269, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 263, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'IterationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 265, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 267, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(270, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 269, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_270_(__Stack),
 yeccpars2(271, __Cat, [270 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(271, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_271_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(notificationReasons, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(272, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_272_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(273, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(274, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_274_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(275, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(276, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_276_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(277, 'BothToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 279, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ExternalToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 280, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'InternalToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 281, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(278, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_278_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(279, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_279_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(280, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_280_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(281, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_281_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(282, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_282_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(283, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 294, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 295, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(284, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(285, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(286, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(287, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_287_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(288, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_288_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(289, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_289_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(290, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_290_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(291, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_291_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(292, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_292_(__Stack),
 yeccpars2(yeccgoto(alternativeValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(293, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_293_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(294, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(295, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(296, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 298, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 299, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_296_(__Stack),
 yeccpars2(297, __Cat, [296 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(297, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 304, [297 | __Ss], [__T | __Stack]);
yeccpars2(297, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(298, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(299, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(300, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 299, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_300_(__Stack),
 yeccpars2(301, __Cat, [300 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(301, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_301_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(valueList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(302, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 303, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(303, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_303_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(304, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_304_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(305, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 299, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_305_(__Stack),
 yeccpars2(306, __Cat, [305 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(306, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 307, [306 | __Ss], [__T | __Stack]);
yeccpars2(306, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(307, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_307_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(308, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 312, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(309, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 242, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 243, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'IntsigDelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 246, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 247, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 248, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 249, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(310, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 309, [310 | __Ss], [__T | __Stack]);
yeccpars2(310, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_310_(__Stack),
 yeccpars2(311, __Cat, [310 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(311, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_311_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(312, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_312_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(313, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(314, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_314_(__Stack),
 yeccpars2(yeccgoto(packagesItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(315, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 316, [315 | __Ss], [__T | __Stack]);
yeccpars2(315, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(316, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_316_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudpackagesDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(317, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 324, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 325, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 326, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 327, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 328, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 329, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(318, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_318_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(319, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_319_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(320, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_320_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(321, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_321_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(322, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 373, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_322_(__Stack),
 yeccpars2(372, __Cat, [322 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(323, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_323_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(324, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 351, [324 | __Ss], [__T | __Stack]);
yeccpars2(324, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(325, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_325_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(326, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_326_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(327, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 218, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(328, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 346, [328 | __Ss], [__T | __Stack]);
yeccpars2(328, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(329, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 330, [329 | __Ss], [__T | __Stack]);
yeccpars2(329, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(330, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 335, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 336, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(331, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_331_(__Stack),
 yeccpars2(yeccgoto(indAudterminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(332, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 285, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_332_(__Stack),
 yeccpars2(yeccgoto(indAudterminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(333, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 344, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(334, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(indAudterminationStateParm, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(335, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_335_(__Stack),
 yeccpars2(yeccgoto(indAudterminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(336, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 337, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'INEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 338, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_336_(__Stack),
 yeccpars2(yeccgoto(iaServiceStates, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(337, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 340, [337 | __Ss], [__T | __Stack]);
yeccpars2(337, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 341, [337 | __Ss], [__T | __Stack]);
yeccpars2(337, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 342, [337 | __Ss], [__T | __Stack]);
yeccpars2(337, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(338, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 340, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 341, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 342, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(339, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_339_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(iaServiceStates, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(340, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_340_(__Stack),
 yeccpars2(yeccgoto(serviceStatesValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(341, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_341_(__Stack),
 yeccpars2(yeccgoto(serviceStatesValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(342, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_342_(__Stack),
 yeccpars2(yeccgoto(serviceStatesValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(343, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_343_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(iaServiceStates, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(344, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_344_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudterminationStateDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(345, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_345_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(propertyParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(346, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(347, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 348, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(348, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 324, [348 | __Ss], [__T | __Stack]);
yeccpars2(348, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 325, [348 | __Ss], [__T | __Stack]);
yeccpars2(348, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 326, [348 | __Ss], [__T | __Stack]);
yeccpars2(348, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 327, [348 | __Ss], [__T | __Stack]);
yeccpars2(348, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(349, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 350, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(350, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_350_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudstreamDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(351, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 355, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 356, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 357, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(352, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_352_(__Stack),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(353, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [353 | __Ss], [__T | __Stack]);
yeccpars2(353, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [353 | __Ss], [__T | __Stack]);
yeccpars2(353, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 285, [353 | __Ss], [__T | __Stack]);
yeccpars2(353, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [353 | __Ss], [__T | __Stack]);
yeccpars2(353, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_353_(__Stack),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(354, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 368, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_354_(__Stack),
 yeccpars2(367, __Cat, [354 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(355, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 358, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'INEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 359, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_355_(__Stack),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(356, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_356_(__Stack),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(357, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_357_(__Stack),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(358, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 361, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 362, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 363, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 364, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 365, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(359, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 361, [359 | __Ss], [__T | __Stack]);
yeccpars2(359, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 362, [359 | __Ss], [__T | __Stack]);
yeccpars2(359, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 363, [359 | __Ss], [__T | __Stack]);
yeccpars2(359, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 364, [359 | __Ss], [__T | __Stack]);
yeccpars2(359, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 365, [359 | __Ss], [__T | __Stack]);
yeccpars2(359, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(360, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_360_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(361, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_361_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(362, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_362_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(363, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_363_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(364, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_364_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(365, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_365_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(366, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_366_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(367, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 371, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(368, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 355, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 356, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 357, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(369, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 368, [369 | __Ss], [__T | __Stack]);
yeccpars2(369, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_369_(__Stack),
 yeccpars2(370, __Cat, [369 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(370, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_370_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudlocalParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(371, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_371_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudlocalControlDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(372, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 376, [372 | __Ss], [__T | __Stack]);
yeccpars2(372, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(373, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 324, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 325, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 326, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 327, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 328, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 329, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(374, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 373, [374 | __Ss], [__T | __Stack]);
yeccpars2(374, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_374_(__Stack),
 yeccpars2(375, __Cat, [374 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(375, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_375_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudmediaParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(376, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_376_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudmediaDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(377, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(378, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(379, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(indAudrequestedEvent, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(380, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 381, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(381, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_381_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudeventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(382, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 383, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(383, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(384, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 385, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(385, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_385_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudeventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(386, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(387, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 391, [387 | __Ss], [__T | __Stack]);
yeccpars2(387, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_387_(__Stack),
 yeccpars2(390, __Cat, [387 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(388, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 389, [388 | __Ss], [__T | __Stack]);
yeccpars2(388, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(389, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_389_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudeventBufferDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(390, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_390_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudeventSpec, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(391, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 171, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(392, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_392_(__Stack),
 yeccpars2(yeccgoto(eventParameterName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(393, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 396, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(394, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_394_(__Stack),
 yeccpars2(yeccgoto(indAudeventSpecParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(395, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_395_(__Stack),
 yeccpars2(yeccgoto(indAudeventSpecParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(396, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_396_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optIndAudeventSpecParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(397, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_397_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(398, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_398_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(auditDescriptorBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(399, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(400, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 399, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_400_(__Stack),
 yeccpars2(401, __Cat, [400 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(401, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_401_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(auditItemList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(402, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_402_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudterminationAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(403, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 405, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 406, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 407, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 408, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 409, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 327, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(404, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 403, [404 | __Ss], [__T | __Stack]);
yeccpars2(404, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_404_(__Stack),
 yeccpars2(410, __Cat, [404 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(405, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 386, [405 | __Ss], [__T | __Stack]);
yeccpars2(405, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(406, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 377, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 378, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(407, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 317, [407 | __Ss], [__T | __Stack]);
yeccpars2(407, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(408, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 313, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(409, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 223, [409 | __Ss], [__T | __Stack]);
yeccpars2(409, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(410, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_410_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudterminationAuditList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(411, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_411_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optAuditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(412, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(413, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 414, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(414, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 416, [414 | __Ss], [__T | __Stack]);
yeccpars2(414, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(415, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 461, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(416, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 417, [416 | __Ss], [__T | __Stack]);
yeccpars2(416, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(417, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 431, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 432, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 433, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 434, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 435, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 436, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ServiceChangeIncompleteToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 437, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 438, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 439, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(418, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_418_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(419, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_419_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(420, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_420_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(421, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_421_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(422, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 457, [422 | __Ss], [__T | __Stack]);
yeccpars2(422, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_422_(__Stack),
 yeccpars2(456, __Cat, [422 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(423, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_423_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(424, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_424_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(425, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_425_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(426, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_426_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(427, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_427_(__Stack),
 yeccpars2(yeccgoto(extensionParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(428, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [428 | __Ss], [__T | __Stack]);
yeccpars2(428, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [428 | __Ss], [__T | __Stack]);
yeccpars2(428, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 285, [428 | __Ss], [__T | __Stack]);
yeccpars2(428, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [428 | __Ss], [__T | __Stack]);
yeccpars2(428, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(429, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_429_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(430, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_430_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(431, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 453, [431 | __Ss], [__T | __Stack]);
yeccpars2(431, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_431_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(432, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 451, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_432_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(433, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 449, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_433_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(434, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 447, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_434_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(435, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 445, [435 | __Ss], [__T | __Stack]);
yeccpars2(435, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_435_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(436, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 442, [436 | __Ss], [__T | __Stack]);
yeccpars2(436, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_436_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(437, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_437_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(438, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_438_(__Stack),
 yeccpars2(yeccgoto(timeStamp, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(439, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 440, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_439_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(440, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(441, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_441_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeVersion, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(442, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_442_(__Stack),
 yeccpars2(88, __Cat, [442 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(443, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_443_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(444, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_444_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(445, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(446, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_446_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeReason, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(447, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(448, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_448_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeProfile, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(449, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [449 | __Ss], [__T | __Stack]);
yeccpars2(449, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [449 | __Ss], [__T | __Stack]);
yeccpars2(449, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [449 | __Ss], [__T | __Stack]);
yeccpars2(449, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_449_(__Stack),
 yeccpars2(88, __Cat, [449 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(450, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_450_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMgcId, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(451, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(452, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_452_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMethod, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(453, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(454, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_454_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeDelay, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(455, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_455_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(extension, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(456, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 460, [456 | __Ss], [__T | __Stack]);
yeccpars2(456, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(457, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 431, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 432, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 433, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 434, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 435, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 436, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ServiceChangeIncompleteToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 437, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 438, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 439, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(458, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 457, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_458_(__Stack),
 yeccpars2(459, __Cat, [458 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(459, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_459_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(460, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_460_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(serviceChangeDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(461, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_461_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(serviceChangeRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(462, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(463, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_463_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(priority, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(464, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(465, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 466, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(466, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 117, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 470, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(467, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_467_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(468, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 499, [468 | __Ss], [__T | __Stack]);
yeccpars2(468, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(469, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_469_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(470, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 471, [470 | __Ss], [__T | __Stack]);
yeccpars2(470, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(471, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(472, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 473, [472 | __Ss], [__T | __Stack]);
yeccpars2(472, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(473, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 438, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_473_(__Stack),
 yeccpars2(475, __Cat, [473 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(474, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [474 | __Ss], [__T | __Stack]);
yeccpars2(474, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_474_(__Stack),
 yeccpars2(494, __Cat, [474 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(475, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(476, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 478, [476 | __Ss], [__T | __Stack]);
yeccpars2(476, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_476_(__Stack),
 yeccpars2(477, __Cat, [476 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(477, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 481, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(478, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 438, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_478_(__Stack),
 yeccpars2(475, __Cat, [478 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(479, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 478, [479 | __Ss], [__T | __Stack]);
yeccpars2(479, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_479_(__Stack),
 yeccpars2(480, __Cat, [479 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(480, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_480_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvents, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(481, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_481_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(observedEventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(482, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 484, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_482_(__Stack),
 yeccpars2(483, __Cat, [482 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(483, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_483_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(484, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(485, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 490, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_485_(__Stack),
 yeccpars2(489, __Cat, [485 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(486, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(observedEventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(487, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [487 | __Ss], [__T | __Stack]);
yeccpars2(487, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [487 | __Ss], [__T | __Stack]);
yeccpars2(487, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 285, [487 | __Ss], [__T | __Stack]);
yeccpars2(487, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [487 | __Ss], [__T | __Stack]);
yeccpars2(487, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(488, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_488_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(eventStreamOrOther, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(489, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 493, [489 | __Ss], [__T | __Stack]);
yeccpars2(489, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(490, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(491, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 490, [491 | __Ss], [__T | __Stack]);
yeccpars2(491, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_491_(__Stack),
 yeccpars2(492, __Cat, [491 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(492, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_492_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEventParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(493, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_493_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(observedEventBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(494, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 495, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(495, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_495_(__Stack),
 yeccpars2(496, __Cat, [495 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(496, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(497, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 484, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_497_(__Stack),
 yeccpars2(498, __Cat, [497 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(498, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_498_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(499, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_499_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(notifyRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(500, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 502, [500 | __Ss], [__T | __Stack]);
yeccpars2(500, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 503, [500 | __Ss], [__T | __Stack]);
yeccpars2(500, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(501, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_501_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(iepsValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(502, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_502_(__Stack),
 yeccpars2(yeccgoto(onOrOff, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(503, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_503_(__Stack),
 yeccpars2(yeccgoto(onOrOff, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(504, 'AndAUDITselectToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 514, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 515, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 516, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'EmergencyValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 517, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 518, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OrAUDITselectToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 519, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 520, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 521, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(505, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_505_(__Stack),
 yeccpars2(yeccgoto(contextAuditSelector, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(506, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_506_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(507, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 554, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(508, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_508_(__Stack),
 yeccpars2(yeccgoto(contextAuditSelector, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(509, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_509_(__Stack),
 yeccpars2(yeccgoto(contextAuditSelector, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(510, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(511, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 541, [511 | __Ss], [__T | __Stack]);
yeccpars2(511, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_511_(__Stack),
 yeccpars2(552, __Cat, [511 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(512, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(contextAuditSelector, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(513, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_513_(__Stack),
 yeccpars2(yeccgoto(contextAuditSelector, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(514, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_514_(__Stack),
 yeccpars2(yeccgoto(auditSelectLogic, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(515, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 525, [515 | __Ss], [__T | __Stack]);
yeccpars2(515, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(516, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_516_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(517, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 522, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(518, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 500, [518 | __Ss], [__T | __Stack]);
yeccpars2(518, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_518_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(519, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_519_(__Stack),
 yeccpars2(yeccgoto(auditSelectLogic, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(520, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 462, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_520_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(521, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_521_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(522, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 523, [522 | __Ss], [__T | __Stack]);
yeccpars2(522, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 524, [522 | __Ss], [__T | __Stack]);
yeccpars2(522, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(523, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_523_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(emergencyValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(524, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_524_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(emergencyValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(525, 'AndAUDITselectToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 514, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 148, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ContextListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 531, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 516, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'EmergencyValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 517, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 518, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'OrAUDITselectToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 519, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 520, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 521, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(526, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 551, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(527, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 547, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_527_(__Stack),
 yeccpars2(546, __Cat, [527 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(528, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 285, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_528_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(529, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 545, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(530, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 541, [530 | __Ss], [__T | __Stack]);
yeccpars2(530, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_530_(__Stack),
 yeccpars2(540, __Cat, [530 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(531, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 532, [531 | __Ss], [__T | __Stack]);
yeccpars2(531, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(532, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 533, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(533, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(534, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 536, [534 | __Ss], [__T | __Stack]);
yeccpars2(534, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_534_(__Stack),
 yeccpars2(535, __Cat, [534 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(535, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 539, [535 | __Ss], [__T | __Stack]);
yeccpars2(535, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(536, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(537, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 536, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_537_(__Stack),
 yeccpars2(538, __Cat, [537 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(538, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_538_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(contextIDs, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(539, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_539_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(contextIdList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(540, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 544, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(541, 'AndAUDITselectToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 514, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 148, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 516, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'EmergencyValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 517, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 518, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'OrAUDITselectToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 519, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 520, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 521, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(542, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 541, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_542_(__Stack),
 yeccpars2(543, __Cat, [542 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(543, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_543_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(contextAuditProperties, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(544, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_544_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudcontextAttrDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(545, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_545_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(contextAttrDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(546, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_546_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(propertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(547, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(548, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 547, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_548_(__Stack),
 yeccpars2(550, __Cat, [548 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(549, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [549 | __Ss], [__T | __Stack]);
yeccpars2(549, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [549 | __Ss], [__T | __Stack]);
yeccpars2(549, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 285, [549 | __Ss], [__T | __Stack]);
yeccpars2(549, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [549 | __Ss], [__T | __Stack]);
yeccpars2(549, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(550, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_550_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(propertyParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(551, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_551_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(contextAttrDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(552, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 553, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(553, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_553_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(contextAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(554, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_554_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(contextAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(555, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ContextListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 531, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(556, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(557, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_557_(__Stack),
 yeccpars2(558, __Cat, [557 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(558, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_558_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(559, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(560, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [560 | __Ss], [__T | __Stack]);
yeccpars2(560, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_560_(__Stack),
 yeccpars2(561, __Cat, [560 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(561, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_561_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(562, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_562_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(actionRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(563, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_563_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(actionRequestBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(564, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 145, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 146, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 147, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 148, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 149, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 150, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 151, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 152, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 153, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 154, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 155, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 156, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 157, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 158, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 159, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(565, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 564, [565 | __Ss], [__T | __Stack]);
yeccpars2(565, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_565_(__Stack),
 yeccpars2(566, __Cat, [565 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(566, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_566_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(actionRequestItems, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(567, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(568, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 570, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_568_(__Stack),
 yeccpars2(569, __Cat, [568 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(569, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_569_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(ammRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(570, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 193, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 581, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 582, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 583, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 584, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 585, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 586, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 587, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 588, [570 | __Ss], [__T | __Stack]);
yeccpars2(570, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(571, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_571_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(572, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_572_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(573, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_573_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(574, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_574_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(575, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_575_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(576, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_576_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(577, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_577_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(578, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_578_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(579, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_579_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(580, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 790, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_580_(__Stack),
 yeccpars2(789, __Cat, [580 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(581, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_581_(__Stack),
 yeccpars2(yeccgoto(digitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(582, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 781, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_582_(__Stack),
 yeccpars2(yeccgoto(eventBufferDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(583, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 707, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_583_(__Stack),
 yeccpars2(yeccgoto(eventsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(584, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 646, [584 | __Ss], [__T | __Stack]);
yeccpars2(584, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(585, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 630, [585 | __Ss], [__T | __Stack]);
yeccpars2(585, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 631, [585 | __Ss], [__T | __Stack]);
yeccpars2(585, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(586, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 622, [586 | __Ss], [__T | __Stack]);
yeccpars2(586, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(587, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 603, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_587_(__Stack),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(588, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 589, [588 | __Ss], [__T | __Stack]);
yeccpars2(588, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(589, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(590, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 599, [590 | __Ss], [__T | __Stack]);
yeccpars2(590, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_590_(__Stack),
 yeccpars2(598, __Cat, [590 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(591, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 592, [591 | __Ss], [__T | __Stack]);
yeccpars2(591, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_591_(__Stack),
 yeccpars2(yeccgoto(statisticsParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(592, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 594, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(593, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_593_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(statisticsParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(594, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(595, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 299, [595 | __Ss], [__T | __Stack]);
yeccpars2(595, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_595_(__Stack),
 yeccpars2(596, __Cat, [595 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(596, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 597, [596 | __Ss], [__T | __Stack]);
yeccpars2(596, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(597, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_597_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(statisticsParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(598, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 602, [598 | __Ss], [__T | __Stack]);
yeccpars2(598, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(599, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(600, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 599, [600 | __Ss], [__T | __Stack]);
yeccpars2(600, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_600_(__Stack),
 yeccpars2(601, __Cat, [600 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(601, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_601_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(statisticsParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(602, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_602_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(statisticsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(603, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 607, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(604, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_604_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(605, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 618, [605 | __Ss], [__T | __Stack]);
yeccpars2(605, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_605_(__Stack),
 yeccpars2(617, __Cat, [605 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(606, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_606_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(607, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 608, [607 | __Ss], [__T | __Stack]);
yeccpars2(607, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_607_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(608, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(609, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 610, [609 | __Ss], [__T | __Stack]);
yeccpars2(609, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(610, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(611, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 613, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_611_(__Stack),
 yeccpars2(612, __Cat, [611 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(612, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 616, [612 | __Ss], [__T | __Stack]);
yeccpars2(612, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(613, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [613 | __Ss], [__T | __Stack]);
yeccpars2(613, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(614, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 613, [614 | __Ss], [__T | __Stack]);
yeccpars2(614, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_614_(__Stack),
 yeccpars2(615, __Cat, [614 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(615, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_615_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalListParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(616, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_616_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(signalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(617, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 621, [617 | __Ss], [__T | __Stack]);
yeccpars2(617, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(618, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 607, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [618 | __Ss], [__T | __Stack]);
yeccpars2(618, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(619, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 618, [619 | __Ss], [__T | __Stack]);
yeccpars2(619, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_619_(__Stack),
 yeccpars2(620, __Cat, [619 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(620, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_620_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(621, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_621_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(622, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [622 | __Ss], [__T | __Stack]);
yeccpars2(622, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(623, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_623_(__Stack),
 yeccpars2(yeccgoto(muxType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(624, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 626, [624 | __Ss], [__T | __Stack]);
yeccpars2(624, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(625, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_625_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(muxDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(626, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [626 | __Ss], [__T | __Stack]);
yeccpars2(626, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(627, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [627 | __Ss], [__T | __Stack]);
yeccpars2(627, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_627_(__Stack),
 yeccpars2(628, __Cat, [627 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(628, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 629, [628 | __Ss], [__T | __Stack]);
yeccpars2(628, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(629, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_629_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(terminationIDList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(630, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [630 | __Ss], [__T | __Stack]);
yeccpars2(630, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(631, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [631 | __Ss], [__T | __Stack]);
yeccpars2(631, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(632, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_632_(__Stack),
 yeccpars2(yeccgoto(modemType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(633, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 635, [633 | __Ss], [__T | __Stack]);
yeccpars2(633, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_633_(__Stack),
 yeccpars2(634, __Cat, [633 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(634, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 638, [634 | __Ss], [__T | __Stack]);
yeccpars2(634, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(635, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [635 | __Ss], [__T | __Stack]);
yeccpars2(635, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(636, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 635, [636 | __Ss], [__T | __Stack]);
yeccpars2(636, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_636_(__Stack),
 yeccpars2(637, __Cat, [636 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(637, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_637_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(modemTypeList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(638, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 640, [638 | __Ss], [__T | __Stack]);
yeccpars2(638, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_638_(__Stack),
 yeccpars2(639, __Cat, [638 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(639, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_639_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(640, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [640 | __Ss], [__T | __Stack]);
yeccpars2(640, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(641, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 547, [641 | __Ss], [__T | __Stack]);
yeccpars2(641, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_641_(__Stack),
 yeccpars2(642, __Cat, [641 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(642, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 643, [642 | __Ss], [__T | __Stack]);
yeccpars2(642, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(643, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_643_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(optPropertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(644, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 640, [644 | __Ss], [__T | __Stack]);
yeccpars2(644, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_644_(__Stack),
 yeccpars2(645, __Cat, [644 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(645, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_645_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(646, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 653, [646 | __Ss], [__T | __Stack]);
yeccpars2(646, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 654, [646 | __Ss], [__T | __Stack]);
yeccpars2(646, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 655, [646 | __Ss], [__T | __Stack]);
yeccpars2(646, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 588, [646 | __Ss], [__T | __Stack]);
yeccpars2(646, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 656, [646 | __Ss], [__T | __Stack]);
yeccpars2(646, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 657, [646 | __Ss], [__T | __Stack]);
yeccpars2(646, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(647, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_647_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(648, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_648_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(649, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_649_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(650, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_650_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(651, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 703, [651 | __Ss], [__T | __Stack]);
yeccpars2(651, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_651_(__Stack),
 yeccpars2(702, __Cat, [651 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(652, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_652_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(653, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 685, [653 | __Ss], [__T | __Stack]);
yeccpars2(653, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(654, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_654_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(655, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_655_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(656, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 676, [656 | __Ss], [__T | __Stack]);
yeccpars2(656, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(657, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 658, [657 | __Ss], [__T | __Stack]);
yeccpars2(657, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(658, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 663, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 664, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [658 | __Ss], [__T | __Stack]);
yeccpars2(658, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(659, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 672, [659 | __Ss], [__T | __Stack]);
yeccpars2(659, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_659_(__Stack),
 yeccpars2(671, __Cat, [659 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(660, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_660_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(661, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_661_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(662, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_662_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(663, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 667, [663 | __Ss], [__T | __Stack]);
yeccpars2(663, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(664, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 665, [664 | __Ss], [__T | __Stack]);
yeccpars2(664, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(665, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 340, [665 | __Ss], [__T | __Stack]);
yeccpars2(665, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 341, [665 | __Ss], [__T | __Stack]);
yeccpars2(665, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 342, [665 | __Ss], [__T | __Stack]);
yeccpars2(665, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(666, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_666_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceStates, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(667, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 669, [667 | __Ss], [__T | __Stack]);
yeccpars2(667, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 670, [667 | __Ss], [__T | __Stack]);
yeccpars2(667, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(668, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_668_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(eventBufferControl, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(669, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_669_(__Stack),
 yeccpars2(yeccgoto(eventBufferControlValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(670, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_670_(__Stack),
 yeccpars2(yeccgoto(eventBufferControlValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(671, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 675, [671 | __Ss], [__T | __Stack]);
yeccpars2(671, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(672, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 663, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 664, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [672 | __Ss], [__T | __Stack]);
yeccpars2(672, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(673, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 672, [673 | __Ss], [__T | __Stack]);
yeccpars2(673, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_673_(__Stack),
 yeccpars2(674, __Cat, [673 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(674, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_674_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(terminationStateParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(675, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_675_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(terminationStateDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(676, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [676 | __Ss], [__T | __Stack]);
yeccpars2(676, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(677, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 678, [677 | __Ss], [__T | __Stack]);
yeccpars2(677, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(678, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 653, [678 | __Ss], [__T | __Stack]);
yeccpars2(678, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __T