-module(megaco_text_parser_prev3a).
-export([parse/1, parse_and_scan/1, format_error/1]).
-file("megaco_text_parser_prev3a.yrl", 1544).

%% The following directive is needed for (significantly) faster compilation
%% of the generated .erl file by the HiPE compiler.  Please do not remove.
-compile([{hipe,[{regalloc,linear_scan}]}]).

-include("megaco_text_parser_prev3a.hrl").



-file("/ldisk/daily_build/otp_prebuild_r11b.2007-06-11_19/otp_src_R11B-5/bootstrap/lib/parsetools/include/yeccpre.hrl", 0).
%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved via the world wide web at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Initial Developer of the Original Code is Ericsson Utvecklings AB.
%% Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
%% AB. All Rights Reserved.''
%% 
%%     $Id $
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The parser generator will insert appropriate declarations before this line.%

parse(Tokens) ->
    yeccpars0(Tokens, false).

parse_and_scan({F, A}) -> % Fun or {M, F}
    yeccpars0([], {F, A});
parse_and_scan({M, F, A}) ->
    yeccpars0([], {{M, F}, A}).

format_error(Message) ->
    case io_lib:deep_char_list(Message) of
	true ->
	    Message;
	_ ->
	    io_lib:write(Message)
    end.

% To be used in grammar files to throw an error message to the parser
% toplevel. Doesn't have to be exported!
-compile({nowarn_unused_function,{return_error,2}}).
return_error(Line, Message) ->
    throw({error, {Line, ?MODULE, Message}}).

yeccpars0(Tokens, MFA) ->
    try yeccpars1(Tokens, MFA, 0, [], [])
    catch 
        throw: {error, {_Line, ?MODULE, _M}} = Error -> 
                   Error % probably from return_error/1
    end.

% Don't change yeccpars1/6 too much, it is called recursively by yeccpars2/8!
yeccpars1([Token | Tokens], Tokenizer, State, States, Vstack) ->
    yeccpars2(State, element(1, Token), States, Vstack, Token, Tokens,
	      Tokenizer);
yeccpars1([], {F, A}, State, States, Vstack) ->
    case apply(F, A) of
        {ok, Tokens, _Endline} ->
	    yeccpars1(Tokens, {F, A}, State, States, Vstack);
        {eof, _Endline} ->
            yeccpars1([], false, State, States, Vstack);
        {error, Descriptor, _Endline} ->
            {error, Descriptor}
    end;
yeccpars1([], false, State, States, Vstack) ->
    yeccpars2(State, '$end', States, Vstack, {'$end', 999999}, [], false).

% For internal use only.
yeccerror(Token) ->
    {error,
     {element(2, Token), ?MODULE,
      ["syntax error before: ", yecctoken2string(Token)]}}.

yecctoken2string({atom, _, A}) -> io_lib:write(A);
yecctoken2string({integer,_,N}) -> io_lib:write(N);
yecctoken2string({float,_,F}) -> io_lib:write(F);
yecctoken2string({char,_,C}) -> io_lib:write_char(C);
yecctoken2string({var,_,V}) -> io_lib:format('~s', [V]);
yecctoken2string({string,_,S}) -> io_lib:write_string(S);
yecctoken2string({reserved_symbol, _, A}) -> io_lib:format('~w', [A]);
yecctoken2string({_Cat, _, Val}) -> io_lib:format('~w', [Val]);
yecctoken2string({'dot', _}) -> io_lib:format('~w', ['.']);
yecctoken2string({'$end', _}) ->
    [];
yecctoken2string({Other, _}) when is_atom(Other) ->
    io_lib:format('~w', [Other]);
yecctoken2string(Other) ->
    io_lib:write(Other).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



-file("./megaco_text_parser_prev3a.erl", 106).

yeccpars2(0, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [0 | __Ss], [__T | __Stack]);
yeccpars2(0, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_0_(__Stack),
 yeccpars2(1, __Cat, [0 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(1, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 5, [1 | __Ss], [__T | __Stack]);
yeccpars2(1, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_1_(__Stack),
 yeccpars2(4, __Cat, [1 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(2, '$end', _, __Stack, _, _, _) ->
 {ok, hd(__Stack)};
yeccpars2(2, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(3, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_3_(__Stack),
 yeccpars2(yeccgoto(optSep, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(4, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(5, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 6, [5 | __Ss], [__T | __Stack]);
yeccpars2(5, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(6, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(7, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [7 | __Ss], [__T | __Stack]);
yeccpars2(7, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(8, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_8_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(9, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_9_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(10, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_10_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(11, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_11_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(12, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_12_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(13, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_13_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(14, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_14_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(15, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_15_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(16, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_16_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(17, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_17_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(18, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_18_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(19, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_19_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(20, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_20_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(21, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_21_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(22, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_22_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(23, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_23_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(24, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_24_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(25, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_25_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(26, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_26_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(27, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_27_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(28, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_28_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(29, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_29_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(30, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_30_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(31, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_31_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(32, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_32_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(33, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_33_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(34, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_34_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(35, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_35_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(36, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_36_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(37, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_37_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(38, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_38_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(39, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_39_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(40, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_40_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(41, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_41_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(42, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_42_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(43, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_43_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(44, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_44_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(45, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_45_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(46, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_46_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(47, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_47_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(48, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_48_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(49, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_49_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(50, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_50_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(51, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_51_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(52, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_52_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(53, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_53_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(54, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_54_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(55, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_55_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(56, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_56_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(57, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_57_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(58, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_58_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(59, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_59_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(60, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_60_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(61, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_61_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(62, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_62_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(63, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_63_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(64, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_64_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(65, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_65_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(66, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_66_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(67, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_67_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(68, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_68_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(69, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_69_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(70, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_70_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(71, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_71_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(72, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_72_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(73, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_73_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(74, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_74_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(75, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_75_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(76, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_76_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(77, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_77_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(78, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_78_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(79, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_79_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(80, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_80_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(81, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_81_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(82, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_82_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(83, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_83_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(84, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_84_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(85, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_85_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(86, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_86_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(87, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_87_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(88, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(89, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [89 | __Ss], [__T | __Stack]);
yeccpars2(89, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(90, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(91, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [91 | __Ss], [__T | __Stack]);
yeccpars2(91, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_91_(__Stack),
 yeccpars2(92, __Cat, [91 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(92, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_92_(__Stack),
 __Nss = lists:nthtail(7, __Ss),
 yeccpars2(yeccgoto(authenticationHeader, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(93, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_93_(__Stack),
 yeccpars2(96, __Cat, [93 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(94, endOfMessage, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(95, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_95_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(megacoMessage, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(96, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'MtpAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 890, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(97, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 125, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 126, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 127, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 128, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 129, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(98, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(99, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(100, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(101, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 104, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_101_(__Stack),
 yeccpars2(103, __Cat, [101 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(102, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 104, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_102_(__Stack),
 yeccpars2(111, __Cat, [102 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(103, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 106, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(104, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 104, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_104_(__Stack),
 yeccpars2(105, __Cat, [104 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(105, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_105_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(106, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 107, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_106_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(107, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(108, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_108_(__Stack),
 yeccpars2(yeccgoto(portNumber, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(109, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_109_(__Stack),
 yeccpars2(110, __Cat, [109 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(110, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_110_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(111, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_111_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(112, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 113, [112 | __Ss], [__T | __Stack]);
yeccpars2(112, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(113, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 114, [113 | __Ss], [__T | __Stack]);
yeccpars2(113, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_113_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(114, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(115, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_115_(__Stack),
 yeccpars2(116, __Cat, [115 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(116, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_116_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(117, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_117_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(118, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_118_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(119, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_119_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(120, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_120_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(121, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_121_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(122, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 126, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 127, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 128, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 129, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_122_(__Stack),
 yeccpars2(yeccgoto(transactionList, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(123, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_123_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(message, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(124, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_124_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(125, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 819, [125 | __Ss], [__T | __Stack]);
yeccpars2(125, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(126, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 881, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(127, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 749, [127 | __Ss], [__T | __Stack]);
yeccpars2(127, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(128, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 741, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(129, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 130, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 131, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(130, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 733, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(131, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 133, [131 | __Ss], [__T | __Stack]);
yeccpars2(131, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(132, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 727, [132 | __Ss], [__T | __Stack]);
yeccpars2(132, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_132_(__Stack),
 yeccpars2(726, __Cat, [132 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(133, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 134, [133 | __Ss], [__T | __Stack]);
yeccpars2(133, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(134, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(135, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_135_(__Stack),
 yeccpars2(yeccgoto(contextID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(136, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 137, [136 | __Ss], [__T | __Stack]);
yeccpars2(136, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(137, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 150, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 151, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 152, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 153, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 154, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 155, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 156, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 157, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 158, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 159, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(138, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(139, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(140, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(141, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_141_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(142, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_142_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(143, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_143_(__Stack),
 yeccpars2(yeccgoto(contextProperties, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(144, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_144_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(145, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(146, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 501, [146 | __Ss], [__T | __Stack]);
yeccpars2(146, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(147, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(148, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 498, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_148_(__Stack),
 yeccpars2(497, __Cat, [148 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(149, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 496, [149 | __Ss], [__T | __Stack]);
yeccpars2(149, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(150, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_150_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(151, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 493, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(152, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 490, [152 | __Ss], [__T | __Stack]);
yeccpars2(152, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(153, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 453, [153 | __Ss], [__T | __Stack]);
yeccpars2(153, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(154, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 437, [154 | __Ss], [__T | __Stack]);
yeccpars2(154, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(155, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_155_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(156, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_156_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(157, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 401, [157 | __Ss], [__T | __Stack]);
yeccpars2(157, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(158, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 351, [158 | __Ss], [__T | __Stack]);
yeccpars2(158, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(159, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 160, [159 | __Ss], [__T | __Stack]);
yeccpars2(159, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(160, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(161, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [161 | __Ss], [__T | __Stack]);
yeccpars2(161, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_161_(__Stack),
 yeccpars2(163, __Cat, [161 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(162, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_162_(__Stack),
 yeccpars2(yeccgoto(terminationID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(163, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_163_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(subtractRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(164, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [164 | __Ss], [__T | __Stack]);
yeccpars2(164, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(165, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 350, [165 | __Ss], [__T | __Stack]);
yeccpars2(165, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(166, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [166 | __Ss], [__T | __Stack]);
yeccpars2(166, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(167, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 180, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 181, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 182, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 184, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 185, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 187, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 188, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 189, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 190, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_167_(__Stack),
 yeccpars2(179, __Cat, [167 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(168, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_168_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(169, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_169_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(170, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_170_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(171, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_171_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(172, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_172_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(173, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_173_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(174, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_174_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(175, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_175_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(176, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 342, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_176_(__Stack),
 yeccpars2(341, __Cat, [176 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(177, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(178, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 338, [178 | __Ss], [__T | __Stack]);
yeccpars2(178, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_178_(__Stack),
 yeccpars2(337, __Cat, [178 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(179, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 336, [179 | __Ss], [__T | __Stack]);
yeccpars2(179, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(180, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_180_(__Stack),
 yeccpars2(yeccgoto(indAuddigitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(181, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_181_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(182, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 322, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_182_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(183, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 316, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_183_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(184, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 287, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_184_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(185, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_185_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(186, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_186_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(187, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_187_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(188, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_188_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(189, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 196, [189 | __Ss], [__T | __Stack]);
yeccpars2(189, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_189_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(190, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_190_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(191, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(192, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_192_(__Stack),
 yeccpars2(yeccgoto(pkgdName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(193, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 194, [193 | __Ss], [__T | __Stack]);
yeccpars2(193, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(194, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_194_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudstatisticsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(195, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_195_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudsignalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(196, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 202, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 203, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [196 | __Ss], [__T | __Stack]);
yeccpars2(196, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(197, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_197_(__Stack),
 yeccpars2(yeccgoto(indAudsignalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(198, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [198 | __Ss], [__T | __Stack]);
yeccpars2(198, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_198_(__Stack),
 yeccpars2(yeccgoto(signalRequest, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(199, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalName, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(200, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(201, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_201_(__Stack),
 yeccpars2(yeccgoto(indAudsignalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(202, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_202_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(optIndAudsignalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(203, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 204, [203 | __Ss], [__T | __Stack]);
yeccpars2(203, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_203_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(204, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(205, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [205 | __Ss], [__T | __Stack]);
yeccpars2(205, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(206, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_206_(__Stack),
 yeccpars2(yeccgoto(signalListId, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(207, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(208, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalListParm, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(209, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [209 | __Ss], [__T | __Stack]);
yeccpars2(209, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(210, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_210_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudsignalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(211, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_211_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optIndAudsignalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(212, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 218, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 219, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 220, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 221, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [212 | __Ss], [__T | __Stack]);
yeccpars2(212, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(213, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 279, [213 | __Ss], [__T | __Stack]);
yeccpars2(213, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_213_(__Stack),
 yeccpars2(278, __Cat, [213 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(214, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 253, [214 | __Ss], [__T | __Stack]);
yeccpars2(214, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [214 | __Ss], [__T | __Stack]);
yeccpars2(214, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 255, [214 | __Ss], [__T | __Stack]);
yeccpars2(214, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 256, [214 | __Ss], [__T | __Stack]);
yeccpars2(214, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(215, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 247, [215 | __Ss], [__T | __Stack]);
yeccpars2(215, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_215_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(216, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_216_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(217, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_217_COMMA(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'COMMA', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(217, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_217_RBRKT(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'RBRKT', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(217, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_217_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(218, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 233, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_218_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(219, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 230, [219 | __Ss], [__T | __Stack]);
yeccpars2(219, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_219_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(220, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 225, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_220_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(221, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 222, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_221_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(222, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(223, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_223_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(224, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_224_(__Stack),
 yeccpars2(yeccgoto(streamID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(225, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 227, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 228, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 229, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(226, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_226_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(227, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_227_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(228, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_228_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(229, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_229_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(230, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(231, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_231_(__Stack),
 yeccpars2(yeccgoto(requestID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(232, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_232_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(233, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 234, [233 | __Ss], [__T | __Stack]);
yeccpars2(233, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(234, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 236, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 237, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 238, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 239, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(235, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 241, [235 | __Ss], [__T | __Stack]);
yeccpars2(235, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_235_(__Stack),
 yeccpars2(240, __Cat, [235 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(236, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_236_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(237, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_237_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(238, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_238_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(239, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_239_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(240, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [240 | __Ss], [__T | __Stack]);
yeccpars2(240, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(241, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 236, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 237, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 238, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 239, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(242, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 241, [242 | __Ss], [__T | __Stack]);
yeccpars2(242, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_242_(__Stack),
 yeccpars2(243, __Cat, [242 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(243, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_243_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(notificationReasons, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(244, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_244_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(245, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(246, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_246_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(247, 'BothToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 249, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ExternalToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 250, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InternalToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 251, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(248, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_248_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(249, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_249_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(250, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_250_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(251, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_251_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(252, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_252_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(253, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 265, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [253 | __Ss], [__T | __Stack]);
yeccpars2(253, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(254, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [254 | __Ss], [__T | __Stack]);
yeccpars2(254, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(255, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(256, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(257, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_257_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(258, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_258_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(259, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_259_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(260, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_260_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(261, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_261_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(262, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_262_(__Stack),
 yeccpars2(yeccgoto(alternativeValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(263, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_263_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(264, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(265, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(266, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 268, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 269, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_266_(__Stack),
 yeccpars2(267, __Cat, [266 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(267, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 274, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(268, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [268 | __Ss], [__T | __Stack]);
yeccpars2(268, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(269, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [269 | __Ss], [__T | __Stack]);
yeccpars2(269, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(270, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 269, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_270_(__Stack),
 yeccpars2(271, __Cat, [270 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(271, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_271_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(valueList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(272, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 273, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(273, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_273_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(274, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_274_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(275, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 269, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_275_(__Stack),
 yeccpars2(276, __Cat, [275 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(276, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 277, [276 | __Ss], [__T | __Stack]);
yeccpars2(276, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(277, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_277_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(278, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 282, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(279, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 218, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 219, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 220, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 221, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(280, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 279, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_280_(__Stack),
 yeccpars2(281, __Cat, [280 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(281, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_281_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(282, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_282_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(283, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(284, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_284_(__Stack),
 yeccpars2(yeccgoto(packagesItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(285, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(286, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_286_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudpackagesDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(287, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 294, [287 | __Ss], [__T | __Stack]);
yeccpars2(287, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 295, [287 | __Ss], [__T | __Stack]);
yeccpars2(287, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 296, [287 | __Ss], [__T | __Stack]);
yeccpars2(287, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 297, [287 | __Ss], [__T | __Stack]);
yeccpars2(287, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(288, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_288_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(289, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_289_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(290, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_290_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(291, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_291_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(292, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 315, [292 | __Ss], [__T | __Stack]);
yeccpars2(292, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(293, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_293_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(294, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 307, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(295, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(296, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 302, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(297, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 298, [297 | __Ss], [__T | __Stack]);
yeccpars2(297, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(298, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [298 | __Ss], [__T | __Stack]);
yeccpars2(298, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(299, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_299_(__Stack),
 yeccpars2(yeccgoto(indAudterminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(300, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 301, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(301, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_301_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudterminationStateDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(302, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(303, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 304, [303 | __Ss], [__T | __Stack]);
yeccpars2(303, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(304, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 294, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 295, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(305, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 306, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(306, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_306_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudstreamDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(307, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [307 | __Ss], [__T | __Stack]);
yeccpars2(307, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(308, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_308_(__Stack),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(309, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 311, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_309_(__Stack),
 yeccpars2(310, __Cat, [309 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(310, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 314, [310 | __Ss], [__T | __Stack]);
yeccpars2(310, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(311, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(312, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 311, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_312_(__Stack),
 yeccpars2(313, __Cat, [312 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(313, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_313_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudlocalParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(314, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_314_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudlocalControlDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(315, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_315_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudmediaDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(316, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(317, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 318, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(318, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(319, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(indAudrequestedEvent, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(320, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 321, [320 | __Ss], [__T | __Stack]);
yeccpars2(320, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(321, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_321_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudeventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(322, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(323, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 327, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_323_(__Stack),
 yeccpars2(326, __Cat, [323 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(324, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 325, [324 | __Ss], [__T | __Stack]);
yeccpars2(324, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(325, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_325_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudeventBufferDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(326, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_326_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudeventSpec, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(327, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 332, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(328, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_328_(__Stack),
 yeccpars2(yeccgoto(eventParameterName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(329, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 335, [329 | __Ss], [__T | __Stack]);
yeccpars2(329, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(330, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_330_(__Stack),
 yeccpars2(yeccgoto(indAudeventSpecParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(331, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_331_(__Stack),
 yeccpars2(yeccgoto(indAudeventSpecParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(332, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 333, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_332_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(333, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(334, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_334_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(eventStream, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(335, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_335_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optIndAudeventSpecParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(336, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_336_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(337, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_337_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(auditDescriptorBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(338, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 180, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 181, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 182, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 184, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 185, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 187, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 188, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 189, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 190, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(339, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 338, [339 | __Ss], [__T | __Stack]);
yeccpars2(339, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_339_(__Stack),
 yeccpars2(340, __Cat, [339 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(340, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_340_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(auditItemList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(341, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_341_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudterminationAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(342, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 180, [342 | __Ss], [__T | __Stack]);
yeccpars2(342, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 344, [342 | __Ss], [__T | __Stack]);
yeccpars2(342, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 345, [342 | __Ss], [__T | __Stack]);
yeccpars2(342, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 346, [342 | __Ss], [__T | __Stack]);
yeccpars2(342, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 347, [342 | __Ss], [__T | __Stack]);
yeccpars2(342, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 348, [342 | __Ss], [__T | __Stack]);
yeccpars2(342, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 295, [342 | __Ss], [__T | __Stack]);
yeccpars2(342, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(343, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 342, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_343_(__Stack),
 yeccpars2(349, __Cat, [343 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(344, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 322, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(345, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 316, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(346, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 287, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(347, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(348, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 196, [348 | __Ss], [__T | __Stack]);
yeccpars2(348, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(349, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_349_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudterminationAuditList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(350, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_350_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optAuditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(351, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(352, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 353, [352 | __Ss], [__T | __Stack]);
yeccpars2(352, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(353, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 355, [353 | __Ss], [__T | __Stack]);
yeccpars2(353, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(354, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 400, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(355, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 356, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(356, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 370, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 180, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 181, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 182, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 184, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 371, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 372, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 185, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 187, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 188, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 373, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 374, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 375, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServiceChangeIncompleteToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 376, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 189, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 190, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 377, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 378, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(357, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_357_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(358, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_358_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(359, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_359_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(360, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_360_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(361, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 396, [361 | __Ss], [__T | __Stack]);
yeccpars2(361, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_361_(__Stack),
 yeccpars2(395, __Cat, [361 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(362, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_362_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(363, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_363_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(364, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_364_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(365, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_365_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(366, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_366_(__Stack),
 yeccpars2(yeccgoto(extensionParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(367, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 253, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 255, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 256, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(368, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_368_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(369, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_369_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(370, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 392, [370 | __Ss], [__T | __Stack]);
yeccpars2(370, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_370_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(371, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 390, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_371_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(372, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 388, [372 | __Ss], [__T | __Stack]);
yeccpars2(372, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_372_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(373, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 386, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_373_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(374, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 384, [374 | __Ss], [__T | __Stack]);
yeccpars2(374, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_374_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(375, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 381, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_375_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(376, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_376_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(377, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_377_(__Stack),
 yeccpars2(yeccgoto(timeStamp, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(378, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 379, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_378_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(379, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [379 | __Ss], [__T | __Stack]);
yeccpars2(379, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(380, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_380_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeVersion, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(381, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_381_(__Stack),
 yeccpars2(96, __Cat, [381 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(382, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_382_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(383, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_383_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(384, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(385, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_385_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeReason, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(386, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [386 | __Ss], [__T | __Stack]);
yeccpars2(386, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(387, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_387_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeProfile, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(388, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [388 | __Ss], [__T | __Stack]);
yeccpars2(388, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [388 | __Ss], [__T | __Stack]);
yeccpars2(388, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [388 | __Ss], [__T | __Stack]);
yeccpars2(388, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_388_(__Stack),
 yeccpars2(96, __Cat, [388 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(389, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_389_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMgcId, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(390, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(391, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_391_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMethod, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(392, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(393, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_393_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeDelay, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(394, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_394_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(extension, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(395, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 399, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(396, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 370, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 180, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 181, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 182, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 183, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 184, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 371, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 372, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 185, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 187, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 188, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 373, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 374, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 375, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ServiceChangeIncompleteToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 376, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 189, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 190, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 377, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 378, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(397, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 396, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_397_(__Stack),
 yeccpars2(398, __Cat, [397 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(398, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_398_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(399, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_399_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(serviceChangeDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(400, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_400_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(serviceChangeRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(401, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(402, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 403, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(403, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 125, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 407, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(404, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_404_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(405, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 436, [405 | __Ss], [__T | __Stack]);
yeccpars2(405, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(406, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_406_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(407, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 408, [407 | __Ss], [__T | __Stack]);
yeccpars2(407, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(408, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(409, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 410, [409 | __Ss], [__T | __Stack]);
yeccpars2(409, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(410, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 377, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_410_(__Stack),
 yeccpars2(412, __Cat, [410 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(411, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [411 | __Ss], [__T | __Stack]);
yeccpars2(411, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_411_(__Stack),
 yeccpars2(431, __Cat, [411 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(412, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(413, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 415, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_413_(__Stack),
 yeccpars2(414, __Cat, [413 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(414, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 418, [414 | __Ss], [__T | __Stack]);
yeccpars2(414, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(415, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 377, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_415_(__Stack),
 yeccpars2(412, __Cat, [415 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(416, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 415, [416 | __Ss], [__T | __Stack]);
yeccpars2(416, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_416_(__Stack),
 yeccpars2(417, __Cat, [416 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(417, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_417_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvents, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(418, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_418_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(observedEventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(419, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 421, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_419_(__Stack),
 yeccpars2(420, __Cat, [419 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(420, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_420_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(421, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(422, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 427, [422 | __Ss], [__T | __Stack]);
yeccpars2(422, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_422_(__Stack),
 yeccpars2(426, __Cat, [422 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(423, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(observedEventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(424, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 253, [424 | __Ss], [__T | __Stack]);
yeccpars2(424, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [424 | __Ss], [__T | __Stack]);
yeccpars2(424, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 255, [424 | __Ss], [__T | __Stack]);
yeccpars2(424, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 256, [424 | __Ss], [__T | __Stack]);
yeccpars2(424, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(425, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_425_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(eventStreamOrOther, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(426, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 430, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(427, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(428, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 427, [428 | __Ss], [__T | __Stack]);
yeccpars2(428, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_428_(__Stack),
 yeccpars2(429, __Cat, [428 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(429, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_429_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEventParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(430, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_430_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(observedEventBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(431, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 432, [431 | __Ss], [__T | __Stack]);
yeccpars2(431, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(432, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_432_(__Stack),
 yeccpars2(433, __Cat, [432 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(433, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(434, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 421, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_434_(__Stack),
 yeccpars2(435, __Cat, [434 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(435, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_435_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(436, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_436_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(notifyRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(437, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 439, [437 | __Ss], [__T | __Stack]);
yeccpars2(437, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(438, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 452, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(439, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 440, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(440, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 443, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 444, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 445, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 446, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(441, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_441_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(442, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 448, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_442_(__Stack),
 yeccpars2(447, __Cat, [442 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(443, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_443_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(444, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_444_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(445, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_445_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(446, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_446_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(447, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 451, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(448, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 443, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 444, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 445, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 446, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(449, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 448, [449 | __Ss], [__T | __Stack]);
yeccpars2(449, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_449_(__Stack),
 yeccpars2(450, __Cat, [449 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(450, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_450_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(contextAuditProperties, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(451, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_451_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudcontextAttrDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(452, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_452_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(contextAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(453, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 460, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 461, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 462, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 463, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 464, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(454, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_454_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(455, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_455_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(456, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_456_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(457, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 253, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 255, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 256, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(458, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(contextAttrDescProp, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(459, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 485, [459 | __Ss], [__T | __Stack]);
yeccpars2(459, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_459_(__Stack),
 yeccpars2(484, __Cat, [459 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(460, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_460_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(461, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_461_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(462, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_462_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(463, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 482, [463 | __Ss], [__T | __Stack]);
yeccpars2(463, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(464, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 465, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(465, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(466, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 478, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_466_(__Stack),
 yeccpars2(477, __Cat, [466 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(467, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(terminationA, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(468, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 469, [468 | __Ss], [__T | __Stack]);
yeccpars2(468, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(469, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(470, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(terminationB, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(471, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 472, [471 | __Ss], [__T | __Stack]);
yeccpars2(471, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(472, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 474, [472 | __Ss], [__T | __Stack]);
yeccpars2(472, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 475, [472 | __Ss], [__T | __Stack]);
yeccpars2(472, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 476, [472 | __Ss], [__T | __Stack]);
yeccpars2(472, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(473, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_473_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyTriple, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(474, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_474_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(475, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_475_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(476, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_476_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(477, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 481, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(478, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(479, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 478, [479 | __Ss], [__T | __Stack]);
yeccpars2(479, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_479_(__Stack),
 yeccpars2(480, __Cat, [479 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(480, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_480_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(topologyTripleList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(481, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_481_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(482, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(483, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_483_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(priority, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(484, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 488, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(485, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 460, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 461, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 462, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 463, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 464, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [485 | __Ss], [__T | __Stack]);
yeccpars2(485, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(486, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 485, [486 | __Ss], [__T | __Stack]);
yeccpars2(486, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_486_(__Stack),
 yeccpars2(487, __Cat, [486 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(487, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_487_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(contextAttrDescProps, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(488, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_488_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(contextAttrDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(489, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_489_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(propertyParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(490, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(491, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [491 | __Ss], [__T | __Stack]);
yeccpars2(491, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_491_(__Stack),
 yeccpars2(492, __Cat, [491 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(492, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_492_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(493, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(494, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_494_(__Stack),
 yeccpars2(495, __Cat, [494 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(495, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_495_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(496, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_496_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(actionRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(497, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_497_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(actionRequestBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(498, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 150, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 151, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 152, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 153, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 154, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 155, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 156, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 157, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 158, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 159, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(499, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 498, [499 | __Ss], [__T | __Stack]);
yeccpars2(499, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_499_(__Stack),
 yeccpars2(500, __Cat, [499 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(500, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_500_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(actionRequestItems, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(501, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(502, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 504, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_502_(__Stack),
 yeccpars2(503, __Cat, [502 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(503, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_503_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(ammRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(504, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 515, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 516, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 517, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 518, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 519, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 520, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 521, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 522, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(505, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_505_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(506, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_506_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(507, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_507_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(508, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_508_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(509, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_509_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(510, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_510_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(511, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_511_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(512, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_512_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(513, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_513_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(514, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 722, [514 | __Ss], [__T | __Stack]);
yeccpars2(514, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_514_(__Stack),
 yeccpars2(721, __Cat, [514 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(515, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_515_(__Stack),
 yeccpars2(yeccgoto(digitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(516, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 713, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_516_(__Stack),
 yeccpars2(yeccgoto(eventBufferDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(517, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 653, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_517_(__Stack),
 yeccpars2(yeccgoto(eventsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(518, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 582, [518 | __Ss], [__T | __Stack]);
yeccpars2(518, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(519, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 563, [519 | __Ss], [__T | __Stack]);
yeccpars2(519, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 564, [519 | __Ss], [__T | __Stack]);
yeccpars2(519, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(520, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 552, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(521, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 533, [521 | __Ss], [__T | __Stack]);
yeccpars2(521, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_521_(__Stack),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(522, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 523, [522 | __Ss], [__T | __Stack]);
yeccpars2(522, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(523, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(524, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 529, [524 | __Ss], [__T | __Stack]);
yeccpars2(524, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_524_(__Stack),
 yeccpars2(528, __Cat, [524 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(525, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 526, [525 | __Ss], [__T | __Stack]);
yeccpars2(525, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_525_(__Stack),
 yeccpars2(yeccgoto(statisticsParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(526, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(527, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_527_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(statisticsParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(528, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 532, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(529, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [529 | __Ss], [__T | __Stack]);
yeccpars2(529, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(530, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 529, [530 | __Ss], [__T | __Stack]);
yeccpars2(530, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_530_(__Stack),
 yeccpars2(531, __Cat, [530 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(531, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_531_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(statisticsParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(532, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_532_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(statisticsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(533, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 537, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(534, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_534_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(535, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 548, [535 | __Ss], [__T | __Stack]);
yeccpars2(535, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_535_(__Stack),
 yeccpars2(547, __Cat, [535 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(536, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_536_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(537, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 538, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_537_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(538, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(539, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 540, [539 | __Ss], [__T | __Stack]);
yeccpars2(539, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(540, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(541, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 543, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_541_(__Stack),
 yeccpars2(542, __Cat, [541 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(542, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 546, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(543, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(544, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 543, [544 | __Ss], [__T | __Stack]);
yeccpars2(544, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_544_(__Stack),
 yeccpars2(545, __Cat, [544 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(545, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_545_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalListParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(546, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_546_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(signalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(547, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 551, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(548, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 537, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(549, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 548, [549 | __Ss], [__T | __Stack]);
yeccpars2(549, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_549_(__Stack),
 yeccpars2(550, __Cat, [549 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(550, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_550_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(551, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_551_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(552, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(553, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_553_(__Stack),
 yeccpars2(yeccgoto(muxType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(554, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 556, [554 | __Ss], [__T | __Stack]);
yeccpars2(554, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(555, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_555_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(muxDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(556, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(557, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 559, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_557_(__Stack),
 yeccpars2(558, __Cat, [557 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(558, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 562, [558 | __Ss], [__T | __Stack]);
yeccpars2(558, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(559, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(560, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 559, [560 | __Ss], [__T | __Stack]);
yeccpars2(560, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_560_(__Stack),
 yeccpars2(561, __Cat, [560 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(561, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_561_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(terminationIDListRepeat, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(562, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_562_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(terminationIDList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(563, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(564, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(565, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_565_(__Stack),
 yeccpars2(yeccgoto(modemType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(566, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 568, [566 | __Ss], [__T | __Stack]);
yeccpars2(566, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_566_(__Stack),
 yeccpars2(567, __Cat, [566 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(567, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 571, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(568, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(569, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 568, [569 | __Ss], [__T | __Stack]);
yeccpars2(569, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_569_(__Stack),
 yeccpars2(570, __Cat, [569 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(570, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_570_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(modemTypeList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(571, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 573, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_571_(__Stack),
 yeccpars2(572, __Cat, [571 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(572, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_572_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(573, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(574, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 576, [574 | __Ss], [__T | __Stack]);
yeccpars2(574, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_574_(__Stack),
 yeccpars2(575, __Cat, [574 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(575, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 579, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(576, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(577, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 576, [577 | __Ss], [__T | __Stack]);
yeccpars2(577, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_577_(__Stack),
 yeccpars2(578, __Cat, [577 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(578, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_578_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(propertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(579, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_579_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(optPropertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(580, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 573, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_580_(__Stack),
 yeccpars2(581, __Cat, [580 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(581, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_581_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(582, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 589, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 590, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 591, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 522, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 592, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 593, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(583, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_583_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(584, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_584_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(585, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_585_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(586, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_586_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(587, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 649, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_587_(__Stack),
 yeccpars2(648, __Cat, [587 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(588, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_588_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(589, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 624, [589 | __Ss], [__T | __Stack]);
yeccpars2(589, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(590, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_590_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(591, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_591_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(592, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 615, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(593, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 594, [593 | __Ss], [__T | __Stack]);
yeccpars2(593, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(594, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 599, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 600, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(595, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 611, [595 | __Ss], [__T | __Stack]);
yeccpars2(595, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_595_(__Stack),
 yeccpars2(610, __Cat, [595 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(596, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_596_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(597, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_597_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(598, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_598_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(599, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 606, [599 | __Ss], [__T | __Stack]);
yeccpars2(599, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_599_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(600, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 601, [600 | __Ss], [__T | __Stack]);
yeccpars2(600, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_600_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(601, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 603, [601 | __Ss], [__T | __Stack]);
yeccpars2(601, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 604, [601 | __Ss], [__T | __Stack]);
yeccpars2(601, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 605, [601 | __Ss], [__T | __Stack]);
yeccpars2(601, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(602, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_602_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceStates, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(603, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_603_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(604, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_604_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(605, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_605_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(606, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 608, [606 | __Ss], [__T | __Stack]);
yeccpars2(606, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 609, [606 | __Ss], [__T | __Stack]);
yeccpars2(606, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(607, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_607_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(eventBufferControl, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(608, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_608_(__Stack),
 yeccpars2(yeccgoto(eventBufferControlState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(609, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_609_(__Stack),
 yeccpars2(yeccgoto(eventBufferControlState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(610, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 614, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(611, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 599, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [611 | __Ss], [__T | __Stack]);
yeccpars2(611, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpar