/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class RubyFileMatcher {
    private static final String RUBY = "ruby";
    private static final String SHEBANG = "#!";
    public static final int PROP_MATCH_CRITERIA = 1;
    private String[] rubyFileExtensions;
    private String[] rubyFileNames;
    private ListenerList propChangeListeners;
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object object, int n) {
            if (n == 1 && object instanceof IEditorRegistry) {
                RubyFileMatcher.this.createFileExtensions();
                RubyFileMatcher.this.firePropertyChange(1);
            }
        }
    };
    private static Set RUBY_NON_EDITABLE_EXTENSIONS = new HashSet();

    static {
        RUBY_NON_EDITABLE_EXTENSIONS.add("yaml");
        RUBY_NON_EDITABLE_EXTENSIONS.add("yml");
        RUBY_NON_EDITABLE_EXTENSIONS.add("rhtml");
        RUBY_NON_EDITABLE_EXTENSIONS.add("gem");
        RUBY_NON_EDITABLE_EXTENSIONS.add("gemspec");
    }

    public RubyFileMatcher() {
        this.propChangeListeners = new ListenerList();
        this.createFileExtensions();
        WorkbenchPlugin.getDefault().getEditorRegistry().addPropertyListener(this.propertyListener);
    }

    public void addPropertyChangeListener(IPropertyListener iPropertyListener) {
        this.propChangeListeners.add((Object)iPropertyListener);
    }

    private void firePropertyChange(final int n) {
        Object[] objectArray = this.propChangeListeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n2];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPropertyListener.propertyChanged((Object)this, n);
                }
            });
            ++n2;
        }
    }

    public void createFileExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.createDefaultExtensions());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(this.createDefaultFilenames());
        IFileEditorMapping[] iFileEditorMappingArray = WorkbenchPlugin.getDefault().getEditorRegistry().getFileEditorMappings();
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            IFileEditorMapping iFileEditorMapping = iFileEditorMappingArray[n];
            IEditorDescriptor[] iEditorDescriptorArray = iFileEditorMapping.getEditors();
            int n2 = 0;
            while (n2 < iEditorDescriptorArray.length) {
                IEditorDescriptor iEditorDescriptor = iEditorDescriptorArray[n2];
                if (iEditorDescriptor.getId().equals("org.rubypeople.rdt.ui.EditorRubyFile")) {
                    if (iFileEditorMapping.getExtension() != null && iFileEditorMapping.getExtension().length() != 0) {
                        arrayList.add(iFileEditorMapping.getExtension());
                        break;
                    }
                    if (iFileEditorMapping.getName() != null && iFileEditorMapping.getName().length() != 0) {
                        arrayList2.add(iFileEditorMapping.getName());
                        break;
                    }
                }
                ++n2;
            }
            ++n;
        }
        this.rubyFileExtensions = arrayList.toArray(new String[arrayList.size()]);
        this.rubyFileNames = arrayList2.toArray(new String[arrayList2.size()]);
    }

    private Collection createDefaultFilenames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Rakefile");
        return hashSet;
    }

    private Collection createDefaultExtensions() {
        return RUBY_NON_EDITABLE_EXTENSIONS;
    }

    public boolean hasRubyEditorAssociation(IFile iFile) {
        String string = iFile.getFileExtension();
        int n = 0;
        while (n < this.rubyFileExtensions.length) {
            if (this.rubyFileExtensions[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        String string2 = iFile.getName();
        int n2 = 0;
        while (n2 < this.rubyFileNames.length) {
            if (this.rubyFileNames[n2].equalsIgnoreCase(string2)) {
                return true;
            }
            ++n2;
        }
        return this.containsRubyShebang(iFile);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsRubyShebang(IFile var1_1) {
        block13: {
            block14: {
                block12: {
                    var2_2 = null;
                    try {
                        try {
                            var2_2 = new BufferedReader(new InputStreamReader(var1_1.getContents()));
                            var3_3 = var2_2.readLine();
                            if (var3_3 == null) {
                                var4_6 = null;
                                break block12;
                            }
                            if (var3_3.indexOf("#!") <= -1 || var3_3.indexOf("ruby") <= -1) break block13;
                            break block14;
                        }
                        catch (CoreException var3_4) {
                            var3_4.printStackTrace();
                            break block13;
                        }
                        catch (IOException var3_5) {
                            var3_5.printStackTrace();
                            break block13;
                        }
                    }
                    catch (Throwable var5_14) {
                        var4_8 = null;
                        try {
                            if (var2_2 == null) throw var5_14;
                            var2_2.close();
                            throw var5_14;
                        }
                        catch (IOException var6_12) {
                            var6_12.printStackTrace();
                        }
                        throw var5_14;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [6 : 91->102)] { 
lbl31:
                // 1 sources

                if (var2_2 == null) return false;
                var2_2.close();
                return false;
lbl34:
                // 1 sources

                catch (IOException var6_10) {
                    var6_10.printStackTrace();
                }
                return false;
            }
            var4_7 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 91->102)] { 
lbl40:
            // 1 sources

            if (var2_2 == null) return true;
            var2_2.close();
            return true;
lbl43:
            // 1 sources

            catch (IOException var6_11) {
                var6_11.printStackTrace();
            }
            return true;
        }
        var4_9 = null;
        try {}
        catch (IOException var6_13) {
            var6_13.printStackTrace();
            return false;
        }
        if (var2_2 == null) return false;
        var2_2.close();
        return false;
    }
}

