/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.wizards;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.jayasoft.ivyde.eclipse.ui.core.IvyFileEditorInput;
import org.jayasoft.ivyde.eclipse.ui.wizards.IvyNewWizardPage;

public class IvyNewWizard
extends Wizard
implements INewWizard {
    private IvyNewWizardPage page;
    private ISelection selection;

    public IvyNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new IvyNewWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IContainer container;
        IFile file;
        String containerName = this.page.getContainerName();
        String fileName = this.page.getFileName();
        final String orgName = this.page.getOrganisationName();
        final String moduleName = this.page.getModuleName();
        final String status = this.page.getStatus();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Container \"" + containerName + "\" does not exist."));
        }
        if ((file = (container = (IContainer)resource).getFile((IPath)new Path(fileName))).exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"overwrite existing ?", (String)"The file you selected already exist. Do you want to overwrite its content ?")) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        IvyNewWizard.this.doFinish(file, orgName, moduleName, status, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(final IFile file, String org, String module, String status, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + file.getName(), 2);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.openContentStream()));
            StringBuffer buf = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                line = line.replaceAll("@ORGANISATION@", org);
                line = line.replaceAll("@MODULE@", module);
                line = line.replaceAll("@STATUS@", status);
                buf.append(line).append(System.getProperty("line.separator", "\n"));
                line = reader.readLine();
            }
            reader.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(buf.toString().getBytes());
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, monitor);
            } else {
                file.create((InputStream)stream, true, monitor);
            }
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new IvyFileEditorInput(file), "org.jayasoft.ivyde.editors.IvyEditor", true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("ivy-template.xml");
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.jayasoft.ivyde", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

