/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IvyFile {
    private static final Pattern ATTRIBUTE_NAME_PATTERN = Pattern.compile("[^\"]*\"[\\s]*=[\\s]*([\\w\\-]+)");
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("[\\w\\-<]*");
    private static final Pattern ATTRIBUTE_VALUE_PATTERN = Pattern.compile("([a-zA-Z0-9]+)[ ]*=[ ]*\"([^\"]*)\"");
    private static final Pattern CONF_PATTERN = Pattern.compile("<[\\s]*conf[^>]+name=\"([^\"]+)");
    private static final Pattern CONFIGURATIONS_END_PATTERN = Pattern.compile("</[\\s]*configurations[\\s]*>");
    private static final Pattern CONFIGURATIONS_START_PATTERN = Pattern.compile("<[\\s]*configurations[\\s]*>");
    private String _doc;
    private int _currentOffset;
    private String _reversed;
    private String _projectName;

    public IvyFile(String projectName, String doc) {
        this(projectName, doc, 0);
    }

    public IvyFile(String projectName, String doc, int currentOffset) {
        this._projectName = projectName;
        this._doc = doc;
        this._reversed = new StringBuffer(doc).reverse().toString();
        this._currentOffset = currentOffset;
    }

    public String[] getConfigurationNames() {
        Pattern p = CONFIGURATIONS_START_PATTERN;
        Matcher m = p.matcher(this._doc);
        if (m.find()) {
            int start = m.end();
            p = CONFIGURATIONS_END_PATTERN;
            m = p.matcher(this._doc);
            int end = this._doc.length();
            if (m.find(start)) {
                end = m.start();
            }
            p = CONF_PATTERN;
            m = p.matcher(this._doc);
            ArrayList<String> ret = new ArrayList<String>();
            boolean found = m.find(start);
            while (found && m.end() < end) {
                ret.add(m.group(1));
                found = m.find();
            }
            return ret.toArray(new String[ret.size()]);
        }
        return new String[]{"default"};
    }

    public boolean inTag() {
        return this.inTag(this._currentOffset);
    }

    public boolean inTag(int documentOffset) {
        char c;
        boolean hasSpace = false;
        do {
            if (documentOffset == 0) {
                return false;
            }
            if (Character.isWhitespace(c = this._doc.charAt(--documentOffset))) {
                hasSpace = true;
            }
            if (c != '>' || documentOffset != 0 && this._doc.charAt(documentOffset - 1) == '-') continue;
            return false;
        } while (c != '<' || documentOffset + 1 < this._doc.length() && (this._doc.charAt(documentOffset + 1) == '!' || this._doc.charAt(documentOffset + 1) == '?'));
        return hasSpace;
    }

    public String getTagName() {
        return this.getTagName(this._currentOffset);
    }

    public String getTagName(int documentOffset) {
        int offset;
        int lastSpaceIndex = offset = documentOffset;
        while (true) {
            char c;
            if (Character.isWhitespace(c = this._doc.charAt(--offset))) {
                lastSpaceIndex = offset;
                continue;
            }
            if (c == '<') break;
        }
        return this._doc.substring(offset + 1, lastSpaceIndex).trim();
    }

    public boolean readyForValue() {
        return this.readyForValue(this._currentOffset);
    }

    public boolean readyForValue(int documentOffset) {
        return this.getAttributeName(documentOffset) != null;
    }

    public int getStringIndexBackward(String string) {
        return this.getStringIndexBackward(string, this._currentOffset);
    }

    public int getStringIndexBackward(String string, int documentOffset) {
        try {
            String text = this._doc.substring(0, documentOffset);
            return text.lastIndexOf(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getStringIndexForward(String string) {
        return this.getStringIndexForward(string, this._currentOffset);
    }

    public int getStringIndexForward(String string, int documentOffset) {
        try {
            return this._doc.indexOf(string, documentOffset);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public Map getAllAttsValues() {
        return this.getAllAttsValues(this._currentOffset);
    }

    public Map getAllAttsValues(int documentOffset) {
        Pattern p;
        Matcher m;
        HashMap<String, String> result = new HashMap<String, String>();
        int start = this._reversed.indexOf(60, this.getReverseOffset(documentOffset));
        start = start != -1 ? this.getReverseOffset(start) : 0;
        int end = this._doc.charAt(documentOffset) == '>' && this.getAttributeName(documentOffset) == null ? documentOffset + 1 : ((m = (p = Pattern.compile("[^\\-]>")).matcher(this._doc)).find(documentOffset) ? m.end() : this._doc.length());
        Pattern regexp = ATTRIBUTE_VALUE_PATTERN;
        try {
            String tag = this._doc.substring(start, end);
            tag = tag.substring(tag.indexOf(32));
            Matcher m2 = regexp.matcher(tag);
            while (m2.find()) {
                String key = m2.group(1);
                String val = m2.group(2);
                result.put(key, val);
                if (m2.end() + m2.group(0).length() >= tag.length()) continue;
                tag = tag.substring(m2.end());
                m2 = regexp.matcher(tag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getQualifier() {
        return this.getQualifier(this._currentOffset);
    }

    public String getQualifier(int documentOffset) {
        Pattern p = QUALIFIER_PATTERN;
        Matcher m = p.matcher(this._reversed);
        if (m.find(this.getReverseOffset(documentOffset))) {
            return this._doc.substring(this.getReverseOffset(m.end()), documentOffset);
        }
        return "";
    }

    public String getAttributeValueQualifier() {
        return this.getAttributeValueQualifier(this._currentOffset);
    }

    public String getAttributeValueQualifier(int documentOffset) {
        int index = this._reversed.indexOf("\"", this.getReverseOffset(documentOffset));
        if (index == -1) {
            return "";
        }
        return this._doc.substring(this.getReverseOffset(index), documentOffset);
    }

    public String getAttributeName() {
        return this.getAttributeName(this._currentOffset);
    }

    public String getAttributeName(int documentOffset) {
        Pattern p = ATTRIBUTE_NAME_PATTERN;
        Matcher m = p.matcher(this._reversed.substring(this.getReverseOffset(documentOffset)));
        if (m.find() && m.start() == 0) {
            String attName = new StringBuffer(m.group(1)).reverse().toString();
            return attName;
        }
        return null;
    }

    public String getParentTagName() {
        return this.getParentTagName(this._currentOffset);
    }

    public String getParentTagName(int documentOffset) {
        int[] indexes = this.getParentTagIndex(documentOffset);
        String foundParent = this.getString(indexes);
        return foundParent == null ? null : foundParent.trim();
    }

    public String getString(int[] indexes) {
        if (indexes != null) {
            return this._doc.substring(indexes[0], indexes[1]);
        }
        return null;
    }

    public String getString(int start, int end) {
        return this._doc.substring(start, end);
    }

    public int[] getParentTagIndex(int documentOffset) {
        int offset;
        int lastSpaceIndex = offset = documentOffset;
        int parentEndTagIndex = -1;
        boolean parentEndTagReached = false;
        boolean inSimpleTag = false;
        Stack<String> stack = new Stack<String>();
        while (true) {
            try {
                char c = this._doc.charAt(--offset);
                if (c == '>' && this._doc.charAt(offset - 1) != '-') {
                    if (this._doc.charAt(offset - 1) != '/') {
                        parentEndTagReached = true;
                        parentEndTagIndex = offset;
                        lastSpaceIndex = offset;
                        continue;
                    }
                    inSimpleTag = true;
                    continue;
                }
                if (c == '<') {
                    if (inSimpleTag) {
                        inSimpleTag = false;
                        continue;
                    }
                    if (this._doc.charAt(offset + 1) == '/') {
                        if (!parentEndTagReached) continue;
                        parentEndTagReached = false;
                        stack.push(this._doc.substring(offset + 2, parentEndTagIndex).trim());
                        lastSpaceIndex = offset + 2;
                        continue;
                    }
                    if (this._doc.charAt(offset + 1) == '!' || this._doc.charAt(offset + 1) == '?') continue;
                    if (!stack.isEmpty()) {
                        String closedName = (String)stack.peek();
                        if (!closedName.equalsIgnoreCase(this._doc.substring(offset + 1, offset + 1 + closedName.length()))) continue;
                        stack.pop();
                        continue;
                    }
                    if (!parentEndTagReached) continue;
                    return new int[]{offset + 1, lastSpaceIndex};
                }
                if (!Character.isWhitespace(c)) continue;
                lastSpaceIndex = offset;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    private int getReverseOffset(int documentOffset) {
        return this._doc.length() - documentOffset;
    }

    public int getOffset() {
        return this._currentOffset;
    }

    public int[] getParentTagIndex() {
        return this.getParentTagIndex(this._currentOffset);
    }

    public String getProjectName() {
        return this._projectName;
    }

    public String getOrganisation() {
        Pattern p = Pattern.compile("<[\\s]*info[^>]*organisation[\\s]*=[\\s]*\"([^\"]+)");
        Matcher m = p.matcher(this._doc);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getDependencyOrganisation() {
        Map otherAttValues = this.getAllAttsValues();
        return this.getDependencyOrganisation(otherAttValues);
    }

    public String getDependencyOrganisation(Map otherAttValues) {
        return otherAttValues != null && otherAttValues.get("org") != null ? (String)otherAttValues.get("org") : this.getOrganisation();
    }
}

