/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jayasoft.ivyde.eclipse.cpcontainer.IvyClasspathContainer;
import org.jayasoft.ivyde.eclipse.cpcontainer.fragmentinfo.IPackageFragmentExtraInfo;
import org.jayasoft.ivyde.eclipse.cpcontainer.fragmentinfo.PreferenceStoreInfo;
import org.jayasoft.ivyde.eclipse.ui.console.IvyConsole;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class IvyPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.jayasoft.ivyde.eclipse";
    public static final String PREF_CONSOLE_DEBUG_COLOR = "org.jayasoft.ivyde.eclipse.console.color.debug";
    public static final String PREF_CONSOLE_VERBOSE_COLOR = "org.jayasoft.ivyde.eclipse.console.color.verbose";
    public static final String PREF_CONSOLE_INFO_COLOR = "org.jayasoft.ivyde.eclipse.console.color.info";
    public static final String PREF_CONSOLE_WARN_COLOR = "org.jayasoft.ivyde.eclipse.console.color.warn";
    public static final String PREF_CONSOLE_ERROR_COLOR = "org.jayasoft.ivyde.eclipse.console.color.error";
    private static IvyPlugin plugin;
    private ResourceBundle resourceBundle;
    private IvyConsole console;
    private static Map _ivysByProject;
    private static Map _ivysByConf;
    private static boolean _inChange;
    private static Set _todo;
    private PreferenceStoreInfo _packageExtraInfo;
    private Map _containers = new HashMap();

    static {
        _ivysByProject = new HashMap();
        _ivysByConf = new HashMap();
        _todo = new HashSet();
    }

    public IvyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IvyPlugin.log(1, "starting IvyDE plugin", null);
        try {
            this.console = new IvyConsole();
        }
        catch (RuntimeException e) {
            IvyPlugin.log(4, "Errors occurred starting the Ivy console", e);
        }
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "ivy_conf_path") {
                    IvyPlugin.ivyConfPathChanged();
                }
                if (event.getProperty() == "acceptedTypes") {
                    IvyPlugin.acceptedTypesChanged();
                }
            }
        });
        IvyPlugin.log(1, "IvyDE plugin started", null);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static void log(IStatus status) {
        IvyPlugin.getDefault().getLog().log(status);
    }

    public static void log(CoreException e) {
        IvyPlugin.log(e.getStatus().getSeverity(), "IvyDE internal error", (Throwable)e);
    }

    public static void log(int severity, String message, Throwable e) {
        IvyPlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static IvyPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = IvyPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.jayasoft.ivyde.IvyPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = new ResourceBundle(){

                protected Object handleGetObject(String key) {
                    return null;
                }

                public Enumeration getKeys() {
                    return Collections.enumeration(Collections.EMPTY_LIST);
                }
            };
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jayasoft.ivyde", (String)path);
    }

    public static Ivy getIvy(IJavaProject javaProject) {
        Ivy ivy = IvyPlugin.refreshIvyConfiguration(javaProject, IvyPlugin.getIvyconfURL(javaProject));
        return ivy == null ? new Ivy() : ivy;
    }

    public static void ivyConfPathChanged() {
        try {
            IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            IvyPlugin.getIvyconfURL();
            int i = 0;
            while (i < projects.length) {
                if (IvyPlugin.getStrictIvyconfURL(projects[i]) == null) {
                    IvyPlugin.resolve(projects[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public static void acceptedTypesChanged() {
        try {
            IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            IvyPlugin.getIvyconfURL();
            int i = 0;
            while (i < projects.length) {
                if ("[inherited]".equals(IvyPlugin.getAcceptedTypesString(projects[i]))) {
                    IvyPlugin.resolve(projects[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private static synchronized Ivy refreshIvyConfiguration(IJavaProject javaProject, String configPath) {
        try {
            URL url;
            if (configPath == null || configPath.trim().length() == 0 || "default".equals(configPath)) {
                return IvyPlugin.defaultIvyConfigure(javaProject);
            }
            IvyConfig ic = (IvyConfig)_ivysByProject.get(javaProject);
            if (ic == null && (ic = (IvyConfig)_ivysByConf.get(configPath)) == null) {
                ic = new IvyConfig();
                _ivysByProject.put(javaProject, ic);
                _ivysByConf.put(configPath, ic);
            }
            if ((url = new URL(configPath)).getProtocol().startsWith("file")) {
                File file = new File(url.getPath());
                if (!file.exists()) {
                    IProject project = javaProject.getProject();
                    File loc = project.getLocation().toFile();
                    file = new File(loc, url.getPath());
                    Message.info((String)("\n\nIVYDE: ivyconf from relative path: " + file.getAbsolutePath()));
                }
                if (!file.exists()) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No ivyConf found", (String)(String.valueOf(configPath) + " ivyconf cannot be found.\nPlease set your ivy conf url in the preference or in your project properties to be able to use IvyDE"));
                    if (ic.ivy == null) {
                        ic.ivy = new Ivy();
                    }
                } else if (file.lastModified() != ic.configTime) {
                    ic.ivy = new Ivy();
                    if (ic.configTime == -1L) {
                        Message.info((String)"\n\n");
                    } else {
                        Message.info((String)"\n\nIVYDE: ivyconf has changed, configuring ivy again\n");
                    }
                    ic.ivy.configure(file);
                    ic.configTime = file.lastModified();
                }
            } else if (ic.ivy == null) {
                ic.ivy = new Ivy();
                ic.ivy.configure(url);
            }
            return ic.ivy;
        }
        catch (Exception e) {
            try {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Bad ivyConf found", (String)("Problem occured while using " + configPath + " to configure Ivy.\nPlease set your ivy conf url properly in the preference or in the project properties to be able to use IvyDE.\nException message: " + e.getMessage()));
            }
            catch (Exception exception) {}
            IvyPlugin.log(2, "Problem occured while using " + configPath + " to configure Ivy", e);
            Message.warn((String)("IVYDE: Problem occured while using " + configPath + " to configure Ivy. See error log for details"));
            _ivysByProject.remove(javaProject);
            _ivysByConf.remove(configPath);
            return new Ivy();
        }
    }

    private static Ivy defaultIvyConfigure(IJavaProject javaProject) {
        Ivy ivy;
        IvyConfig ic = (IvyConfig)_ivysByProject.get(javaProject);
        if (ic == null) {
            ic = (IvyConfig)_ivysByConf.get("default");
        }
        Ivy ivy2 = ivy = ic == null ? null : ic.ivy;
        if (ivy == null) {
            ivy = new Ivy();
            try {
                ivy.configureDefault();
                IvyConfig ivyConfig = new IvyConfig(ivy);
                _ivysByProject.put(javaProject, ivyConfig);
                _ivysByConf.put("default", ivyConfig);
            }
            catch (Exception ex) {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Impossible to configure Ivy", (String)("Problem occured while configuring Ivy with its default configuration.\nPlease set an ivy conf url properly in the preference or in the project properties to be able to use IvyDE.\nException message: " + ex.getMessage()));
                IvyPlugin.log(2, "Problem occured while configuring Ivy with its default configuration.", ex);
                Message.warn((String)"IVYDE: Problem occured while configuring Ivy with its default configuration.. See error log for details");
            }
        }
        return ivy;
    }

    public static String getIvyconfURL(IJavaProject project) {
        String ivyconf = IvyPlugin.getStrictIvyconfURL(project);
        if (ivyconf == null) {
            return IvyPlugin.getIvyconfURL();
        }
        return ivyconf;
    }

    public static String getStrictIvyconfURL(IJavaProject project) {
        if (project == null) {
            return null;
        }
        String opt = IvyPlugin.getDefault().getProjectPreferences(project).get("ivy_conf_path", null);
        if (opt == null || opt.trim().length() == 0 || "inherited".equals(opt)) {
            return null;
        }
        return opt.trim();
    }

    public static String getIvyconfURL() {
        String configPath = IvyPlugin.getDefault().getPreferenceStore().getString("ivy_conf_path");
        if (configPath == null || configPath.trim().length() == 0) {
            return "default";
        }
        return configPath.trim();
    }

    public static void setIvyconfURL(IJavaProject project, String ivyconfURL) {
        _ivysByProject.remove(project);
        if (ivyconfURL == null) {
            IvyPlugin.getDefault().getProjectPreferences(project).put("ivy_conf_path", "inherited");
        } else {
            IvyPlugin.getDefault().getProjectPreferences(project).put("ivy_conf_path", ivyconfURL);
        }
        IvyPlugin.flushProjectPreferences(project);
        IvyPlugin.resolve(project);
    }

    public static boolean accept(IJavaProject project, Artifact artifact) {
        return IvyPlugin.getAcceptedTypes(project).contains(artifact.getType());
    }

    private static Collection getAcceptedTypes(IJavaProject project) {
        String types = IvyPlugin.getAcceptedTypesString(project);
        if ("[inherited]".equals(types)) {
            types = IvyPlugin.getAcceptedTypesString();
        }
        String[] t = types.split(",");
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < t.length) {
            if (t[i].trim().length() > 0) {
                ret.add(t[i].trim());
            }
            ++i;
        }
        return ret;
    }

    private static String getAcceptedTypesString() {
        String types = IvyPlugin.getDefault().getPreferenceStore().getString("acceptedTypes");
        if (types == null || types.trim().length() == 0) {
            return "jar";
        }
        return types.trim();
    }

    public static String getAcceptedTypesString(IJavaProject project) {
        String types = IvyPlugin.getDefault().getProjectPreferences(project).get("acceptedTypes", null);
        if (types == null || types.trim().length() == 0) {
            return "[inherited]";
        }
        return types.trim();
    }

    public static void setAcceptedTypes(IJavaProject project, String types) {
        if (types == null || types.trim().length() == 0 || types.trim().startsWith("[inherited]")) {
            IvyPlugin.getDefault().getProjectPreferences(project).put("acceptedTypes", "[inherited]");
        } else {
            IvyPlugin.getDefault().getProjectPreferences(project).put("acceptedTypes", types);
        }
        IvyPlugin.flushProjectPreferences(project);
        IvyPlugin.resolve(project);
    }

    public IvyConsole getConsole() {
        return this.console;
    }

    public static String getRetreivePattern() {
        if (IvyPlugin.getDefault().getPreferenceStore().getBoolean("do.retreive")) {
            String pattern = IvyPlugin.getDefault().getPreferenceStore().getString("retreive.pattern");
            return pattern == null ? "" : pattern.trim();
        }
        return "";
    }

    public static String getRetreivePattern(IJavaProject project) {
        String pattern = IvyPlugin.getDefault().getProjectPreferences(project).get("retreive.pattern", null);
        return pattern == null ? "" : pattern.trim();
    }

    public static void setRetreivePattern(String pattern) {
        IvyPlugin.getDefault().getPreferenceStore().putValue("retreive.pattern", pattern);
    }

    public static void setRetreivePattern(IJavaProject project, String pattern) {
        if (pattern == null || pattern.trim().length() == 0) {
            pattern = "none";
        } else if (pattern.startsWith("[inherited]")) {
            pattern = "[inherited]";
        }
        IvyPlugin.getDefault().getProjectPreferences(project).put("retreive.pattern", pattern);
        IvyPlugin.flushProjectPreferences(project);
    }

    private static void flushProjectPreferences(IJavaProject project) {
        try {
            IvyPlugin.getDefault().getProjectPreferences(project).flush();
        }
        catch (BackingStoreException e) {
            IvyPlugin.log(2, "impossible to store IvyDE project preferences", e);
        }
    }

    public IPackageFragmentExtraInfo getPackageFragmentExtraInfo() {
        if (this._packageExtraInfo == null) {
            this._packageExtraInfo = new PreferenceStoreInfo(this.getPreferenceStore());
        }
        return this._packageExtraInfo;
    }

    public static String getRetrievePatternHerited(IJavaProject project) {
        String retreivePattern = IvyPlugin.getRetreivePattern(project);
        if ("".equals(retreivePattern) || retreivePattern.startsWith("[inherited]")) {
            retreivePattern = IvyPlugin.getRetreivePattern();
            if (!"".equals(retreivePattern)) {
                retreivePattern = "[inherited] " + retreivePattern;
            }
        } else if ("none".equals(retreivePattern)) {
            retreivePattern = "";
        }
        return retreivePattern.trim();
    }

    public static String getFullRetrievePatternHerited(IJavaProject project) {
        String retreivePattern = IvyPlugin.getRetrievePatternHerited(project);
        if (!"".equals(retreivePattern)) {
            if (retreivePattern.startsWith("[inherited] ")) {
                retreivePattern = retreivePattern.substring("[inherited] ".length());
            }
            return String.valueOf(project.getProject().getLocation().toPortableString()) + "/" + retreivePattern;
        }
        return "";
    }

    public static boolean shouldDoRetrieve(IJavaProject project) {
        return !"".equals(IvyPlugin.getRetrievePatternHerited(project));
    }

    public IEclipsePreferences getProjectPreferences(IJavaProject project) {
        ProjectScope projectScope = new ProjectScope(project.getProject());
        IEclipsePreferences projectNode = projectScope.getNode(ID);
        return projectNode;
    }

    public static void beginChanges() {
        _inChange = true;
    }

    public static void commitChanges() {
        _inChange = false;
        Iterator iter = _todo.iterator();
        while (iter.hasNext()) {
            IJavaProject project = (IJavaProject)iter.next();
            IvyClasspathContainer.resolve(project);
        }
    }

    private static void resolve(IJavaProject project) {
        if (_inChange) {
            _todo.add(project);
        } else {
            IvyClasspathContainer.resolve(project);
        }
    }

    public void register(IvyClasspathContainer container) {
        this._containers.put(String.valueOf(container.getProject().getProject().getName()) + "/" + container.getPath(), container);
    }

    public Collection getAllContainers() {
        Message.debug((String)("all known ivy classpath containers are: " + this._containers.keySet()));
        return this._containers.values();
    }

    private static class IvyConfig {
        Ivy ivy;
        long configTime = -1L;

        public IvyConfig() {
        }

        public IvyConfig(Ivy ivy) {
            this.ivy = ivy;
        }
    }
}

