#ifndef OPROUTE_H
#define OPROUTE_H

#include <vector>
#include <string>
#include <sys/time.h>
#include <map>

enum { HOP_COMPLETED, HOP_FAILED, HOP_PENDING, HOP_ENDOFLINE };
enum { RESP_TIME_EXCEED, RESP_PORT_UNREACH, RESP_HOST_UNREACH, RESP_ERROR, RESP_INCOMPLETE };

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

class OpRouteApp
{
 private:
    string sDestinationIP;
    string sDestinationHost;
    int nBeginTTL;
    int nMaxTTL;
    int nQueries;
    bool bCompare;
    bool bNoResolve;
    float fWaitTime;
    map<string, string> args;
    void ParseArgs(int argc, char *argv[]);
 public:
    OpRouteApp(int argc, char *argv[]);    
    ~OpRouteApp();
    void run();
};

class Hop
{
 public:
  Hop() { sASNumber = ""; sNap = ""; sRouterIP = ""; };
  ~Hop() {};
    int nPort;
    int state;
    float fLatency;
    string sRouterIP;
    
    // these get initialized only from the core.
    string sASNumber;
    string sNap;
};

class OpRoute 
{
 protected:
    // initial variables...
    string sDestinationIP;
    string sDestinationHost;
    int nBeginTTL;
    int nMaxTTL;
    float fWaitTime;
    int nPort;

    // running variables.
    vector<Hop> vRouterHops;
    int nCurrentTTL;
    int recvfd;
    struct timeval tvTimeOfLastSend;

    // stats variables
    float fTotalLatency;
    long nASHops;
    long nNAPHops;
    float nOpScore;
    float fReliability;
    int nLostPackets;
    int nTotalPackets;

    // internal use only functions.
    void SendProbe(int ttl);
    void CatchICMP(Hop *pHop);
    float GetLatencyFromTV(struct timeval now, struct timeval then);
    float GetTotalPacketLoss();
 public:
    bool _bNoResolve;
    int nQueries;
    void CopyFromRouteInfoDB(vector<string> &vData);
    vector<string> CopyToRouteInfoDB();
    virtual string Summary();
    virtual string Summary(OpRoute *pOpnixRoute);
    virtual float GetTotalLatency();
    virtual int GetRouterHops();
    virtual int Step();
    virtual string AsString();
    virtual string Run();
    virtual void Score();
    virtual void GetFromServer(string sDest);
    OpRoute(string sDestination, int nBeginTTL, int nMaxTTL, int nQueries, float fWaitTime, bool bNoResolve = FALSE);
    OpRoute();
    virtual ~OpRoute();
};


#endif
