/*	$Id: poppassd.h,v 1.4 2007-08-03 21:16:24 hngott Exp $ */

/*
 * Copyright (C) 2005-2007 Thomas Birnthaler
 *                         Hermann Gottschalk
 *                         <poppassd@ostc.de>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/queue.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdarg.h>

#define	POPPASSD_USER "_poppass"
#define BUFSIZE       1000
#define VERSION       "1.1"
#define LISTEN_IP     "127.0.0.1"

extern int debug;

/* ipc messages */
enum msg_type {
	MSG_BUF_OVERFLOW   =   1,
	MSG_BUF_UNDERFLOW  =   2,
	MSG_NO_RESPONSE    =   3,
	MSG_CHG_PWD        =   4,
	MSG_AUTH_WRONG     =   5,
	MSG_PWD_TOO_SIMPLE =   6,
	MSG_PASSWD_ERROR   =   7,
	MSG_CHG_OK         = 100,
};

enum err_type {
	ERR_UNKNOWN_USER     =   1,
	ERR_NO_PTY_FOUND     =   2,
	ERR_CANT_PASSWD_FORK =   3,
	ERR_FAILED_ATTEMPT   =   4,
	ERR_WAIT_FAILED      =   5,
	ERR_WRONG_CHILD      =   6,
	ERR_KILLED_CHILD     =   7,
	ERR_CHILD_EXITED     =   8,
};

/* prototypes */
/* log.c */
void		log_init     (int);
void		vlog         (int, const char *, va_list);
void		log_warn     (const char *, ...);
void		log_warnx    (const char *, ...);
void		log_info     (const char *, ...);
void		log_debug    (const char *, ...);
void		fatal        (const char *);
void		fatalx       (const char *);
const char* log_sockaddr (struct sockaddr *);

/* poppassd.c */
enum msg_type change_pw (char* user, char* oldpass, char* newpass, char* errmsg);

/* poppass.c */
pid_t fork_slave (int[2]);

/* slaveclienttalk.c */
void client_talk (int slave_socket, int talk_socket);

/* slavemastertalk.c */
enum msg_type ask_change_pw  (int slave_socket, char* user, char* oldpass, char* newpass, char* errmsg);
enum msg_type recv_change_pw (int cnt, char* buf, char* errmsg);

/* change_passwd.c */
enum err_type change_passwd(char* user, char* oldpass, char* newpass, char* errmsg);
