/* $Id: slavemastertalk.c,v 1.3 2007-04-03 08:19:24 hngott Exp $*/

/*
 * Copyright (C) 2005-2007 Thomas Birnthaler
 *                         Hermann Gottschalk
 *                         <openpoppassd@ostc.de>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Steve Dorner's description of the simple protocol:
 *
 * The server's responses should be like an FTP server's responses;
 * 1xx for in progress, 2xx for success, 3xx for more information
 * needed, 4xx for temporary failure, and 5xx for permanent failure.
 * Putting it all together, here's a sample conversation:
 *
 *   S: 200 poppassd vX.Y hello, who are you?\r\n
 *   E: user YOURLOGINNAME\r\n
 *   S: 300 your password please.\r\n
 *   E: pass YOURCURRENTPASSWORD\r\n
 *   S: 200 your new password please.\r\n
 *   E: newpass YOURNEWPASSWORD\r\n
 *   S: 200 Password changed, thank-you.\r\n
 *   E: quit\r\n
 *   S: 200 Bye.\r\n
 *   S: <closes connection>
 *   E: <closes connection>
 */

#include <sys/param.h>
#include <errno.h>
#include <poll.h>
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "poppassd.h"

/* Prototypes */

enum msg_type
ask_change_pw(int slave_socket, char* user, char* oldpass, char* newpass, char* errmsg)
{
	short length = BUFSIZE;
	char* p;
	char  msg;
	char  buffer[BUFSIZE];
	int   cnt;

	log_debug("slave: ask_change_pw for '%s'", user);

	errmsg[0] = '\0';
	p = (char*) buffer;

	/* Skip length field (filled later) */
	p      += sizeof(length);
	length -= sizeof(length);
	strncpy(p, user, length);

	p      += strlen(user) + 1;
	length -= strlen(user) + 1;
	strncpy(p, oldpass, length);

	p      += strlen(oldpass) + 1;
	length -= strlen(oldpass) + 1;
	strncpy(p, newpass, length);

	p += strlen(newpass) + 1;
	if (p - buffer > BUFSIZE)
		return MSG_BUF_OVERFLOW;

	/* Fill length field */
	*(short*)buffer = length = p - buffer;

	/* Passwort-Change-Message to master */
	write(slave_socket, (char*) buffer, length);

	/* Passwort-Change-Response from master */
	if ((cnt = read(slave_socket, buffer, sizeof(buffer))) == 0)
		return MSG_NO_RESPONSE;

	msg = *buffer;
	if (msg == MSG_PASSWD_ERROR)
		strncpy(errmsg, buffer + 1, cnt - 1);

	return msg;
}

enum msg_type
recv_change_pw(int cnt, char* buffer, char* errmsg)
{
	short* length;
	char*  user;
	char*  oldpass;
	char*  newpass;

	log_debug("slave: recv_change_pw");
	length = (short*) buffer;
	if (cnt != *length)
		return MSG_BUF_UNDERFLOW;

	user    = buffer  + sizeof(short);
	oldpass = user    + strlen(user) + 1;
	newpass = oldpass + strlen(oldpass) + 1;

	log_debug("slave: recv_change_pw '%s'", user);

	return change_pw(user, oldpass, newpass, errmsg);
}
