;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; BootstrapCore.scm
;;
;; Here we define the CoreJscheme primitives using kernel Jscheme
;; This is a heavily bootstrapped file with each definition depending
;; on the earlier ones. I have added lines of semicolons like this
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; to indicate that the following section depends on the previous section
;; On the other hand, definitions inside a section can be reordered.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; define
;; error
;; null? pair? cons first rest list car cdr second third length
;; not boolean and
;; eq? eqv? equal? memq memv member 
;; cond



(set! import (lambda(S) (begin (jsint.Import.addImport (.toString S)) #t)))
(import "jscheme.*")
(import "jsint.*")

(set! define-macro 
 (jscheme.REPL.eval '
  (macro (spec . body) 
     (jsint.Pair. 'set!
      (jsint.Pair. (.first$ spec)
       (jsint.Pair.
           (jsint.Pair. 'macro
            (jsint.Pair. (.rest$ spec) 
              body))
           jsint.Pair.EMPTY$))))))


(define-macro (define var . body)
  ((lambda (cons first rest list pair? set-name!)
      (if (pair? var)
          (list 'set! (first var)
                (list 'set-name! (list 'quote (first var))
                      (cons 'lambda (cons (rest var) body))))
  		    
          (list 'set!  var (list 'set-name! (list 'quote var) (first body)))))
  Pair.
  .first$
  .rest$
  (lambda R R)
  (lambda(p) (.isInstance Pair.class p))
  (lambda(name proc) (.setName proc name) proc) 
  ))

(set! set-name! (lambda(name proc) 
  (if (.isInstance Procedure.class proc) (.setName proc name)) proc))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; error reporting:  (error a b c d) returns #null
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define error (lambda R (.println java.lang.System.out$ (.concat "ERROR:" (.toString R))) #null))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; basic list processing
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define (null? x) (.equals () x))
(define (not x) (.equals #f x))
(define (pair? p) (if (.equals () p) #f (.isInstance Pair.class p)))
(define cons Pair.)
(define first .first$)
(define rest .rest$)
(define list (set-name! 'list (lambda R R)))
(define car .first$)
(define cdr .rest$)
(define (caar L) (car (car L)))
(define (cadr L) (car (cdr L)))
(define (cdar L) (cdr (car L)))
(define (cddr L) (cdr (cdr L)))
(define (second L) (first (rest L)))
(define (third L) (first (rest (rest L))))

(define (length L) 
  (define (iter L N) (if (null? L) N (iter (rest L) (Op.add N 1))))
  (iter L 0))

(define append (lambda Lists
  (define (appendtwo L R)
    (if (null? L) R (cons (first L) (appendtwo (rest L) R))))
  (define (iter Lists)
    (if (null? Lists)
        ()
      (if (null? (cdr Lists))
          (car Lists)
          (appendtwo (car Lists) (iter (cdr Lists))))))
  (iter Lists)))

(define (reverse L)
  (define (iter L R) (if (null? L) R (iter (cdr L) (cons (first L) R))))
  (iter L ()))

(define (list-tail L N)
  (if (or (< N 1) (null? L)) L
      (list-tail (cdr L) (- N 1))))

(define (list-ref L N) (first (list-tail L N)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; type predicates
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (boolean? x) (.isInstance java.lang.Boolean.class x))
(define (symbol? S) (.isInstance Symbol.class S))
(define (number? N) (.isInstance java.lang.Number.class N))
(define (string? x) (.isInstance java.lang.String.class x))
(define (vector? v) (.isArray (.getClass v)))
(define (procedure? x) (.isInstance Procedure.class x))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; boolean ops  and simple comparisons
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-macro (and . args)
    (if (null? args)
         #t
	 (if (null? (rest args)) 
             (first args)
	     (list 'if (first args) (cons 'and (rest args)) #f))))

(define eq? Op.sameObject)

(define eqv? Op.eqv)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; equality
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (equal? x y)
  (define (eqpair? x y)                  
     (and (equal? (first x) (first y)) 
          (equal? (rest x) (rest y))))
  (define (eqarray? x y)
     (and (eqv? (java.lang.reflect.Array.getLength x) (java.lang.reflect.Array.getLength y))
          (eqarrayiter? (- (java.lang.reflect.Array.getLength x) 1) x y)))
  (define (eqarrayiter? N x y)
     (if (< N 1) #t
     (if (equal? (java.lang.reflect.Array.get x N) (java.lang.reflect.Array.get y N))
         (eqarrayiter? (- N 1) x y)
         #f)))
  (if (eqv? x y)
       #t
    (if (and (pair? x) (pair? y)) 
        (eqpair? x y)
      (if (and (.isArray (.getClass x)) (.isArray (.getClass y)))
          (eqarray? x y)
          #f))))
         
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; membership
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (memq x L)
  (if (or (null? L) (not(pair? L))) 
      #f
      (if (eq? x (first L))
           L
          (memq x (cdr L)))))
(define (memv x L)
  (if (or (null? L) (not(pair? L))) 
      #f
      (if (eqv? x (first L))
           L
          (memv x (cdr L)))))
(define (member x L)
  (if (or (null? L) (not(pair? L))) 
      #f
      (if (equal? x (first L))
           L
          (member x (cdr L)))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-macro (cond . clauses)
    (define (process-clause clause else-part)
      (if (not (pair? clause)) ;; atom
          (error '(bad cond clause:) clause)
          (if (null? (rest clause)) ;; (test)
              (list 'or (first clause) else-part)
              (if (eq? (second clause) '=>) ;; (test => proc)
                  (list (list 'lambda '(<_>) 
                         (list 'if '<_> (list (third clause) '<_>) else-part))
                        (first clause))
                  (if (member (first clause) '(#t else)) ;; (else x y z)
                      (cons 'begin (rest clause))
                      (list 'if (first clause) (cons 'begin (rest clause)) 
                            else-part))))))
    ;; body of cond
    (if (null? clauses)
        #f
        (process-clause (first clauses) (cons 'cond (rest clauses)))))

(define-macro (tryCatch . args) (list 'Procedure.tryCatch (list 'lambda () (first args)) (second args)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;; (define eval REPL.eval)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The quasiquote, and a few others, are from Darius Bacon <djello@well.com>
;; (But then, he started with Peter Norvig's PAIP code, and modified it.)

(define-macro (quasiquote x)
    (define (constant? exp)
      (if (pair? exp) (eq? (car exp) 'quote) (not (symbol? exp))))
    (define (combine-skeletons left right exp)
      (cond
       ((and (constant? left) (constant? right)) 
	(if (and (eqv? (eval left) (car exp))
		 (eqv? (eval right) (cdr exp)))
	    (list 'quote exp)
	    (list 'quote (cons (eval left) (eval right)))))
       ((null? right) (list 'list left))
       ((and (pair? right) (eq? (car right) 'list))
	(cons 'list (cons left (cdr right))))
       (else (list 'cons left right))))
    (define (expand-quasiquote exp nesting)
      (cond
       ((vector? exp)
	(list 'apply 'vector (expand-quasiquote (vector->list exp) nesting)))
       ((not (pair? exp)) 
	(if (constant? exp) exp (list 'quote exp)))
       ((and (eq? (car exp) 'unquote) (eqv? (length exp) 2))
	(if (eqv? nesting 0)
	    (second exp)
	    (combine-skeletons ''unquote 
			       (expand-quasiquote (cdr exp) (- nesting 1))
			       exp)))
       ((and (eq? (car exp) 'quasiquote) (eqv? (length exp) 2))
	(combine-skeletons ''quasiquote 
			   (expand-quasiquote (cdr exp) (+ nesting 1))
			   exp))
       ((and (pair? (car exp))
	     (eq? (caar exp) 'unquote-splicing)
	     (eqv? (length (car exp)) 2))
	(if (eqv? nesting 0)
	    (list 'append (second (first exp))
		  (expand-quasiquote (cdr exp) nesting))
	    (combine-skeletons (expand-quasiquote (car exp) (- nesting 1))
			       (expand-quasiquote (cdr exp) nesting)
			       exp)))
       (else (combine-skeletons (expand-quasiquote (car exp) nesting)
				(expand-quasiquote (cdr exp) nesting)
				exp))))
    (expand-quasiquote x 0))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define (apply x y) (.apply x y))

(define map 
  (lambda (F . Lists)
    (define (firsts L) (if (null? L) () (cons (first (first L)) (firsts (rest L)))))
    (define (rests L) (if (null? L) () (cons (rest  (first L)) (rests  (rest L)))))
    (if (null? (first Lists)) ()
        (cons (apply F (firsts Lists))
              (apply map (cons F (rests Lists)))))))

(define for-each
  (lambda (F . Lists)
    (define (firsts L) (if (null? L) () (cons (first (first L)) (firsts (rest L)))))
    (define (rests L) (if (null? L) () (cons (rest  (first L)) (rests  (rest L)))))
    (if (null? (first Lists)) ()
        (begin
           (apply F (firsts Lists)) 
           (apply for-each (cons F (rests Lists)))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




(define-macro (let bindings . body)
    (define (named-let name bindings body)
      `(let ((,name #f))
	 (set! ,name (lambda ,(map first bindings) . ,body))
	 (,name . ,(map second bindings))))
    (if (symbol? bindings) 
	(named-let bindings (first body) (rest body))
	`((lambda ,(map first bindings) . ,body) . ,(map second bindings))))

(define-macro (let* bindings . body )
    (if (null? bindings) `((lambda () . ,body))
	`(let (,(first bindings))
	   (let* ,(rest bindings) . ,body))))

(define-macro (letrec bindings . body)
    (let ((vars (map first bindings))
	  (vals (map second bindings)))
    `(let ,(map (lambda (var) `(,var #f)) vars)
       ,@(map (lambda (var val) `(set! ,var ,val)) vars vals)
       . ,body)))
    
(define-macro (case exp . cases)
    (define (do-case case)
      (cond ((not (pair? case)) (error '(bad syntax in case:) case))
	    ((eq? (first case) 'else) case)
	    (else `((member <exp> ',(first case)) . ,(rest case)))))
    `(let ((<exp> ,exp)) (cond . ,(map do-case cases))))

(define-macro (do bindings test-and-result . body)
    (let ((variables (map first bindings))
	  (inits (map second bindings))
	  (steps (map (lambda (clause)
			(if (null? (cddr clause))
			    (first clause)   
			    (third clause)))
		      bindings))
	  (result (if (null? (cdr test-and-result)) ''unspecified
		      `(begin . ,(cdr test-and-result)))))
      `(letrec ((<loop>
		 (lambda ,variables
		   (if ,(first test-and-result)
		       ,result
		       (begin 
			 ,@body
			 (<loop> . ,steps))))))
	 (<loop> . ,inits))))

(define-macro (delay . exp)
    (define (make-promise proc)
      (let ((result-ready? #f)
	    (result #f))
	(lambda ()
	  (if result-ready?
	      result
	      (let ((x (proc)))
		(if result-ready?
		    result
		    (begin (set! result-ready? #t)
			   (set! result x)
			   result)))))))
    `(,make-promise (lambda () ,exp)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (number? N) (.isInstance Number.class N))
(define = Op.eq)
(define < Op.lt)
(define > Op.gt)
(define <= Op.le)
(define >= Op.ge)

(define + 
  (let ((BMO Op.genericBinaryMultiOp)
        (ADD Op.ADD$))
    (lambda R (BMO ADD 0 R))))

(define * 
  (let ((BMO Op.genericBinaryMultiOp)
        (MUL Op.MUL$))
    (lambda R (BMO MUL 1 R))))


;; (define + 
;;   (letrec 
;;     ((iter (lambda (x L) 
;;            (if (null? L) x 
;;                  (let ((y (first L))) (iter (Op.add x y) (rest L)))))))
;;  (lambda L
;;    (if (null? L) 0
;;    (iter (first L) (rest L))))))

;; (define *
;;  (letrec ((iter (lambda (x L) (if (null? L) x (let ((y (first L))) (iter (Op.mul x y) (rest L)))))))
;;   (lambda L
;;     (if (null? L) 1
;;     (iter (first L) (rest L))))))
;; 

(define - (lambda R
  (cond ((null? R) 0)
        ((null? (cdr R)) (Op.sub 0 (car R)))
        (else (Op.sub (car R) (cadr R))))))

(define (/ a b)  (Op.div a b))

(define max 
 (letrec ((iter (lambda (x L) (if (null? L) x (let ((y (first L))) (iter (if (> x y) x y) (rest L)))))))
  (lambda L
   (iter (first L) (rest L)))))

(define min 
 (letrec ((iter (lambda (x L) (if (null? L) x (let ((y (first L))) (iter (if (< x y) x y) (rest L)))))))
  (lambda L
   (iter (first L) (rest L)))))

;; Java Scalar Operations
(define %    Op.mod)
(define &    Op.and)
(define ^    Op.xor)
(define |    Op.or)
(define ~    Op.complement)        ;; I need a complement operator by itself
(define <<   Op.leftShift)
(define >>   Op.rightShift)
(define >>>  Op.rightShiftZ)
(define ==   Op.eqv) ;; scalar equality
(define !=   Op.ne) ;; number disequality

(define (list->array ComponentType L)
  (define A  (java.lang.reflect.Array.newInstance ComponentType (length L)))
  (define (store L I)
     (if (eq? L ()) A
        (begin
          (java.lang.reflect.Array.set A I (.first$ L))
          (store (.rest$ L) (+ I 1)))))
  (store L 0))


(define (array->list A)
  (define (make-list I L)
   (begin
    (if (< I 0) L
        (make-list (- I 1) 
            (Pair. (java.lang.reflect.Array.get A I) L)))))
  (make-list (- (java.lang.reflect.Array.getLength A) 1) ()))
