;;;
;;; Adaptive classpath
;;;

"

The class loader used by Jscheme can be accessed with
(jsint.Import.getClassLoader) and (jsint.Import.setClassLoader).  The
procedures below let you extend the class path or replace it
altogher.

(replaceClassLoaders) creates a new class loader and resets Jscheme's
internal caches, so that classes can be recompiled and tested easily.

"

(load "elf/util.scm")
(import "java.net.URLClassLoader")
(import "java.net.URL")
(import "java.io.File")

(define-method (url (x String))
  ;; Return a URL
  (tryCatch (URL. x)
	    (lambda (e)
	      (or (and (instanceof e java.net.MalformedURLException.class)
		       (url (File. x)))
		  (throw e)))))

(define-method (url (url File)) (.toURL url))

(define-method (url (url URL)) url)

(define (URLClassLoader URLs parent)
  ;; Return a ClassLoader given a list of URL's and its parent loader.
  (URLClassLoader. (list->array URL.class (map url URLs))
		   parent))

(define-method (extendClassPath (URLs Pair))
  ;; Extend Jscheme's classpath to include the list of URL's.
  ;; Works with a single URL or a list of URLs.
  (Import.setClassLoader (URLClassLoader URLs (Import.getClassLoader))))
(define-method (extendClassPath (URLs Object))
  (extendClassPath (list URLs)))

(define (replaceClassPath URLs)
  ;; Replace JScheme's classpath with this one.
  (Import.setClassLoader
   (URLClassLoader URLs (.getClassLoader Import.class))))

(define (copyClassLoader loader)
  ;; Copy the chain of URLClassLoaders.
  (if (and (instanceof loader java.net.URLClassLoader.class)
	   (not (eq? loader (.getClassLoader jsint.Import.class))))
      (URLClassLoader. (.getURLs loader) (copyClassLoader (.getParent loader)))
      loader))

(define (replaceClassLoaders)
  ;; Replace the class
  (jsint.Import.setClassLoader (copyClassLoader (jsint.Import.getClassLoader)))
  (.clear Import.table$)
  (for-each* .reset Import.singles$)
  (for-each* .reset Import.wilds$)

  (.clear Invoke.constructorCache$)
  (.clear Invoke.staticCache$)
  (.clear Invoke.instanceCache$)

  (jsint.Reflector.resetAll)

  (iterate
   (.elements (.clone Symbol.symbolTable$))
   (lambda (s) (if (and (.isDefined s)
			(instanceof (.getGlobalValue s) Class.class))
		   (.setGlobalValue s U.UNDEFINED$)))))
