;;; Jscheme specific code.
(display "NOTE!!!
Java files in the demo/ and elf/ directories are not compiled
by this script because they require additional *.jar files.
If you compile them by hand, they will be included in the jscheme.jar.
!!!NOTE
")

(let* ((bin (find-javac-bin))
       (javac (list (File. bin "javac") "-classpath" "."))
       (java  (list (File. bin "java")  "-classpath" "."))
       (jar (File. bin "jar")))

  (and
   (run javac "-g" (files "jsint" java-file?))
   (begin (load "jsint/listener.scm")   #t)
   (begin (load "jsint/primitives.scm") #t)
   (run javac "-g" "jsint/Primitive.java" "jsint/Listener.java")
   (run javac "-g" (files "jlib" java-file?))
   (run javac "-g" (files "interact" java-file?))
   (run jar "cvfm" "../lib/jscheme.jar" "jsint/manifest"
	(files "." class-file?)
	(files "." scheme-file?))
   (exit)
   ))
