/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.Serializable;
import jscheme.SchemePair;
import jscheme.SchemeProcedure;
import jsint.BacktraceException;
import jsint.E;
import jsint.Environment;
import jsint.JschemeThrowable;
import jsint.Pair;
import jsint.Scheme;
import jsint.U;

public abstract class Procedure
implements Runnable,
Serializable,
SchemeProcedure {
    public String name = "??";
    public int minArgs = 0;
    public int maxArgs = Integer.MAX_VALUE;

    public Procedure() {
    }

    public Procedure(int minArgs, int maxArgs) {
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
    }

    public String getName() {
        return this.name;
    }

    public Object setName(Object name) {
        if (this.name == "??") {
            this.name = name.toString();
        }
        return name;
    }

    public int nParms() {
        return this.minArgs == this.maxArgs ? this.minArgs : this.minArgs + 1;
    }

    protected String toStringArgs() {
        if (this.minArgs == this.maxArgs) {
            return "[" + this.minArgs + "]";
        }
        return "[" + this.minArgs + "," + (this.maxArgs == Integer.MAX_VALUE ? "n" : String.valueOf(this.maxArgs)) + "]";
    }

    public String toString() {
        return "{" + this.getClass().getName() + " " + this.name + this.toStringArgs() + "}";
    }

    public void run() {
        if (this.minArgs == 0) {
            this.apply(Pair.EMPTY);
        } else {
            E.error("This procedure can't be run()", this);
        }
    }

    public abstract Object apply(Object[] var1);

    public Object apply(SchemePair args) {
        return this.apply(this.makeArgArray((Pair)args));
    }

    public Object apply(Pair args) {
        return this.apply(this.makeArgArray(args));
    }

    public static Object tryCatch(Object E2, Object F) {
        try {
            return ((Procedure)E2).apply(Pair.EMPTY);
        }
        catch (Throwable e) {
            return ((Procedure)F).apply(new Pair(Procedure.stripExceptionWrapper(e), Pair.EMPTY));
        }
    }

    private static Object stripExceptionWrapper(Object e) {
        if (e instanceof BacktraceException) {
            return Procedure.stripExceptionWrapper(((BacktraceException)e).getBaseException());
        }
        if (e instanceof JschemeThrowable) {
            return Procedure.stripExceptionWrapper(((JschemeThrowable)e).contents);
        }
        return e;
    }

    public static Object tryFinally(Object e, Object f) {
        Object object;
        try {
            object = ((Procedure)e).apply(Pair.EMPTY);
            Object var4_3 = null;
            ((Procedure)f).apply(Pair.EMPTY);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((Procedure)f).apply(Pair.EMPTY);
            throw throwable;
        }
        return object;
    }

    public static Object throwRuntimeException(RuntimeException E2) throws RuntimeException {
        throw E2;
    }

    public static Object throwObject(Object e) throws Throwable {
        if (e instanceof Throwable) {
            throw (Throwable)e;
        }
        return E.error("can't throw object " + e);
    }

    public static Object synchronize(Object x, Procedure p) {
        Object object = x;
        synchronized (object) {
            Object object2 = p.apply(new Pair(x, Pair.EMPTY));
            return object2;
        }
    }

    public Object[] makeArgArray(Object[] code, Environment env) {
        Procedure p = this;
        Object[] argArray = new Object[p.nParms()];
        int nargs = code.length - 1;
        int pminargs = p.minArgs;
        if (nargs < pminargs) {
            E.error("\nToo few arguments to procedure " + p.name + " expected at least " + pminargs + ", but found " + nargs + " arguments:\n***************\n    " + U.stringify(code) + "\n************\n");
        }
        if (nargs > p.maxArgs) {
            E.error("\nToo many arguments to procedure " + p.name + " expected at most " + p.maxArgs + ", but found " + nargs + " arguments:\n***************\n    " + U.stringify(code) + "\n************\n");
        }
        int i = 0;
        while (i < pminargs) {
            argArray[i] = Scheme.execute(code[i + 1], env);
            ++i;
        }
        if (p.maxArgs > pminargs) {
            if (p.maxArgs == pminargs + 1) {
                argArray[pminargs] = code.length > p.maxArgs ? Scheme.execute(code[pminargs + 1], env) : U.MISSING;
            } else {
                Pair tail = Pair.EMPTY;
                int i2 = nargs;
                while (i2 > pminargs) {
                    tail = new Pair(Scheme.execute(code[i2], env), tail);
                    --i2;
                }
                argArray[pminargs] = tail;
            }
        }
        return argArray;
    }

    public Object[] makeArgArray(Pair args) {
        return Scheme.makeArgArray(this, args);
    }
}

