/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jsint.BacktraceException;
import jsint.E;
import jsint.Import;
import jsint.JavaField;
import jsint.Pair;
import jsint.U;

public class Invoke {
    public static final int BUCKET_SIZE = 2;
    public static final Hashtable constructorCache = new Hashtable(50);
    public static final Hashtable staticCache = new Hashtable(50);
    public static final Hashtable instanceCache = new Hashtable(100);
    static final boolean ALLOW_PRIVATE_ACCESS = true;
    private static boolean CAN_GET_DECLARED_METHODS = Invoke.canGetDeclaredMethods();
    static Method SETACCESSIBLE = Invoke.getSetAccessibleMethod();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$jsint$Invoke;

    public static Object peek(Object target, String name) {
        return Invoke.peek0(target.getClass(), name, target);
    }

    public static Object peekStatic(Class c, String name) {
        return Invoke.peek0(c, name, c);
    }

    private static Object peek0(Class c, String name, Object target) {
        try {
            return c.getField(name).get(target);
        }
        catch (NoSuchFieldException e) {
            return E.error(target + " has no field named " + name);
        }
        catch (IllegalAccessException e) {
            return E.error("Can't access the " + name + " field of " + target);
        }
    }

    public static Object poke(Object target, String name, Object value) {
        return Invoke.poke0(target.getClass(), name, target, value);
    }

    public static Object pokeStatic(Class c, String name, Object value) {
        return Invoke.poke0(c, name, c, value);
    }

    private static Object poke0(Class c, String name, Object target, Object value) {
        try {
            c.getField(name).set(target, value);
            return value;
        }
        catch (NoSuchFieldException e) {
            return E.error(target + " has no field named " + name);
        }
        catch (IllegalAccessException e) {
            return E.error("Can't access the " + name + " field of " + target);
        }
    }

    public static Object invokeConstructor(String c, Object[] args) {
        Object[] ms = Invoke.constructorTable(c);
        return Invoke.invokeRawConstructor((Constructor)Invoke.findMethod(ms, args), args);
    }

    public static Object invokeRawConstructor(Constructor m, Object[] args) {
        try {
            return m.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new BacktraceException(e.getTargetException(), new Object[]{m, args});
        }
        catch (InstantiationException e) {
            return E.error("Error during instantiation: ", U.list(e, m, args));
        }
        catch (IllegalAccessException e) {
            return E.error("Bad constructor application:", U.list(e, m, args));
        }
    }

    public static Object invokeStatic(Class c, Object name, Object[] args) {
        return Invoke.invokeMethod(c, c, name, args, true);
    }

    public static Object invokeInstance(Object target, Object name, Object[] args) {
        return Invoke.invokeInstance(target, name, args, false);
    }

    public static Object invokeInstance(Object target, Object name, Object[] args, boolean canAccessPrivateData) {
        return Invoke.invokeMethod(target.getClass(), target, name, args, false, canAccessPrivateData);
    }

    public static Object invokeMethod(Class c, Object target, Object name, Object[] args, boolean isStatic) {
        return Invoke.invokeMethod(c, target, name, args, isStatic, false);
    }

    public static Object invokeMethod(Class c, Object target, Object name, Object[] args, boolean isStatic, boolean canAccessPrivateData) {
        Object[] ms = Invoke.methodTable(c, name, isStatic, canAccessPrivateData);
        return Invoke.invokeRawMethod((Method)Invoke.findMethod(ms, args), target, args);
    }

    public static Object invokeRawMethod(Method m, Object target, Object[] args) {
        try {
            return m.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw new BacktraceException(e.getTargetException(), new Object[]{m, target, args});
        }
        catch (IllegalAccessException e) {
            return E.error("Bad method application from a private class: ", U.list(e, m, args));
        }
        catch (IllegalArgumentException e) {
            return Invoke.invokeWidenedRawMethod(m, target, args);
        }
    }

    private static Object invokeWidenedRawMethod(Method m, Object target, Object[] args) {
        Object[] widened = new Object[args.length];
        Class<?>[] types = m.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            widened[i] = JavaField.narrow(args[i], types[i]);
            ++i;
        }
        try {
            return m.invoke(target, widened);
        }
        catch (InvocationTargetException e) {
            throw new BacktraceException(e.getTargetException(), new Object[]{m, target, args});
        }
        catch (IllegalAccessException e) {
            return E.error("Bad method application from a private class: ", U.list(e, m, args));
        }
        catch (IllegalArgumentException e) {
            if (args == null) {
                return E.error(e + "\n " + m.toString() + "\n called with target: " + U.stringify(target) + " and a null argument vector.");
            }
            return E.error(e + "\nARGUMENT MISMATCH for method \n\n  " + m.toString() + "\n called with " + U.vectorToList(args));
        }
    }

    public static Object[] constructorTable(String c) {
        return Invoke.constructorTable(c, false);
    }

    public static Object[] constructorTable(String c, boolean canAccessPrivateData) {
        String fullName = canAccessPrivateData ? c.concat("#") : c;
        Object[] result = (Object[])constructorCache.get(fullName);
        if (result == null) {
            try {
                result = canAccessPrivateData ? Invoke.methodArray(Invoke.makeAccessible(Import.classNamed(c).getDeclaredConstructors())) : Invoke.methodArray(Import.classNamed(c).getConstructors());
            }
            catch (Exception e) {
                result = Invoke.methodArray(Import.classNamed(c).getConstructors());
            }
            constructorCache.put(fullName, result);
        }
        if (result.length == 0) {
            return (Object[])E.error("Constructor " + fullName + " has no methods.");
        }
        return result;
    }

    private static Hashtable getMethodCache(boolean isStatic) {
        return isStatic ? staticCache : instanceCache;
    }

    private static Hashtable getNameTable(Hashtable table, Object name) {
        Hashtable nameTable = (Hashtable)table.get(name);
        if (nameTable != null) {
            return nameTable;
        }
        nameTable = new Hashtable(10);
        table.put(name, nameTable);
        return nameTable;
    }

    public static Object[] getCachedMethodTable(Class c, Object name, boolean isStatic) {
        return (Object[])Invoke.getNameTable(Invoke.getMethodCache(isStatic), name).get(c);
    }

    public static void putCachedMethodTable(Class c, Object name, boolean isStatic, Object value) {
        Invoke.getNameTable(Invoke.getMethodCache(isStatic), name).put(c, value);
    }

    public static Object[] methodTable0(Class c, Object name, boolean isStatic) {
        return Invoke.methodTable0(c, name, isStatic, false);
    }

    public static Object[] methodTable0(Class c, Object name, boolean isStatic, boolean canAccessPrivateData) {
        String internalName = canAccessPrivateData ? name.toString().concat("#") : name.toString();
        Object[] result1 = Invoke.getCachedMethodTable(c, internalName, isStatic);
        if (result1 == null) {
            result1 = Invoke.methodTableLookup(c, name, isStatic, canAccessPrivateData);
            Invoke.putCachedMethodTable(c, internalName, isStatic, result1);
        }
        return result1;
    }

    public static Object[] methodTable(Class c, Object name, boolean isStatic) {
        return Invoke.methodTable(c, name, isStatic, false);
    }

    public static Object[] methodTable(Class c, Object name, boolean isStatic, boolean canAccessPrivateData) {
        Object[] result1 = Invoke.methodTable0(c, name, isStatic, canAccessPrivateData);
        if (result1 == null || result1.length == 0) {
            if (isStatic) {
                return (Object[])E.error("ERROR: \nNO STATIC METHOD  OF TYPE  \n\n  (" + c.getName() + "." + name + " ...)");
            }
            return (Object[])E.error("ERROR: \nNO INSTANCE METHOD OF TYPE \n\n  (." + name + " " + c.getName() + " ...)");
        }
        return result1;
    }

    public static Object[] methodTableLookup(Class c, Object name, boolean isStatic) {
        return Invoke.methodTableLookup(c, name, isStatic, false);
    }

    public static Object[] methodTableLookup(Class c, Object name, boolean isStatic, boolean canAccessPrivateData) {
        if (isStatic) {
            return Invoke.methodTableLookupStatic(c, name, canAccessPrivateData);
        }
        return Invoke.methodTableLookupInstance(c, name, canAccessPrivateData);
    }

    public static Object[] methodTableLookupStatic(Class c, Object name) {
        return Invoke.methodTableLookupStatic(c, name, false);
    }

    public static Object[] methodTableLookupStatic(Class c, Object name, boolean canAccessPrivateData) {
        Method[] ms = Invoke.getMethods(c, canAccessPrivateData);
        Vector<Method> result = new Vector<Method>(ms.length);
        String theName = name.toString();
        int i = 0;
        while (i < ms.length) {
            Method m = ms[i];
            if (Modifier.isStatic(m.getModifiers()) && m.getName().equals(theName)) {
                result.addElement(m);
            }
            ++i;
        }
        Object[] result1 = new Object[result.size()];
        result.copyInto(result1);
        return Invoke.methodArray(result1);
    }

    public static Object[] methodTableLookupInstance(Class c, Object name) {
        return Invoke.methodTableLookupInstance(c, name, false);
    }

    public static Object[] methodTableLookupInstance(Class c, Object name, boolean canAccessPrivateData) {
        String theName = name.toString();
        Vector result = Invoke.methodVector(c, theName, canAccessPrivateData);
        Object[] result1 = new Object[result.size()];
        result.copyInto(result1);
        return Invoke.methodArray(result1);
    }

    public static Vector methodVector(Class c, String name) {
        return Invoke.methodVector(c, name, false);
    }

    public static Vector methodVector(Class c, String name, boolean canAccessPrivateData) {
        return Invoke.methodVectorMerge(c, name, new Vector(10), canAccessPrivateData);
    }

    public static Vector methodVectorMerge(Class c, String name, Vector result) {
        return Invoke.methodVectorMerge(c, name, result, false);
    }

    public static Vector methodVectorMerge(Class c, String name, Vector result, boolean canAccessPrivateData) {
        Class s = c.getSuperclass();
        if (s != null) {
            result = Invoke.methodVectorMerge(s, name, result, canAccessPrivateData);
        }
        Class<?>[] is = c.getInterfaces();
        int i = 0;
        while (i < is.length) {
            result = Invoke.methodVectorMerge(is[i], name, result, canAccessPrivateData);
            ++i;
        }
        Method[] ms = Invoke.getMethods(c, canAccessPrivateData);
        int i2 = 0;
        while (i2 < ms.length) {
            Method m = ms[i2];
            if (!Modifier.isStatic(m.getModifiers()) && m.getName().equals(name)) {
                Invoke.maybeAdd(result, m);
            }
            ++i2;
        }
        return result;
    }

    private static void maybeAdd(Vector result, Method m1) {
        int i = 0;
        while (i < result.size()) {
            Method m2 = (Method)result.elementAt(i);
            if (Invoke.parameterTypesMatch(Invoke.getParameterTypes(m1), Invoke.getParameterTypes(m2))) {
                return;
            }
            ++i;
        }
        result.addElement(m1);
    }

    private static Class[] getParameterTypes(Object m) {
        return m instanceof Method ? ((Method)m).getParameterTypes() : ((Constructor)m).getParameterTypes();
    }

    private static Object[] methodArray(Object[] v) {
        Object[] result = new Object[v.length * 2];
        int i = 0;
        while (i < v.length) {
            result[i * 2] = Invoke.getParameterTypes(v[i]);
            result[i * 2 + 1] = v[i];
            ++i;
        }
        return result;
    }

    public static boolean parameterTypesMatch(Class[] p1, Class[] p2) {
        if (p1.length == p2.length) {
            int i = 0;
            while (i < p1.length) {
                if (p1[i] != p2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static Object findMethod(Object[] methods, Object[] args) {
        if (methods.length == 2) {
            return methods[1];
        }
        return Invoke.findMethodNoOpt(methods, args);
    }

    static Object findMethodNoOpt(Object[] methods, Object[] args) {
        int i;
        int best = -1;
        int m1 = 0;
        while (m1 < methods.length) {
            Class[] p1 = (Class[])methods[m1];
            if (Invoke.isApplicable(p1, args) && (best == -1 || !Invoke.moreApplicable((Class[])methods[best], p1))) {
                best = m1;
            }
            m1 += 2;
        }
        if (best != -1) {
            return methods[best + 1];
        }
        StringBuffer alts = new StringBuffer();
        int m12 = 0;
        while (m12 < methods.length) {
            if (methods[m12 + 1] instanceof Member) {
                alts.append("   * " + methods[m12 + 1] + "\n");
            } else {
                Class[] ts = (Class[])methods[m12];
                alts.append("   * " + methods[m12 + 1] + " ( ");
                i = 0;
                while (i < ts.length) {
                    alts.append(ts[i] + " ");
                    ++i;
                }
                alts.append(")\n");
            }
            m12 += 2;
        }
        StringBuffer argtypes = new StringBuffer();
        i = 0;
        while (i < args.length) {
            argtypes.append(" " + args[i].getClass() + " ");
            ++i;
        }
        return E.error("\n\nERROR: NO " + (methods[1] instanceof Member ? (methods[1] instanceof Method ? "METHOD" : "CONSTRUCTOR") : "PROCEDURE") + " WITH NAME\n    " + (methods[1] instanceof Member ? ((Member)methods[1]).getName() : "?") + "\n and args\n     " + U.vectorToList(args) + "\n of types \n    " + argtypes.toString() + "\n\n possible alternatives are :\n" + alts.toString() + "\n\n");
    }

    public static boolean isApplicable(Class[] types, Object[] args) {
        if (types.length == args.length) {
            int i = 0;
            while (i < args.length) {
                if (!Invoke.isArgApplicable(types[i], args[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean isArgApplicable(Class p, Object a) {
        return a == null && (class$java$lang$Object == null ? (class$java$lang$Object = Invoke.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(p) || p.isInstance(a) || p.isPrimitive() && Invoke.primitiveWrapperType(p).isInstance(a);
    }

    private static Class primitiveWrapperType(Class p) {
        Class clazz = p == Byte.TYPE ? (class$java$lang$Byte == null ? (class$java$lang$Byte = Invoke.class$("java.lang.Byte")) : class$java$lang$Byte) : (p == Long.TYPE ? (class$java$lang$Long == null ? (class$java$lang$Long = Invoke.class$("java.lang.Long")) : class$java$lang$Long) : (p == Float.TYPE ? (class$java$lang$Float == null ? (class$java$lang$Float = Invoke.class$("java.lang.Float")) : class$java$lang$Float) : (p == Short.TYPE ? (class$java$lang$Short == null ? (class$java$lang$Short = Invoke.class$("java.lang.Short")) : class$java$lang$Short) : (p == Double.TYPE ? (class$java$lang$Double == null ? (class$java$lang$Double = Invoke.class$("java.lang.Double")) : class$java$lang$Double) : (p == Boolean.TYPE ? (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Invoke.class$("java.lang.Boolean")) : class$java$lang$Boolean) : (p == Integer.TYPE ? (class$java$lang$Integer == null ? (class$java$lang$Integer = Invoke.class$("java.lang.Integer")) : class$java$lang$Integer) : (p == Character.TYPE ? (class$java$lang$Character == null ? (class$java$lang$Character = Invoke.class$("java.lang.Character")) : class$java$lang$Character) : (Class)E.error("unknow primitive type: ", p))))))));
        return clazz;
    }

    private static boolean moreApplicable(Class[] p1, Class[] p2) {
        int i = 0;
        while (i < p1.length) {
            if (!p2[i].isAssignableFrom(p1[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Method findMethod(String name, Object target, Pair types) {
        try {
            return U.toClass(target).getMethod(name, Invoke.toClassArray(types, 0));
        }
        catch (NoSuchMethodException e) {
            return (Method)E.error("No method: ", U.list(name, target, types));
        }
    }

    public static Constructor findConstructor(Object target, Pair types) {
        try {
            return U.toClass(target).getConstructor(Invoke.toClassArray(types, 0));
        }
        catch (NoSuchMethodException e) {
            return (Constructor)E.error("No constructor: ", U.list(target, types));
        }
    }

    public static Class[] toClassArray(Pair types, int n) {
        if (types == Pair.EMPTY) {
            return new Class[n];
        }
        Class[] cs = Invoke.toClassArray((Pair)types.rest, n + 1);
        cs[n] = U.toClass(types.first);
        return cs;
    }

    public static Method[] getMethods(Class c) {
        return Invoke.getMethods(c, false);
    }

    public static Method[] getMethods(Class c, boolean canAccessPrivateData) {
        Method[] methods = Invoke.getAllMethods(c, canAccessPrivateData);
        return methods == null ? c.getMethods() : methods;
    }

    private static Method[] getAllMethods(Class c) {
        return Invoke.getAllMethods(c, false);
    }

    private static Method[] getAllMethods(Class c, boolean canAccessPrivateData) {
        if (canAccessPrivateData) {
            try {
                return (Method[])Invoke.makeAccessible(Invoke.getAllMethods0(c));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static boolean canGetDeclaredMethods() {
        try {
            (class$jsint$Invoke == null ? (class$jsint$Invoke = Invoke.class$("jsint.Invoke")) : class$jsint$Invoke).getDeclaredMethods();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Method[] getAllMethods0(Class c) {
        if (CAN_GET_DECLARED_METHODS) {
            Hashtable table = new Hashtable(35);
            Invoke.collectDeclaredMethods(c, table);
            Enumeration e = table.elements();
            Method[] ms = new Method[table.size()];
            int i = 0;
            while (e.hasMoreElements()) {
                ms[i] = (Method)e.nextElement();
                ++i;
            }
            return ms;
        }
        return null;
    }

    public static void collectDeclaredMethods(Class c, Hashtable h) {
        Method[] ms = c.getDeclaredMethods();
        int i = 0;
        while (i < ms.length) {
            h.put(ms[i], ms[i]);
            ++i;
        }
        Class<?>[] is = c.getInterfaces();
        int j = 0;
        while (j < is.length) {
            Invoke.collectDeclaredMethods(is[j], h);
            ++j;
        }
        Class sup = c.getSuperclass();
        if (sup != null) {
            Invoke.collectDeclaredMethods(sup, h);
        }
    }

    private static Method getSetAccessibleMethod() {
        try {
            Class<?> c = Class.forName("java.lang.reflect.AccessibleObject");
            Class<?> ca = Class.forName("[Ljava.lang.reflect.AccessibleObject;");
            return c.getMethod("setAccessible", ca, Boolean.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static Object[] makeAccessible(Object[] items) {
        if (items != null && SETACCESSIBLE != null) {
            try {
                SETACCESSIBLE.invoke(null, items, new Boolean(true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return items;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

