/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Enumeration;
import jsint.E;
import jsint.Pair;
import jsint.Queue;
import jsint.Symbol;
import jsint.U;

public class InputPort
implements Enumeration {
    public static final Object EOF = InputPort.token("!eof");
    public static boolean defaultBrlsMode = true;
    public boolean brlsMode = defaultBrlsMode;
    private static final Object BACKQUOTE = InputPort.token("`");
    private static final Object CLOSE = InputPort.token(")");
    private static final Object COMMA = InputPort.token(",");
    private static final Object COMMA_AT = InputPort.token(",@");
    private static final Object DOT = InputPort.token(".");
    private static final Object OPEN = InputPort.token("(");
    private static final Object QUOTE = InputPort.token("'");
    private static final Symbol CHAR_s = Symbol.intern("s");
    private static final Symbol CHAR_S = Symbol.intern("S");
    private static final Symbol CHAR_n = Symbol.intern("n");
    private static final Symbol CHAR_N = Symbol.intern("N");
    private static final Symbol NEWLINE_UC = Symbol.intern("NEWLINE");
    private static final Symbol NEWLINE_LC = Symbol.intern("newline");
    private static final Symbol SPACE_UC = Symbol.intern("SPACE");
    private static final Symbol SPACE_LC = Symbol.intern("space");
    private static final Symbol CURLY = Symbol.intern("string-append");
    boolean isPushedChar = false;
    int pushedChar = -1;
    int radix = 10;
    LineNumberReader in;
    StringBuffer buff = new StringBuffer(8);
    private Pair pushedTokens = Pair.EMPTY;
    private char closeStringChar = (char)34;

    private static Object token(String x) {
        return new Token(x);
    }

    public InputPort(InputStream in) {
        this.in = new LineNumberReader(new InputStreamReader(in));
    }

    public InputPort(Reader in) {
        this.in = in instanceof LineNumberReader ? (LineNumberReader)in : new LineNumberReader(in);
    }

    public synchronized Object readChar() {
        try {
            if (this.isPushedChar) {
                this.isPushedChar = false;
                if (this.pushedChar == -1) {
                    return EOF;
                }
                return U.toChar((char)this.pushedChar);
            }
            int ch = this.in.read();
            if (ch == -1) {
                return EOF;
            }
            return U.toChar((char)ch);
        }
        catch (IOException e) {
            E.warn("On input, exception: " + e);
            return EOF;
        }
    }

    public synchronized Object peekChar() {
        int p = this.peekCh();
        if (p == -1) {
            return EOF;
        }
        return U.toChar((char)p);
    }

    private boolean isPushedToken() {
        return this.pushedTokens != Pair.EMPTY;
    }

    private Object pushToken(Object token) {
        this.pushedTokens = new Pair(token, this.pushedTokens);
        return token;
    }

    private Object popToken() {
        Object token = this.pushedTokens.first;
        this.pushedTokens = (Pair)this.pushedTokens.rest;
        return token;
    }

    private int pushChar(int ch) {
        this.isPushedChar = true;
        this.pushedChar = ch;
        return this.pushedChar;
    }

    private int popChar() {
        this.isPushedChar = false;
        return this.pushedChar;
    }

    private int peekCh() {
        try {
            return this.isPushedChar ? this.pushedChar : this.pushChar(this.in.read());
        }
        catch (IOException e) {
            E.warn("On input, exception: " + e);
            return -1;
        }
    }

    public int getLineNumber() {
        return this.in.getLineNumber();
    }

    public Object nextElement() {
        return this.read();
    }

    public boolean hasMoreElements() {
        try {
            Object token = this.readToken();
            this.pushToken(token);
            return token != EOF;
        }
        catch (IOException e) {
            E.warn("On input, exception: " + e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Object read() {
        try {
            void e;
            Object token = this.readToken();
            if (token instanceof Symbol) {
                return token;
            }
            if (token instanceof Token) {
                if (token == OPEN) {
                    return this.readList();
                }
                if (token == QUOTE) {
                    return U.list(Symbol.QUOTE, this.read());
                }
                if (token == COMMA) {
                    return U.list(Symbol.UNQUOTE, this.read());
                }
                if (token == BACKQUOTE) {
                    return U.list(Symbol.QUASIQUOTE, this.read());
                }
                if (token == COMMA_AT) {
                    return U.list(Symbol.UNQUOTE_SPLICING, this.read());
                }
                if (token == CLOSE) {
                    E.warn("Extra ) ignored -- line number " + this.in.getLineNumber());
                    return this.read();
                }
                if (token == DOT) {
                    E.warn("Extra . ignored -- line number " + this.in.getLineNumber());
                    return this.read();
                }
                return token;
            }
            return e;
        }
        catch (IOException e) {
            E.warn("On input, exception: " + e);
            return EOF;
        }
    }

    public Object close() {
        try {
            this.in.close();
            return U.TRUE;
        }
        catch (IOException e) {
            return E.error("IOException: " + e);
        }
    }

    private Object readList() throws IOException {
        Object token = this.readToken();
        if (token instanceof Token) {
            return this.readListToken((Token)token);
        }
        return this.readListRest(new Queue(token));
    }

    private Object readListToken(Token token) throws IOException {
        if (token == CLOSE) {
            return Pair.EMPTY;
        }
        if (token == DOT) {
            return E.error("'.' not allowed immediately after '('");
        }
        if (token == EOF) {
            return E.error("EOF during read.");
        }
        this.pushToken(token);
        return this.readListRest(new Queue(this.read()));
    }

    private Object readListRest(Queue queue) throws IOException {
        while (true) {
            Object token;
            if ((token = this.readToken()) instanceof Token) {
                if (token == CLOSE) {
                    return queue.getContent();
                }
                if (token == DOT) {
                    Object result = this.read();
                    token = this.readToken();
                    if (token != CLOSE) {
                        return E.error("Where's the ')'? Got " + token + " after .");
                    }
                    queue.getLast().rest = result;
                    return queue.getContent();
                }
                if (token == EOF) {
                    return E.error("EOF during read.");
                }
                this.pushToken(token);
                queue.add(this.read());
                continue;
            }
            queue.add(token);
        }
    }

    private Object readToken() throws IOException {
        Object token = this.readToken2();
        return token;
    }

    private Object readToken2() throws IOException {
        if (this.isPushedToken()) {
            return this.popToken();
        }
        int ch = this.isPushedChar ? this.popChar() : this.in.read();
        while (Character.isWhitespace((char)ch)) {
            ch = this.in.read();
        }
        switch (ch) {
            case 40: {
                return OPEN;
            }
            case 41: {
                return CLOSE;
            }
            case 39: {
                return QUOTE;
            }
            case 96: {
                return BACKQUOTE;
            }
            case 35: {
                return this.readHashToken();
            }
            case 34: {
                return this.readString();
            }
            case 44: {
                ch = this.in.read();
                if (ch == 64) {
                    return COMMA_AT;
                }
                this.pushChar(ch);
                return COMMA;
            }
            case 59: {
                while (ch != -1 && ch != 10 && ch != 13) {
                    ch = this.in.read();
                }
                return this.readToken();
            }
            case -1: {
                return EOF;
            }
            case 123: {
                if (this.brlsMode) {
                    this.pushToken(CURLY);
                    this.closeStringChar = (char)125;
                    this.isPushedChar = true;
                    this.pushedChar = 34;
                    return OPEN;
                }
            }
            case 93: {
                if (!this.brlsMode) break;
                this.closeStringChar = (char)125;
                return this.readString();
            }
        }
        return this.readNumberOrSymbol(ch);
    }

    private String readString() {
        int ch = 0;
        this.buff.setLength(0);
        try {
            while ((ch = this.in.read()) != this.closeStringChar && (this.closeStringChar != '}' || ch != 91) && ch != -1) {
                this.buff.append(ch == 92 ? (U.useJavaSyntax ? this.escapechar(this.in.read()) : (char)this.in.read()) : (char)ch);
            }
            if (ch == -1) {
                E.warn("EOF inside of a string.");
            }
            if (this.closeStringChar == '}' && ch == 125) {
                this.closeStringChar = (char)34;
                this.pushToken(CLOSE);
            }
            if (this.closeStringChar == '}' && ch == 91) {
                this.closeStringChar = (char)34;
            }
            return this.internStringBuffer(this.buff);
        }
        catch (IOException e) {
            E.warn("IOException", this.in);
            return "";
        }
    }

    private String internStringBuffer(StringBuffer b) {
        return b.toString().intern();
    }

    private String moveBufToString(StringBuffer b) {
        int L = b.length();
        char[] chars = new char[L];
        if (L > 0) {
            b.getChars(0, L, chars, 0);
            b.setLength(0);
        }
        return new String(chars);
    }

    private boolean maybeNumber(int c, String buff) {
        return c >= 48 && c <= 57 || (c == 46 || c == 43 || c == 45) && buff.length() > 1;
    }

    private Object readNumberOrSymbol(int ch) throws IOException {
        Object it;
        this.buff.setLength(0);
        int c = ch;
        do {
            this.buff.append((char)ch);
            ch = this.in.read();
            if (ch != 91) continue;
            this.buff.append((char)ch);
            ch = this.in.read();
            if (ch != 93) continue;
            this.buff.append((char)ch);
            ch = this.in.read();
        } while (!this.isDelimiter(ch) && (!this.brlsMode || this.closeStringChar != '\"' || ch != 93));
        this.pushChar(ch);
        if (c == 46 && this.buff.length() == 1) {
            return DOT;
        }
        String tok = this.moveBufToString(this.buff);
        if (this.maybeNumber(c, tok) && (it = InputPort.stringToNumber(tok, this.radix)) instanceof Number) {
            return it;
        }
        return Symbol.intern(tok);
    }

    public static Object stringToNumber(String tok, int rdx) {
        if (rdx == 10) {
            if (U.useJavaSyntax) {
                try {
                    return InputPort.readWholeNumber(tok);
                }
                catch (NumberFormatException e1) {
                    try {
                        return InputPort.readFloatingPoint(tok);
                    }
                    catch (NumberFormatException e3) {
                        return U.FALSE;
                    }
                }
            }
            try {
                return U.toNum(Long.parseLong(tok, rdx));
            }
            catch (NumberFormatException e) {
                try {
                    return new Double(tok);
                }
                catch (NumberFormatException e2) {
                    return U.FALSE;
                }
            }
        }
        return U.toNum(Long.parseLong(U.stringify(tok, false), rdx));
    }

    public static Number readWholeNumber(String s) throws NumberFormatException {
        if (s.endsWith("l") || s.endsWith("L")) {
            return new Long(InputPort.readWholeNumber(s.substring(0, s.length() - 1)).longValue());
        }
        if (s.startsWith("+") && s.length() > 1) {
            return InputPort.readWholeNumber(s.substring(1, s.length()));
        }
        if (s.startsWith("-") && s.length() > 1) {
            return InputPort.negate(InputPort.readWholeNumber(s.substring(1, s.length())));
        }
        long n = s.startsWith("0x") ? Long.parseLong(s.substring(2, s.length()), 16) : (s.startsWith("0") && s.length() > 1 ? Long.parseLong(s.substring(1, s.length()), 8) : Long.parseLong(s, 10));
        if (Integer.MIN_VALUE <= n && n <= Integer.MAX_VALUE) {
            return new Integer((int)n);
        }
        return new Long(n);
    }

    public static Number negate(Number n) {
        if (n instanceof Integer) {
            return new Integer(-n.intValue());
        }
        if (n instanceof Long) {
            return new Long(-n.longValue());
        }
        if (n instanceof Float) {
            return new Float(-n.floatValue());
        }
        if (n instanceof Double) {
            return new Double(-n.doubleValue());
        }
        E.warn("ERROR in Inputport.negate called with " + n.getClass() + " returning " + n);
        return n;
    }

    public static Number readFloatingPoint(String s) throws NumberFormatException {
        if (s.endsWith("f") || s.endsWith("F")) {
            return new Float(InputPort.readFloatingPoint(s.substring(0, s.length() - 1)).floatValue());
        }
        if (s.endsWith("d") || s.endsWith("D")) {
            return new Double(InputPort.readFloatingPoint(s.substring(0, s.length() - 1)).doubleValue());
        }
        if (s.startsWith("+") && s.length() > 1) {
            return InputPort.readFloatingPoint(s.substring(1, s.length()));
        }
        if (s.startsWith("-") && s.length() > 1) {
            return InputPort.negate(InputPort.readFloatingPoint(s.substring(1, s.length())));
        }
        return new Double(s);
    }

    private Object readHashToken() throws IOException {
        Object token = null;
        int ch = this.in.read();
        switch (ch) {
            case 84: 
            case 116: {
                return U.TRUE;
            }
            case 70: 
            case 102: {
                return U.FALSE;
            }
            case 110: {
                this.pushChar(ch);
                token = this.readToken();
                if (token == Symbol.NULL) {
                    return null;
                }
                E.warn("illegal syntax #" + token + " ignored");
                return this.readToken();
            }
            case 40: {
                this.pushChar(40);
                return U.listToVector(this.read());
            }
            case 92: {
                ch = this.in.read();
                if (ch == 115 || ch == 83 || ch == 110 || ch == 78) {
                    this.pushChar(ch);
                    token = this.readToken();
                    if (token == SPACE_UC || token == SPACE_LC) {
                        return U.toChar(' ');
                    }
                    if (token == NEWLINE_UC || token == NEWLINE_LC) {
                        return U.toChar('\n');
                    }
                    if (token == CHAR_s) {
                        return U.toChar('s');
                    }
                    if (token == CHAR_S) {
                        return U.toChar('S');
                    }
                    if (token == CHAR_n) {
                        return U.toChar('n');
                    }
                    if (token == CHAR_N) {
                        return U.toChar('N');
                    }
                    E.warn("illegal syntax #" + token + " ignored");
                    return this.readToken();
                }
                return U.toChar((char)ch);
            }
            case 39: {
                if (!U.useJavaSyntax) break;
                ch = this.in.read();
                Character x = ch != 92 ? new Character((char)ch) : new Character(this.escapechar(this.in.read()));
                ch = this.in.read();
                if (ch != 39) {
                    E.warn("character syntax is #'C', or #\\C, not #'C" + (char)ch);
                }
                return x;
            }
        }
        if (U.useJavaSyntax) {
            E.warn("#" + (char)ch + " not recognized, ignored.");
            return this.readToken();
        }
        switch (ch) {
            case 101: {
                return U.toNum(U.toInt(this.readToken()));
            }
            case 105: {
                return U.toNum(U.toReal(this.readToken()));
            }
            case 100: {
                return this.readToken();
            }
            case 98: 
            case 111: 
            case 120: {
                InputPort inputPort = this;
                synchronized (inputPort) {
                    this.radix = ch == 98 ? 2 : (ch == 111 ? 8 : 16);
                    token = this.readToken();
                    this.radix = 10;
                    Object object = token;
                    return object;
                }
            }
        }
        E.warn("#" + (char)ch + " not recognized, ignored.");
        return this.readToken();
    }

    private char escapechar(int c) throws IOException {
        switch (c) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: {
                return '\"';
            }
            case 39: {
                return '\'';
            }
            case 92: {
                return '\\';
            }
            case 48: {
                return new Character((char)Integer.parseInt("" + (char)this.in.read() + (char)this.in.read(), 8)).charValue();
            }
            case 117: {
                return new Character((char)Integer.parseInt("" + (char)this.in.read() + (char)this.in.read() + (char)this.in.read() + (char)this.in.read(), 16)).charValue();
            }
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return (char)c;
            }
        }
        E.warn("Expected a Java escape sequence for a character, found " + (char)c + " with ascii code " + c);
        return (char)c;
    }

    private boolean isDelimiter(int ch) {
        switch (ch) {
            case -1: 
            case 9: 
            case 10: 
            case 32: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 59: 
            case 96: {
                return true;
            }
        }
        return Character.isWhitespace((char)ch);
    }

    private static class Token {
        String name;

        Token(String name) {
            this.name = name;
        }

        public String toString() {
            return "#" + this.name + "#";
        }
    }
}

