/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.ui;

import com.sun.java.swing.action.ApplyAction;
import com.sun.java.swing.action.CancelAction;
import com.sun.java.swing.action.DelegateAction;
import com.sun.java.swing.action.OkAction;
import com.sun.java.swing.ui.CommonUI;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;

public class TabsDlg
extends JDialog {
    private JTabbedPane tabsPanel;
    private DelegateAction okAction;
    private DelegateAction cancelAction;
    private DelegateAction applyAction;
    private ActionListener okListener = null;
    private ActionListener cancelListener = null;
    private ActionListener applyListener = null;
    private static TabsDlg tabsDlg;

    public TabsDlg(String title, Vector panels) {
        super(new JFrame(), title, true);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.tabsPanel = new JTabbedPane();
        int numPanels = panels.size();
        int i = 0;
        while (i < numPanels) {
            JPanel panel = (JPanel)panels.elementAt(i);
            this.tabsPanel.addTab(panel.getName(), panel);
            ++i;
        }
        pane.add((Component)this.tabsPanel, "Center");
        pane.add((Component)this.createButtonPanel(), "South");
        this.pack();
        CommonUI.centerComponent(this);
    }

    public static void main(String[] args) {
        JPanel p1 = new JPanel();
        p1.add(new JButton("One"));
        p1.setName("One");
        JPanel p2 = new JPanel();
        p2.add(new JButton("Two"));
        p2.setName("Two");
        JPanel p3 = new JPanel();
        p3.add(new JButton("Three"));
        p3.setName("Three");
        JPanel p4 = new JPanel();
        p4.add(new JButton("Four"));
        p4.setName("Four");
        Vector<JPanel> panels = new Vector<JPanel>();
        panels.addElement(p1);
        panels.addElement(p2);
        panels.addElement(p3);
        panels.addElement(p4);
        tabsDlg = new TabsDlg("Test Dialog", panels);
        tabsDlg.addOkListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        tabsDlg.addCancelListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        tabsDlg.setVisible(true);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        this.okAction = new OkAction();
        this.cancelAction = new CancelAction();
        this.applyAction = new ApplyAction();
        this.okAction.addActionListener(new OkListener());
        this.cancelAction.addActionListener(new CancelListener());
        this.applyAction.addActionListener(new ApplyListener());
        panel.add(CommonUI.createButton(this.okAction));
        panel.add(CommonUI.createButton(this.cancelAction));
        panel.add(CommonUI.createButton(this.applyAction));
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)panel, "Center");
        p2.add((Component)new JSeparator(), "North");
        return p2;
    }

    public void enableApplyButton(boolean enabled) {
        this.applyAction.setEnabled(enabled);
    }

    public synchronized void addOkListener(ActionListener l) {
        this.okListener = AWTEventMulticaster.add(this.okListener, l);
    }

    public synchronized void removeOkListener(ActionListener l) {
        this.okListener = AWTEventMulticaster.remove(this.okListener, l);
    }

    public synchronized void addCancelListener(ActionListener l) {
        this.cancelListener = AWTEventMulticaster.add(this.cancelListener, l);
    }

    public synchronized void removeCancelListener(ActionListener l) {
        this.cancelListener = AWTEventMulticaster.remove(this.cancelListener, l);
    }

    public synchronized void addApplyListener(ActionListener l) {
        this.applyListener = AWTEventMulticaster.add(this.applyListener, l);
    }

    public synchronized void removeApplyListener(ActionListener l) {
        this.applyListener = AWTEventMulticaster.remove(this.applyListener, l);
    }

    private class ApplyListener
    implements ActionListener {
        private ApplyListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (TabsDlg.this.applyListener != null) {
                TabsDlg.this.applyListener.actionPerformed(evt);
                TabsDlg.this.enableApplyButton(false);
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (TabsDlg.this.cancelListener != null) {
                TabsDlg.this.cancelListener.actionPerformed(evt);
            }
            TabsDlg.this.setVisible(false);
        }
    }

    private class OkListener
    implements ActionListener {
        private OkListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (TabsDlg.this.okListener != null) {
                TabsDlg.this.okListener.actionPerformed(evt);
            }
            TabsDlg.this.setVisible(false);
        }
    }
}

