/*
 * Copyright 2006 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package com.sun.tools.internal.xjc;

import java.io.PrintStream;

import com.sun.tools.internal.xjc.api.ErrorListener;
import com.sun.tools.internal.xjc.outline.Outline;

/**
 * Call-back interface that can be implemented by the caller of {@link Driver}
 * to receive output from XJC.
 *
 * <p>
 * Most of the messages XJC produce once the real work starts is structured
 * as (message,source). Those outputs will be reported to various methods on
 * {@link ErrorListener}, which is inherited by this interface.
 *
 * <p>
 * The other messages (such as the usage screen when there was an error in
 * the command line option) will go to the {@link #message(String)} method.
 *
 * @author Kohsuke Kawaguchi
 * @since JAXB 2.0 EA
 */
public abstract class XJCListener implements ErrorListener {

    /**
     * @deprecated
     *      Override {@link #generatedFile(String, int, int)}.
     *      Deprecated in 2.0.1.
     */
    public void generatedFile(String fileName) {}

    /**
     * Called for each file generated by XJC.
     *
     * <p>
     * XJC may generate not only source files but also resources files.
     * The file name includes the path portions that correspond with the package name.
     *
     * <p>
     * When generating files into a directory, file names will be relative to the
     * output directory. When generating files into a zip file, file names will be
     * those in the zip file.
     *
     * @param fileName
     *      file names like "org/acme/foo/Foo.java" or "org/acme/foo/jaxb.properties".
     *
     * @since 2.0.1
     */
    public void generatedFile(String fileName, int current, int total ) {
        generatedFile(fileName);    // backward compatibility
    }

    /**
     * Other miscellenous messages that do not have structures
     * will be reported through this method.
     *
     * This method is used like {@link PrintStream#println(String)}.
     * The callee is expected to add '\n'.
     */
    public void message(String msg) {}

    /**
     * Called after the schema is compiled and the code generation strategy is determined,
     * but before any code is actually generated as files.
     *
     * @param outline
     *      never null. this is the root object that represents the code generation strategy.
     */
    public void compiled(Outline outline) {}
}
