(define (comparator compare access)
  (elf.SchemeComparator.
   (lambda (a b)
     (let ((a (access a))
	   (b (access b)))
       (if (compare a b) -1
	   (if (compare b a) 1
	       0))))))

(define-method (sort (xs jsint.Pair) comparator)
  (let ((it (list->vector xs)))
    (sort it comparator)
    (vector->list it)))

(define-method (sort (xs Object[]) comparator)
  (Arrays.sort xs comparator))

(define (by n xs)
  (define (by0 i xs items so-far)
    (if (= i 0) (by0 n xs '() (cons (reverse items) so-far))
	(if (null? xs) (finish items so-far)
	    (by0 (- i 1) (cdr xs) (cons (car xs) items) so-far))))
  (define (finish items so-far)
    (reverse
     (if (null? items) so-far
	 (cons (reverse items) so-far))))
  (assert (> n 0))
  (by0 n xs '() '()))

(assert (equal? (by 2 '(1 a 2 b 3 c)) '((1 a) (2 b) (3 c))))

(define (group-by what xs)
  (let ((table (java.util.Hashtable.)))
    (iterate xs
	     (lambda (x)
	       (let* ((key (what x))
		      (items (.get table key)))
		 (.put table key (cons x (if (eq? items #null) '() items))))))
    (.values table)))

(define (unique p)
  (lambda (xs) (p (call/cc (lambda (return)
			     (iterate xs (lambda (x) (return x))))))))

(define (project . ps) (lambda (x) (map (lambda (p) (p x)) ps)))

(define (count xs)
  (let ((c 0))
    (iterate xs (lambda (x) (set! c (+ c 1))))
    c))