;;; Jscheme specific code for compiling the compiler and the JLIB
(let* ((bin (find-javac-bin))
       (javac (list (File. bin "javac") "-classpath" "."))
       (java  (list (File. bin "java")  "-classpath" "."))
       (jar (File. bin "jar")))
					; load the compiler
  (load "jsint/compiler/Reflect.scm")
  (load "jsint/compiler/CompileReflection.scm")

					; compile utility procedures
  (run javac "jsint/Function.java" "jsint/LCO.java")
  (load "jsint/compiler/Compiler.scm")	; Needs jsint.Function.
  (compile-file "jsint/compiler/Reflect.scm" "jsint.compiler")
  (compile-file "jsint/compiler/CompileReflection.scm" "jsint.compiler")
  (run javac "jsint/compiler/Reflect.java")
  (run javac "jsint/compiler/CompileReflection.java")

					; compile the compiler
  (compile-file "jsint/compiler/Compiler.scm" "jsint.compiler")
  (run javac "jsint/compiler/Compiler.java")

					; compile the toplevel interface to compiler
  (compile-file "jsint/Compile.scm" "jsint")
  (run javac "jsint/Compile.java")

					; compile JLIB: the high level GUI building library
  (run javac "jsint/Listener.java" "jsint/SchemeApplet.java" "jlib/SchemeCanvas.java")
  (compile-file "jlib/JLIB.scm" "jlib")
  (run javac "jlib/JLIB.java")
  (compile-file "jlib/Swing.scm" "jlib")
  (run javac "jlib/Swing.java")
  (compile-file "jlib/Networking.scm" "jlib")
  (run javac "jlib/Networking.java")
  )


