/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import jsint.Continuation;
import jsint.E;
import jsint.Import;
import jsint.InputPort;
import jsint.Pair;
import jsint.Procedure;
import jsint.Queue;
import jsint.Scheme;
import jsint.Symbol;

public abstract class U {
    public static boolean useJavaSyntax = true;
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    public static final Symbol UNDEFINED = Symbol.intern("#!undefined");
    public static final Symbol MISSING = Symbol.intern("#!missing");
    public static final Object[] NO_ARGS = new Object[0];
    public static final Object[] EMPTY_ARGS = new Object[]{Pair.EMPTY};
    private static final int NUM_CACHED = 128;
    private static final Character[] cachedCharacters = new Character[128];
    private static final Integer[] cachedPosInts = new Integer[128];
    private static final Integer[] cachedNegInts = new Integer[128];
    public static final Double ZERO = new Double(0.0);
    public static final Double ONE = new Double(1.0);

    public static boolean to_bool(Object x) {
        return !FALSE.equals(x);
    }

    public static Boolean toBool(boolean x) {
        return x ? TRUE : FALSE;
    }

    public static Boolean toBool(Object x) {
        return FALSE.equals(x) ? FALSE : TRUE;
    }

    public static char to_char(Object x) {
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        return U.to_char(E.typeError("char", x));
    }

    public static char to_lc_char(Object x) {
        if (x instanceof Character) {
            return Character.toLowerCase(((Character)x).charValue());
        }
        return U.to_lc_char(E.typeError("char", x));
    }

    public static Character toChar(char ch) {
        if (ch < '\u0080') {
            Character c = cachedCharacters[ch];
            return c != null ? c : new Character(ch);
        }
        return new Character(ch);
    }

    public static Class toClass(Object c) {
        if (c instanceof Class) {
            return (Class)c;
        }
        return Import.classNamed(U.stringify(c, false));
    }

    public static Class maybeToClass(Object c) {
        if (c instanceof Class) {
            return (Class)c;
        }
        return Import.maybeClassNamed(U.stringify(c, false));
    }

    public static Integer toNum(int i) {
        if (i <= -128 || i >= 128) {
            return new Integer(i);
        }
        if (i >= 0 && i < 128) {
            Integer in = cachedPosInts[i];
            return in != null ? in : new Integer(i);
        }
        if (i < 0 && i > -128) {
            Integer in = cachedNegInts[-i];
            return in != null ? in : (U.cachedNegInts[-i] = new Integer(i));
        }
        return new Integer(i);
    }

    public static Number toNum(long i) {
        if (i <= Integer.MAX_VALUE && i >= Integer.MIN_VALUE) {
            return U.toNum((int)i);
        }
        return new Long(i);
    }

    public static Double toNum(double x) {
        return x == 0.0 ? ZERO : (x == 1.0 ? ONE : new Double(x));
    }

    public static double toReal(Object x) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        return U.toReal(E.typeError("real number", x));
    }

    public static int toInt(Object x) {
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        return U.toInt(E.typeError("integer", x));
    }

    public static int toInt(Object x, int defaultVal) {
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        return defaultVal;
    }

    public static String toStr(Object x) {
        return x instanceof String ? (String)x : U.toStr(E.typeError("string", x));
    }

    public static Symbol toSym(Object x) {
        if (x instanceof Symbol) {
            return (Symbol)x;
        }
        return U.toSym(E.typeError("symbol", x));
    }

    public static Procedure toProc(Object x) {
        if (x instanceof Procedure) {
            return (Procedure)x;
        }
        return U.toProc(E.typeError("procedure", x));
    }

    public static boolean isPair(Object x) {
        return x instanceof Pair && x != Pair.EMPTY;
    }

    public static Pair toPair(Object x) {
        if (x != Pair.EMPTY && x instanceof Pair) {
            return (Pair)x;
        }
        return U.toPair(E.typeError("pair(i.e. non-empty list)", x));
    }

    public static Pair toList(Object x) {
        if (x instanceof Pair) {
            return (Pair)x;
        }
        return U.toPair(E.typeError("list (i.e. pair or empty)", x));
    }

    public static InputPort toInPort(Object x) {
        if (x == MISSING) {
            return Scheme.input;
        }
        if (x instanceof InputPort) {
            return (InputPort)x;
        }
        return U.toInPort(E.typeError("input port", x));
    }

    public static PrintWriter toOutPort(Object x) {
        if (x == MISSING) {
            return Scheme.output;
        }
        if (x instanceof PrintWriter) {
            return (PrintWriter)x;
        }
        return U.toOutPort(E.typeError("output port", x));
    }

    public static Object first(Object x) {
        return U.toPair((Object)x).first;
    }

    public static Object rest(Object x) {
        return U.toPair((Object)x).rest;
    }

    public static Object second(Object x) {
        return U.toPair(x).second();
    }

    public static Pair list(Object a, Object b, Object c) {
        return new Pair(a, new Pair(b, new Pair(c, Pair.EMPTY)));
    }

    public static Pair list(Object a, Object b) {
        return new Pair(a, new Pair(b, Pair.EMPTY));
    }

    public static Pair list(Object a) {
        return new Pair(a, Pair.EMPTY);
    }

    public static boolean equal(Object x, Object y) {
        if (x == null || y == null) {
            return x == y;
        }
        if (x == Pair.EMPTY || y == Pair.EMPTY) {
            return x == y;
        }
        if (x instanceof Object[]) {
            if (!(y instanceof Object[])) {
                return false;
            }
            Object[] xo = (Object[])x;
            Object[] yo = (Object[])y;
            if (xo.length != yo.length) {
                return false;
            }
            int i = xo.length - 1;
            while (i >= 0) {
                if (!U.equal(xo[i], yo[i])) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return U.eqv(x, y) || x.equals(y);
    }

    public static boolean eqv(Object x, Object y) {
        return x == y || x instanceof Number && y instanceof Number && (x instanceof Integer || x instanceof Long || x instanceof Short || x instanceof Byte) && ((Number)x).longValue() == ((Number)y).longValue() || (x instanceof Float || x instanceof Double) && ((Number)x).doubleValue() == ((Number)y).doubleValue() || x instanceof Character && x.equals(y) || x instanceof Boolean && x.equals(y);
    }

    public static Object write(Object x, PrintWriter port, boolean quoted) {
        port.print(U.stringify(x, quoted));
        port.flush();
        return x;
    }

    public static boolean checkNargs(int min, int max, int given, Object form) {
        if (given >= min && given <= max) {
            return true;
        }
        E.warn("expected " + min + (min == max ? "" : (max == Integer.MAX_VALUE ? " or more" : " to " + max)) + " arguments, but got " + given, form);
        return false;
    }

    public static StringBuffer stringify(Object x, boolean quoted, StringBuffer buf) {
        if (x == Pair.EMPTY) {
            buf.append("()");
        } else if (x == null) {
            buf.append("#null");
        } else if (x instanceof Boolean) {
            if (Boolean.TRUE.equals(x)) {
                buf.append("#t");
            } else {
                buf.append("#f");
            }
        } else if (x == TRUE) {
            buf.append("#t");
        } else if (x == FALSE) {
            buf.append("#f");
        } else if (x instanceof Pair) {
            ((Pair)x).stringifyPair(quoted, buf);
        } else if (x instanceof Character) {
            char ch = ((Character)x).charValue();
            if (ch == '\'') {
                buf.append(quoted ? (useJavaSyntax ? "#'\\''" : "#\\'") : "'");
            } else if (useJavaSyntax) {
                if (quoted) {
                    buf.append("#'");
                }
                U.stringifyChar(buf, ch, quoted);
                if (quoted) {
                    buf.append("'");
                }
            } else {
                if (quoted) {
                    buf.append("#\\");
                }
                if (quoted && (ch == ' ' || ch == '\n')) {
                    buf.append(ch == ' ' ? "space" : "newline");
                } else {
                    buf.append(ch);
                }
            }
        } else if (x instanceof String) {
            String s = (String)x;
            if (quoted) {
                buf.append('\"');
            }
            if (useJavaSyntax) {
                int i = 0;
                while (i < s.length()) {
                    U.stringifyChar(buf, s.charAt(i), quoted);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < s.length()) {
                    if (quoted && (s.charAt(i) == '\"' || s.charAt(i) == '\\')) {
                        buf.append('\\');
                    }
                    buf.append(s.charAt(i));
                    ++i;
                }
            }
            if (quoted) {
                buf.append('\"');
            }
        } else if (x instanceof Object[]) {
            Object[] v = (Object[])x;
            buf.append("#(");
            int i = 0;
            while (i < v.length) {
                U.stringify(v[i], quoted, buf);
                if (i != v.length - 1) {
                    buf.append(' ');
                }
                ++i;
            }
            buf.append(')');
        } else {
            buf.append(x);
        }
        return buf;
    }

    private static void stringifyChar(StringBuffer buf, char ch, boolean quoted) {
        switch (ch) {
            case '\b': {
                buf.append(quoted ? "\\b" : "\b");
                break;
            }
            case '\t': {
                buf.append(quoted ? "\\t" : "\t");
                break;
            }
            case '\n': {
                buf.append(quoted ? "\\n" : "\n");
                break;
            }
            case '\f': {
                buf.append(quoted ? "\\f" : "\f");
                break;
            }
            case '\r': {
                buf.append(quoted ? "\\r" : "\r");
                break;
            }
            case '\"': {
                buf.append(quoted ? "\\\"" : "\"");
                break;
            }
            case '\\': {
                buf.append(quoted ? "\\\\" : "\\");
                break;
            }
            default: {
                buf.append(ch);
            }
        }
    }

    public static String stringify(Object x) {
        return U.stringify(x, true);
    }

    public static String stringify(Object x, boolean quoted) {
        if (x instanceof String && !quoted) {
            return (String)x;
        }
        if (x instanceof Symbol) {
            return ((Symbol)x).toString();
        }
        return U.stringify(x, quoted, new StringBuffer()).toString();
    }

    public static String makeString(int size, Object fill) {
        char[] chars = new char[size];
        if (fill != MISSING) {
            char ch = U.to_char(fill);
            int i = 0;
            while (i < size) {
                chars[i] = ch;
                ++i;
            }
        }
        return new String(chars);
    }

    public static String stringAppend(Pair args) {
        if (args == Pair.EMPTY) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        while (args != Pair.EMPTY) {
            result.append(U.stringify(args.first, false));
            args = U.toList(args.rest);
        }
        return result.toString();
    }

    public static Object memberAssoc(Object obj, Object list, boolean member, int eq) {
        boolean found = false;
        while (U.isPair(list)) {
            Object target = member ? U.first(list) : U.first(U.first(list));
            switch (eq) {
                case 1: {
                    found = target == obj;
                    break;
                }
                case 2: {
                    found = U.eqv(target, obj);
                    break;
                }
                case 3: {
                    found = U.equal(target, obj);
                    break;
                }
                default: {
                    E.warn("Bad option to memberAssoc:" + eq);
                    return FALSE;
                }
            }
            if (found) {
                return member ? list : U.first(list);
            }
            list = U.rest(list);
        }
        return FALSE;
    }

    public static Object numCompute(Object x, Pair args, char op) {
        return x instanceof Integer ? U.numCompute(U.toInt(x), args, op) : U.numCompute(U.toReal(x), args, op);
    }

    public static Object numCompute(long result, Pair args, char op) {
        while (U.isPair(args)) {
            if (!(args.first instanceof Integer)) {
                return U.numCompute((double)result, args, op);
            }
            long y = U.toInt(args.first);
            switch (op) {
                case '>': {
                    if (result <= y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case '<': {
                    if (result >= y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case '=': {
                    if (result != y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'L': {
                    if (result > y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'G': {
                    if (result < y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'X': {
                    if (y <= result) break;
                    result = y;
                    break;
                }
                case 'N': {
                    if (y >= result) break;
                    result = y;
                    break;
                }
                case '+': {
                    result += y;
                    break;
                }
                case '-': {
                    result -= y;
                    break;
                }
                case '*': {
                    result *= y;
                    break;
                }
                case '/': {
                    if (result % y == 0L) {
                        result /= y;
                        break;
                    }
                    return U.numCompute((double)result, args, op);
                }
                default: {
                    return E.error("internal error: unrecognized op: " + op);
                }
            }
            if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
                return U.numCompute((double)result, args, op);
            }
            args = U.toList(args.rest);
        }
        return U.toNum(result);
    }

    public static Object numCompute(double result, Pair args, char op) {
        while (U.isPair(args)) {
            double y = U.toReal(args.first);
            switch (op) {
                case '>': {
                    if (!(result > y)) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case '<': {
                    if (!(result < y)) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case '=': {
                    if (result != y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'L': {
                    if (!(result <= y)) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'G': {
                    if (!(result >= y)) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'X': {
                    if (!(y > result)) break;
                    result = y;
                    break;
                }
                case 'N': {
                    if (!(y < result)) break;
                    result = y;
                    break;
                }
                case '+': {
                    result += y;
                    break;
                }
                case '-': {
                    result -= y;
                    break;
                }
                case '*': {
                    result *= y;
                    break;
                }
                case '/': {
                    result /= y;
                    break;
                }
                default: {
                    return E.error("internal error: unrecognized op: " + op);
                }
            }
            args = U.toList(args.rest);
        }
        return U.toNum(result);
    }

    public static Object numberToString(Object x, Object y) {
        int base;
        int n = base = y instanceof Number ? U.toInt(y) : 10;
        if (base != 10 && x instanceof Integer) {
            return Long.toString(U.toInt(x), base);
        }
        return x.toString();
    }

    public static Object stringToNumber(Object x, Object y) {
        return InputPort.stringToNumber(U.stringify(x, false), y instanceof Number ? U.toInt(y) : 10);
    }

    public static Object stringToList(Object x) {
        Pair result = Pair.EMPTY;
        String str = U.toStr(x);
        int i = str.length() - 1;
        while (i >= 0) {
            result = new Pair(U.toChar(str.charAt(i)), result);
            --i;
        }
        return result;
    }

    public static String listToString(Object chars) {
        char[] str = new char[U.toList(chars).length()];
        int i = 0;
        while (U.isPair(chars)) {
            str[i] = U.to_char(U.first(chars));
            chars = U.rest(chars);
            ++i;
        }
        return new String(str);
    }

    public static int stringCompareIgnoreCase(Object x, Object y) {
        String xs = U.toStr(x);
        String ys = U.toStr(y);
        int i = 0;
        while (i < xs.length()) {
            int diff = Character.toUpperCase(xs.charAt(i)) - Character.toUpperCase(ys.charAt(i));
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return xs.length() - ys.length();
    }

    public static long gcd(Pair args) {
        return args.rest == Pair.EMPTY ? (long)U.toInt(args.first) : U.gcd(Math.abs(U.toInt(args.first)), U.gcd((Pair)args.rest));
    }

    static long gcd(long a, long b) {
        return b == 0L ? a : U.gcd(b, a % b);
    }

    static long lcm(Object args) {
        long L = 1L;
        long g = 1L;
        while (U.isPair(args)) {
            long n = Math.abs((long)U.toInt(U.first(args)));
            g = U.gcd(n, L);
            L = g == 0L ? g : n / g * L;
            args = U.toList(U.rest(args));
        }
        return L;
    }

    public static PrintWriter openOutputFile(Object filename) {
        try {
            return new PrintWriter(new FileWriter(U.stringify(filename, false)));
        }
        catch (FileNotFoundException e) {
            return (PrintWriter)E.error(e.toString());
        }
        catch (IOException e) {
            return (PrintWriter)E.error("IOException: " + e);
        }
    }

    public static InputPort openInputFile(Object filename) {
        try {
            return new InputPort(new FileInputStream(U.stringify(filename, false)));
        }
        catch (FileNotFoundException e) {
            return (InputPort)E.error("No such file: " + U.stringify(filename));
        }
        catch (IOException e) {
            return (InputPort)E.error("IOException: " + e);
        }
    }

    public static Object callWithInputFile(Object filename, Procedure proc) {
        Object result;
        block3: {
            InputPort in = null;
            result = null;
            try {
                in = U.openInputFile(filename);
                result = proc.apply(U.list(in));
                Object var5_4 = null;
                if (in == null) break block3;
                in.close();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            {
            }
        }
        return result;
    }

    public static Object callWithOutputFile(Object filename, Procedure proc) {
        PrintWriter out = null;
        Object result = null;
        try {
            out = U.openOutputFile(filename);
            result = proc.apply(U.list(out));
            Object var5_4 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
        return result;
    }

    public static boolean isList(Object x) {
        Object slow = x;
        Object fast = x;
        while (fast != Pair.EMPTY) {
            if (!U.isPair(fast) || !U.isPair(slow) || slow == U.rest(fast)) {
                return false;
            }
            slow = U.rest(slow);
            if ((fast = U.rest(fast)) == Pair.EMPTY) {
                return true;
            }
            if (!U.isPair(fast)) {
                return false;
            }
            fast = U.rest(fast);
        }
        return true;
    }

    public static Object append(Object args) {
        if (U.isPair(args)) {
            Queue queue = new Queue();
            while (U.isPair(U.rest(args))) {
                Object x = U.first(args);
                while (U.isPair(x)) {
                    queue.add(U.first(x));
                    x = U.rest(x);
                }
                args = U.rest(args);
            }
            queue.getLast().rest = U.first(args);
            return queue.getContent();
        }
        return args;
    }

    public static Object callCC(Procedure k) {
        RuntimeException cc = new RuntimeException("continuation");
        Continuation proc = new Continuation(cc);
        try {
            return k.apply(U.list(proc));
        }
        catch (RuntimeException e) {
            if (e == cc) {
                return proc.value;
            }
            throw e;
        }
    }

    public static Pair map(Procedure proc, Object args, Pair result) {
        Pair end = result;
        if (U.rest(args) == Pair.EMPTY) {
            Object argList = U.first(args);
            while (U.isPair(argList)) {
                Object x = proc.apply(U.list(U.first(argList)));
                if (end != Pair.EMPTY) {
                    end.rest = U.list(x);
                    end = end.rest;
                }
                argList = U.rest(argList);
            }
        } else {
            Procedure car = U.toProc(Symbol.CAR.getGlobalValue());
            Procedure cdr = U.toProc(Symbol.CDR.getGlobalValue());
            while (U.isPair(U.first(args))) {
                Object x = proc.apply(U.map(car, U.list(args), U.list(TRUE)));
                if (end != Pair.EMPTY) {
                    end.rest = U.list(x);
                    end = end.rest;
                }
                args = U.map(cdr, U.list(args), U.list(TRUE));
            }
        }
        return U.isPair(result) ? (Pair)U.rest(result) : result;
    }

    public static Pair timeCall(Procedure proc, int nTimes) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long startTime = System.currentTimeMillis();
        long startMem = runtime.freeMemory();
        Object ans = FALSE;
        int i = 0;
        while (i < nTimes) {
            ans = proc.apply(Pair.EMPTY);
            ++i;
        }
        long time = System.currentTimeMillis() - startTime;
        long mem = startMem - runtime.freeMemory();
        return new Pair(ans, U.list(U.list(U.toNum(time), Symbol.intern("msec")), U.list(U.toNum(mem), Symbol.intern("bytes"))));
    }

    public static Object p(String x, Object y) {
        if (Symbol.intern("debug").getGlobalValue() == TRUE) {
            Scheme.error.println(x + U.stringify(y));
        }
        return y;
    }

    public static Object toVec(Object x) {
        return x instanceof Object[] ? x : (x != null && x.getClass().isArray() ? x : E.typeError("vector", x));
    }

    public static boolean isVector(Object x) {
        return x instanceof Object[] || x != null && x.getClass().isArray();
    }

    public static Object makeVector(Object x) {
        return new Object[U.toInt(x)];
    }

    public static Object makeVector(Object x, Object fill) {
        Object[] v = new Object[U.toInt(x)];
        int i = 0;
        while (i < U.toInt(x)) {
            v[i] = fill;
            ++i;
        }
        return v;
    }

    public static Object vectorLength(Object x) {
        return x instanceof Object[] ? U.toNum(((Object[])x).length) : (x != null && x.getClass().isArray() ? U.toNum(Array.getLength(x)) : E.typeError("vector", x));
    }

    public static Object vectorRef(Object x, Object y) {
        return x instanceof Object[] ? ((Object[])x)[U.toInt(y)] : (x != null && x.getClass().isArray() ? Array.get(x, U.toInt(y)) : E.typeError("vector", x));
    }

    public static Object vectorSet(Object x, Object y, Object z) {
        if (x instanceof Object[]) {
            Object object = z;
            ((Object[])x)[U.toInt((Object)y)] = object;
            return object;
        }
        if (x != null && x.getClass().isArray()) {
            Array.set(x, U.toInt(y), z);
            return z;
        }
        return E.typeError("vector", x);
    }

    public static Pair vectorToList(Object vec) {
        Pair result = Pair.EMPTY;
        int i = Array.getLength(vec) - 1;
        while (i >= 0) {
            result = new Pair(Array.get(vec, i), result);
            --i;
        }
        return result;
    }

    public static Object[] listToVector(Object x) {
        Pair list = U.toList(x);
        int L = list.length();
        Object[] result = new Object[L];
        int i = 0;
        while (U.isPair(list)) {
            result[i] = U.first(list);
            ++i;
            list = U.toList(list.rest);
        }
        return result;
    }

    public static Object listToArray(Class C, Object x) {
        Pair list = U.toList(x);
        int L = list.length();
        if (L == 0) {
            return Array.newInstance(C, 0);
        }
        Object result = Array.newInstance(C, L);
        int i = 0;
        while (U.isPair(list)) {
            Array.set(result, i, U.first(list));
            ++i;
            list = U.toList(list.rest);
        }
        return result;
    }

    public static Pair arrayToList(Object x) {
        Pair result = Pair.EMPTY;
        int i = Array.getLength(x) - 1;
        while (i >= 0) {
            result = new Pair(Array.get(x, i), result);
            --i;
        }
        return result;
    }
}

