/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.lang.reflect.Method;
import jsint.E;
import jsint.Environment;
import jsint.Import;
import jsint.Invoke;
import jsint.Pair;
import jsint.Reflector;
import jsint.Scheme;
import jsint.U;

public class JavaMethod
extends Reflector {
    public static final Object[] args0 = new Object[0];
    private String methodClass;
    private Object[] methodTable;
    private boolean isStatic;
    private boolean isSpecific;

    public boolean isStatic() {
        return this.isStatic;
    }

    public JavaMethod(String name, Class c, boolean isStatic, boolean canAccessPrivateData) {
        this.name = name;
        if (c != null) {
            this.methodClass = c.getName();
        }
        this.isStatic = isStatic;
        this.isSpecific = c != null;
        this.minArgs = isStatic ? 0 : 1;
        this.canAccessPrivateData = canAccessPrivateData;
        this.reset();
    }

    public JavaMethod(String name, Class c, boolean isStatic) {
        this(name, c, isStatic, false);
    }

    public JavaMethod(String name, Class c) {
        this(name, c, c != null);
    }

    protected synchronized void reset() {
        if (this.isSpecific) {
            this.methodTable = Invoke.methodTable0(Import.classNamed(this.methodClass), this.name, this.isStatic, this.canAccessPrivateData);
            if (this.methodTable.length == 0) {
                this.methodTable = null;
                E.warn("No such " + (this.isStatic ? " static " : " instance ") + " method \"" + this.name + (this.isSpecific ? "\" in class " + this.methodClass : ""));
            }
        }
    }

    public Object apply(Object[] args) {
        if (!this.isSpecific) {
            return Invoke.invokeInstance(args[0], this.name, (Object[])args[1], this.canAccessPrivateData);
        }
        if (this.methodTable == null) {
            return E.error(this + " has no methods");
        }
        if (this.isStatic) {
            Method m = (Method)Invoke.findMethod(this.methodTable, args);
            return Invoke.invokeRawMethod(m, null, args);
        }
        Object[] as = (Object[])args[1];
        Method m = (Method)Invoke.findMethod(this.methodTable, as);
        return Invoke.invokeRawMethod(m, args[0], as);
    }

    public Object[] makeArgArray(Object[] code, Environment env) {
        if (this.isStatic) {
            int L = code.length - 1;
            if (L == 0) {
                return args0;
            }
            Object[] args = new Object[L];
            int i = 0;
            while (i < L) {
                args[i] = Scheme.execute(code[i + 1], env);
                ++i;
            }
            return args;
        }
        Object target = Scheme.execute(code[1], env);
        int L = code.length - 2;
        if (L == 0) {
            return new Object[]{target, args0};
        }
        Object[] args = new Object[L];
        int i = 0;
        while (i < L) {
            args[i] = Scheme.execute(code[i + 2], env);
            ++i;
        }
        return new Object[]{target, args};
    }

    public Object[] makeArgArray(Pair args) {
        if (this.isStatic) {
            return U.listToVector(args);
        }
        return new Object[]{args.first, U.listToVector(args.rest)};
    }
}

