/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import jsint.E;
import jsint.Environment;
import jsint.Import;
import jsint.Invoke;
import jsint.Pair;
import jsint.Reflector;
import jsint.Scheme;
import jsint.StaticReflector;
import jsint.U;

public class JavaField
extends Reflector {
    static final Hashtable fieldTable = new Hashtable(50);
    String className;
    Field f;
    boolean isStatic = false;

    public static Field getField(Class c, String name) {
        return JavaField.getField(c, name, false);
    }

    public static Field getField(Class c, String name, boolean canAccessPrivateData) {
        Hashtable classTable = JavaField.getFieldClassTable(canAccessPrivateData ? name : name.concat("#"));
        Field it = (Field)classTable.get(c);
        if (it == null) {
            try {
                it = canAccessPrivateData ? JavaField.getDeclaredField(c, name) : c.getField(name);
            }
            catch (NoSuchFieldException e2) {
                return (Field)E.error("no such field:" + c + "." + name);
            }
            catch (Exception e) {
                return (Field)E.error("error accessing field:" + c + "." + name + " is " + e);
            }
            classTable.put(c, it);
        }
        return it;
    }

    private static Hashtable getFieldClassTable(String name) {
        Hashtable table = (Hashtable)fieldTable.get(name);
        if (table == null) {
            table = new Hashtable(10);
            fieldTable.put(name, table);
        }
        return table;
    }

    private static Field getDeclaredField(Class c, String name) throws NoSuchFieldException {
        try {
            Field[] fs = (Field[])Invoke.makeAccessible(c.getDeclaredFields());
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getName().equals(name)) {
                    return fs[i];
                }
                ++i;
            }
            Class s = c.getSuperclass();
            if (s != null) {
                return JavaField.getDeclaredField(s, name);
            }
            return (Field)E.error("\n\nERROR: no field: \"" + name + "\" for class \"" + c + "\"");
        }
        catch (Exception e) {
            return c.getField(name);
        }
    }

    public JavaField(String name, Class c) {
        this.name = name;
        if (c != null) {
            this.className = c.getName();
        }
        this.reset();
    }

    public JavaField(String name, Class c, boolean canAccessPrivateData) {
        this.name = name;
        this.canAccessPrivateData = canAccessPrivateData;
        if (c != null) {
            this.className = c.getName();
        }
        this.reset();
    }

    protected synchronized void reset() {
        Class c;
        Class clazz = c = this.className == null ? null : Import.classNamed(this.className);
        if (c != null) {
            this.f = JavaField.getField(c, this.name, this.canAccessPrivateData);
            this.isStatic = Modifier.isStatic(this.f.getModifiers());
            this.minArgs = this.isStatic ? 0 : 1;
            this.maxArgs = Modifier.isFinal(this.f.getModifiers()) ? this.minArgs : this.minArgs + 1;
        } else {
            this.minArgs = 1;
            this.maxArgs = 2;
        }
    }

    public Object[] makeArgArray(Object[] code, Environment env) {
        int L = code.length - 1;
        if (L == 0 && this.isStatic) {
            return StaticReflector.args0;
        }
        if (L == 1) {
            return new Object[]{Scheme.execute(code[1], env)};
        }
        if (L == 2 && !this.isStatic) {
            return new Object[]{Scheme.execute(code[1], env), Scheme.execute(code[2], env)};
        }
        return (Object[])E.error("Wrong number of arguments to field " + this + " " + U.stringify(code));
    }

    public Object[] makeArgArray(Pair args) {
        int L = args.length();
        if (L == 0 && this.isStatic) {
            return StaticReflector.args0;
        }
        if (L == 1) {
            return new Object[]{args.first()};
        }
        if (L == 2 && !this.isStatic) {
            return new Object[]{args.first(), args.second()};
        }
        return (Object[])E.error("Wrong number of arguments to field " + this + " " + U.stringify(args));
    }

    public Object apply(Object[] args) {
        int L = args.length;
        if (this.isStatic) {
            if (L == 1) {
                return this.setFieldValue(null, this.f, args[0]);
            }
            return this.getFieldValue(null, this.f);
        }
        if (L == 1) {
            return this.getFieldValue(args[0], this.f);
        }
        return this.setFieldValue(args[0], this.f, args[1]);
    }

    public Object getFieldValue(Object target, Field f) {
        if (f == null) {
            f = JavaField.getField(target.getClass(), this.name, this.canAccessPrivateData);
        }
        try {
            return f.get(target);
        }
        catch (IllegalAccessException e) {
            return E.error("Illegal Access to field: " + f + " in " + U.stringify(target));
        }
    }

    public Object setFieldValue(Object target, Field f, Object value) {
        if (f == null) {
            f = JavaField.getField(target.getClass(), this.name, this.canAccessPrivateData);
        }
        try {
            Object old = f.get(target);
            f.set(target, value);
            return old;
        }
        catch (Exception e) {
            return this.setNarrowedFieldValue(target, f, value);
        }
    }

    private Object setNarrowedFieldValue(Object target, Field f, Object value) {
        if (f == null) {
            f = JavaField.getField(target.getClass(), this.name, this.canAccessPrivateData);
        }
        try {
            Object old = f.get(target);
            f.set(target, JavaField.narrow(value, f.getType()));
            return old;
        }
        catch (IllegalAccessException e) {
            return E.error("Illegal Access to field: " + f + " in " + U.stringify(target));
        }
    }

    public static Object narrow(Object value, Class type) {
        double w;
        if (type.isInstance(value) || !(value instanceof Number)) {
            return value;
        }
        int v = ((Number)value).intValue();
        if ((double)v != (w = ((Number)value).doubleValue())) {
            return value;
        }
        if (type == Byte.TYPE && -128 <= v && v <= 127) {
            return new Byte((byte)v);
        }
        if (type == Short.TYPE && Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
            return new Short((short)v);
        }
        if (type == Integer.TYPE && Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
            return new Integer(v);
        }
        return value;
    }
}

