/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import jsint.Environment;
import jsint.LocalVariable;
import jsint.Scheme;
import jsint.Symbol;
import jsint.U;

public class BacktraceException
extends RuntimeException {
    public static boolean printJavaTrace = false;
    private Throwable exception;
    private Object[] args;
    private Environment env;
    static /* synthetic */ Class class$jsint$LocalVariable;

    public BacktraceException(Throwable e, Object[] args) {
        this(e, args, Environment.GLOBAL);
    }

    public BacktraceException(Throwable e, Object[] args, Environment env) {
        super(e.getMessage());
        this.exception = e;
        this.args = args;
        this.env = env;
    }

    public Throwable getBaseException() {
        Throwable t = this.exception;
        while (t instanceof BacktraceException) {
            t = ((BacktraceException)t).exception;
        }
        return t;
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s));
    }

    public void printStackTrace() {
        this.printStackTrace(Scheme.error);
    }

    public void printStackTrace(PrintWriter s) {
        try {
            s.println();
            this.showargs(this.args, s);
            s.println();
            this.env.show(s);
            s.println("\n  ====================================");
            if (printJavaTrace || this.exception instanceof BacktraceException) {
                this.exception.printStackTrace(s);
            } else {
                s.println(this.exception);
            }
            s.flush();
        }
        catch (Throwable e) {
            System.out.println("Error in BacktraceException.printStackTrace: ");
            try {
                BacktraceException.ultimateException(e).printStackTrace(Scheme.error);
            }
            catch (Throwable e2) {
                try {
                    System.out.println("Error tracing the ultimate error: " + BacktraceException.ultimateException(e));
                }
                catch (Throwable e3) {
                    System.out.println("Error printing ultimate error of class: " + BacktraceException.ultimateException(e).getClass());
                }
            }
        }
    }

    public void showargs(Object x, PrintWriter s) {
        if (x == null) {
            s.println();
        } else if (x.getClass().isArray()) {
            Object[] xv = (Object[])x;
            if (xv.length > 0 && Symbol.QUOTE == xv[0]) {
                s.print(U.stringify(xv[1]) + " ");
            } else {
                s.print("(");
                int i = 0;
                while (i < xv.length) {
                    this.showargs(xv[i], s);
                    ++i;
                }
                s.print(")");
            }
        } else if (x.getClass() == (class$jsint$LocalVariable == null ? (class$jsint$LocalVariable = BacktraceException.class$("jsint.LocalVariable")) : class$jsint$LocalVariable)) {
            s.print(((LocalVariable)x).name + " ");
        } else {
            s.print(U.stringify(x) + " ");
        }
    }

    public String toString() {
        StringWriter s = new StringWriter();
        this.printStackTrace(new PrintWriter(s));
        return "jsint.BacktraceException[\n  " + s.toString() + "]";
    }

    private static Throwable ultimateException(Throwable e) {
        return e instanceof BacktraceException ? BacktraceException.ultimateException(((BacktraceException)e).exception) : e;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

