/*
 * Decompiled with CFR 0.152.
 */
package interact;

import interact.IOTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import jscheme.JS;
import jsint.BacktraceException;
import jsint.InputPort;
import jsint.Procedure;
import jsint.Scheme;
import jsint.U;

public class Interactor
implements Runnable {
    JFrame frame;
    private IOTextArea area;
    private Reader in;
    private PrintWriter out;
    String name;
    int rows;
    int cols;
    Object[] pairs;
    String[] files;

    private IOTextArea getArea() {
        if (this.area == null) {
            this.area = new IOTextArea(this.rows, this.cols);
            this.area.setFont(new Font("monospaced", 0, 12));
        }
        return this.area;
    }

    private Reader getReader() {
        if (this.in == null) {
            this.in = this.getArea().getReader();
        }
        return this.in;
    }

    private PrintWriter getWriter() {
        if (this.out == null) {
            this.out = new PrintWriter(this.getArea().getWriter());
        }
        return this.out;
    }

    public Interactor(Object it) {
        this(new Object[]{"it", it});
    }

    public Interactor(Object[] pairs) {
        this(true, "Interactor", pairs, 24, 80, null);
    }

    public Interactor(boolean newThread, String name, Object[] pairs, int rows, int cols, String[] files) {
        this.name = name;
        this.pairs = pairs;
        this.rows = rows;
        this.cols = cols;
        this.files = files;
        this.frame = this.createFrame();
        if (newThread) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    private JFrame createFrame() {
        JFrame frame = new JFrame(this.name);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Toolkit.getDefaultToolkit().beep();
                Interactor.this.getWriter().println("Type (exit) to exit this Frame!");
            }
        });
        Container pane = frame.getContentPane();
        JScrollPane scroll = new JScrollPane(this.getArea());
        pane.add((Component)scroll, "Center");
        frame.pack();
        ((Component)frame).setVisible(true);
        return frame;
    }

    public void readEvalWriteLoop(String prompt) {
        Scheme.readEvalWriteLoop(prompt);
    }

    public void run() {
        BacktraceException.printJavaTrace = true;
        Scheme.input = new InputPort(this.getReader());
        Scheme.output = this.getWriter();
        Scheme.error = this.getWriter();
        JS.evalOrLoad("elf/basic.scm");
        this.importVariables();
        if (this.files != null) {
            this.loadFiles(this.files);
        }
        this.readEvalWriteLoop("> ");
        this.frame.dispose();
        this.frame = null;
    }

    private void loadFiles(String[] args) {
        int i = 0;
        while (i < (args == null ? 0 : args.length)) {
            JS.evalOrLoad(args[i]);
            ++i;
        }
    }

    private void importVariables() {
        Procedure importer = (Procedure)JS.getGlobalValue("import");
        if (this.pairs != null) {
            JS.call("display", (Object)"Bindings:\n");
            int i = 0;
            while (i < this.pairs.length) {
                this.importVariable((String)this.pairs[i], this.pairs[i + 1]);
                i += 2;
            }
        }
    }

    private void importVariable(String var, Object val) {
        JS.setGlobalValue(var, val);
        JS.call("import", (Object)val.getClass().getName());
        JS.call("display", (Object)(var + " = " + U.stringify(val) + "\n"), (Object)Scheme.output);
    }

    public static void main(String[] args) {
        new Interactor(false, "Interactor", new Object[]{"now", new Date()}, 24, 80, args);
        System.out.println("Interaction done!");
        System.exit(0);
    }
}

