#ifndef GLOBALS_H
#define GLOBALS_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Globals for OPENCM: */

/* Temporary fix for server's memory leak: */
#define MEMLEAK_PATCH
extern int num_active_clients;

extern int opencmport;

#define CACHESIZE 15;

#define OPENCM_LOCAL_FILTER_FILE ".opencm-rules"

/* repository access */
#define ACC_REVOKED 0x1u
#define ACC_READ    0x2u
#define ACC_WRITE   0x4u

/* Debugging classes: */
extern unsigned dbg_mask;

char *server_err_msg;

/* Repository URI to connect to: */
extern char *RepositoryURI;

/* User's preferred editor: */
extern char *Editor;

/* Command-line options... */

extern int  opt_ReadOnly;	/* -n, --readonly */
extern int  opt_ShowVersion;	/* -V, --version */
extern int  opt_Verbosity;	/* -v, --verbose */
extern int  opt_LongListing;	/* -l, --verbose */
extern int  opt_Foreground;	/* --foreground */
extern int  opt_Force;		/* -f, --force */
extern int  opt_FlushIO;	/* --flush-io */
extern int  opt_NewBranch;	/* -B, --newbranch */
extern int  opt_NewProject;	/* -P, --newproject */
extern int  opt_noSSL;	        /* --transport (SSL | TCP) */
extern int  opt_TraceProtocol;  /* --traceprotocol */
extern int  opt_Private;        /* --private  (for forking branches) */
extern char *opt_Editor;	/* -e */
extern char *opt_Message;	/* -m message for either commitinfo or descr */
extern int  opt_HaveRepository;	/* --repos */
extern int  opt_RBTreeDebug;	/* --rbtree-debug */
extern int  opt_HaveUser;	/* --user */
extern int server_mode;		/* are we running server or client? */
extern char *opt_RandomFile;	/* random seed file */
extern char *opt_LogDir;	/* directory for server log files */
extern const char *opt_Chdir;	/* whether to change directory */
extern const char *opt_Against;	/* baseline version for diff */
extern char *opt_KeyType;	/* type of key to use */
extern const char *opt_user;	/* name of user key file */
extern const char *opt_ConfigDir; /* location of config directory */
extern char *opt_Name;          /* --name */
extern char *opt_AlternatePort; /* --port  specifies port for server */
extern int opt_ForceHash;	/* whether to force a hash recomputation */
extern int opt_CompressionLevel; /* preferred compression level */
extern const char *opt_Notify;

extern OC_bool do_Upgrade; /* whether to perform repository upgrades */

extern unsigned char opt_eType;	/* 'T' == text, 'B' == binary, 
				   '?' == autoselect */

extern SSL_CTX *ssl_ctx;  /* defined in ChannelSSL.c */

void process_options(int argc, char **argv);
void usage(const char *fmt, ...);

void xreport_error(Exception exc, const char *fmt, ...)
  __attribute__ ((__noreturn__));
void vlog_error(const char *fmt, va_list args);
void log_error(const char *fmt, ...);

int compare_rpm_versions(const char *v1, const char *v2);

/* Like fopen, but requires two additional args:
   { 'r' | 'w' }  and { 't' | 'b' } */
FILE * xfopen(const char *path, const char mode, const char ftype);
void xfclose(FILE *);
	    
void strip_comments(char *buf, const char *leader);
char *get_message(const char *msg, const char *leader,
		  const char *dflt);
char *read_message_file(const char *fname, const char *leader);
int opencm_confirm(const char *prompt, int dflt_yes);
char *opencm_readline(const char *prompt, const char *dflt);

void initialize_PRNG(void);

/*Top_of_Stack Global for the Entity Cache Flush mechanism*/
const void* top_of_stack;

#endif /* GLOBALS_H */
