#ifndef COMMON_PATH_H
#define COMMON_PATH_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

const char *path_curdir(void);
const char *path_rootdir(void);
OC_bool path_is_dir_sep(char);
const char *path_parent_dir(void);

/* An opaque wrapper around POSIX.1 directory reading */
struct OC_DIR_st;
typedef struct OC_DIR_st OC_DIR;
OC_DIR* path_opendir(const char* dirname, OC_bool must_exist);
const char* path_readdir(OC_DIR*);
void path_closedir(OC_DIR*);
  
OC_bool path_should_skip_dirent(const char *nm);

void path_remove(const char *path);
void path_remove_editor_file(const char *path);
void path_rename(const char *oldpath, const char *newpath);
void path_srename(const char *oldpath, const char *newpath);
OC_bool path_exists(const char *path);
OC_bool path_isdir(const char *path);
OC_bool path_isfile(const char *path);
OC_bool path_isexecutable(const char *path);
void path_mkexecutable(const char *path, OC_bool);
OC_bool path_issymlink(const char *path);
OC_bool path_isAbsolute(const char *path);
OC_bool path_isRelative(const char *path);
const char *path_resolvelink(const char *path);
int path_mksymlink(const char *target, const char *link);
int path_link_tail(const char *target, const char *link);
OC_bool path_isprefix(const char *prefix, const char *path);
void path_mkdir(const char *path);
void path_create(const char *path);	/* create empty file */
/* "super" mkdir -- creates path recursively.*/
void path_smkdir(const char *path);
void path_rmdir(const char *path);
void path_rmdir_recursive(const char *path);
off_t path_file_length(const char *path);

const char *path_current_directory(void);
OC_bool path_same_dir(const char *path1, const char *path2);
  
/* The implementation of this is OS specific: */
const char *path_scratchdir(void);
const char *path_mktmpnm(const char *dir, const char *base);

/* The following return malloc'd storage: */
const char *path_join(const char *dir, const char *tail);	
const char *path_canonical(const char *path);
const char *path_tn_fixup(const char *en);

/* See "The Little Lisper" -- it will make more sense then. */
const char *path_car(const char *path);
const char *path_cdr(const char *path);
const char *path_tail(const char *path);
const char *path_dirname(const char *path);

/* A portable subset of the 'stat' structure */
typedef enum {
  psUnknown = '?',		/* unknown file type */
  psChrDev =  'C',		/* character device */
  psDir =     'D',		/* directory */
  psFile =    'F',		/* regular file */
  psSymlink = 'S'		/* symbolic link */
} portstat_filetype_t;

typedef struct portstat_t portstat_t;
struct portstat_t {
  OC_bool              exists;
  time_t               modTime;
  portstat_filetype_t  type;
  off_t                len;
  OC_bool              isExec;
};

void path_portstat(const char *fname, portstat_t *ps);
void path_set_mod_time(const char *fname, const char *isoTime);
#endif /* COMMON_PATH_H */
