AC_DEFUN([AC_AUTOCONFIG_GC], [
  AC_MSG_CHECKING([if autoconf has been run for gc6.3])
  if test -d gc6.3; then
    if test -r gc6.3/configure; then
      AC_MSG_RESULT([yes])
    else
      (cd gc6.3; autoconf)
      AC_MSG_RESULT([built])
    fi
  else
    echo "no - using external libgc"
  fi
  ])
])

dnl The check for libtermcap/libcurses is a HUGE mess. First, the headers
dnl and the libraries need to agree. Second, we need to get the proper header
dnl macros defined. The objective of the macro below is to identify
dnl two independent things: which SUBSYSTEM to use, and separately,
dnl where the required headers are to be found.
AC_DEFUN([CHECK_TERMCAP], [
  
])

dnl added libtermcap/libtermcap.a, which is apparently needed for cygwin.
dnl Jeff Putsch explicitly ducked this for go32, but it's not clear to me
dnl why. If present, using it shouldn't be a problem. If absent, the link
dnl test should fail comfortably.
AC_DEFUN([CHECK_LIB_TERMCAP], [
  AC_CACHE_CHECK([for a curses/termcap compatible library],
                 vl_cv_lib_termcap, [
    AC_CHECK_LIB(ncurses, tgetent, vl_cv_lib_termcap="-lncurses",
      AC_CHECK_LIB(termlib, tgetent, vl_cv_lib_termcap="-ltermlib",
        AC_CHECK_LIB(termcap, tgetent, vl_cv_lib_termcap="-ltermcap",
          AC_CHECK_LIB(curses, tgetent, vl_cv_lib_termcap="-lcurses",
            AC_CHECK_LIB(terminfo, tgetent, vl_cv_lib_termcap="-lterminfo")))))
    if test -z "$vl_cv_lib_termcap"; then
      vl_cv_lib_termcap="no"
    fi
  ])

  if test "$vl_cv_lib_termcap" != "no"; then
    LIBS="$LIBS $vl_cv_lib_termcap"
    AC_DEFINE(HAVE_LIBTERMCAP, 1,
              [Define if you have a termcap compatible library])
    AC_CHECK_HEADERS(term.h curses.h ncurses.h)
  fi
])dnl

dnl NOTE that the following depends on the previous check for libtermcap.
AC_DEFUN([CHECK_LIB_READLINE], [
  AC_CACHE_CHECK([for a readline compatible library],
                 vl_cv_lib_readline, [
    ORIG_LIBS="$LIBS"
    for readline_lib in readline edit editline; do
      TRY_LIB="-l$readline_lib"
      LIBS="$LIBS $TRY_LIB"

      AC_TRY_LINK_FUNC(readline, vl_cv_lib_readline="$TRY_LIB")

      LIBS="$ORIG_LIBS"

      if test -n "$vl_cv_lib_readline"; then
        break
      fi
    done
    if test -z "$vl_cv_lib_readline"; then
      vl_cv_lib_readline="no"
    fi
  ])

  if test "$vl_cv_lib_readline" != "no"; then
    LIBS="$LIBS $vl_cv_lib_readline"
    AC_DEFINE(HAVE_LIBREADLINE, 1,
              [Define if you have a readline compatible library])
    AC_CHECK_HEADERS(readline.h readline/readline.h)
    AC_CACHE_CHECK([whether readline supports history],
                   vl_cv_lib_readline_history, [
      vl_cv_lib_readline_history="no"
      AC_TRY_LINK_FUNC(add_history, vl_cv_lib_readline_history="yes")
    ])
    if test "$vl_cv_lib_readline_history" = "yes"; then
      AC_DEFINE(HAVE_READLINE_HISTORY, 1,
                [Define if your readline library has \`add_history'])
      AC_CHECK_HEADERS(history.h readline/history.h)
    fi
  fi
])dnl

dnl Newer versions of linux put the Kerberos headers in a different place.
AC_DEFUN([CHECK_KERBEROS], [
  AC_CACHE_CHECK([for Kerberos],
                 vl_cv_lib_kerberos, [
    krb5_dirs="/usr/local/kerberos /usr/kerberos /usr"
    if test -n "$try_krb5dir"; then
      krb5_dirs="$try_krb5dir $krb5_dirs"
    fi
    for dir in $krb5_dirs; do
      dnl if dir does not exist, skip it
      if test ! -d "$dir" ; then
        continue;
      fi
      if test -f "$dir/include/krb5.h"; then
        vl_cv_lib_kerberos="$dir"
        break;
      fi
    done
    if test -z "$vl_cv_lib_kerberos"; then
      vl_cv_lib_kerberos="no"
    fi
  ])
  if test "$vl_cv_lib_kerberos" != "no"; then
    krb5dir="$vl_cv_lib_kerberos"
    KRB5_LIBS="-lkrb5"
    if test "$krb5dir" != "/usr"; then
      KRB5_INC="-I$krb5dir/include"
      KRB5_LDFLAGS="-L$krb5dir/lib"
    fi
    AC_DEFINE(HAVE_KERBEROS, 1,
              [Define if you have the Kerberos libraries])
  else
    AC_MSG_ERROR([You must have Kerberos installed to use OpenCM])
  fi
])dnl

dnl IRIX puts things in /usr/freeware, and the libs in /usr/freeware/lib32 just
dnl to be a pain.
AC_DEFUN([CHECK_SSL], [
  AC_CACHE_CHECK([for OpenSSL library],
                 vl_cv_lib_ssl, [
    ssl_dirs="/usr/local/ssl /usr/lib/ssl /usr/ssl /usr/plg /usr/local /usr /usr/freeware"
    if test -n "$try_ssldir"; then
      ssl_dirs="$try_ssldir $ssl_dirs"
    fi
    for dir in $ssl_dirs; do
      dnl if dir does not exist, skip it
      if test ! -d "$dir" ; then
        continue;
      fi
      if test -f "$dir/include/openssl/ssl.h"; then
        vl_cv_lib_ssl="$dir"
        break;
      fi
    done
    if test -z "$vl_cv_lib_ssl"; then
      vl_cv_lib_ssl="no"
    fi
  ])
  if test "$vl_cv_lib_ssl" != "no"; then
    ssldir="$vl_cv_lib_ssl"
    SSL_LIBS="-lssl -lcrypto"
    if test "$ssldir" = "/usr/freeware"; then
      SSL_INC="-I$ssldir/include"
      SSL_LDFLAGS="-L$ssldir/lib32";
    elif test "$ssldir" != "/usr"; then
      SSL_INC="-I$ssldir/include"
      SSL_LDFLAGS="-L$ssldir/lib"
    fi
    AC_DEFINE(HAVE_OPENSSL, 1,
              [Define if you have the OpenSSL library])
  else
    AC_MSG_ERROR([You must have OpenSSL installed to use OpenCM])
  fi
])dnl
