/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

void
null_serialize(SDR_stream *strm, const void *ob)
{
  /* Nothing to do */
}

void *
null_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  /* Nothing to do */
  return 0;
}

void
null_show(const void *ob)
{
  xprintf("<NULL>\n");
}

#define OBTYPE(nm,prefix,abbrev,er) extern SerialType nm##_SerType;
#include "OBTYPES.def"

SerialType *serTypes[TY_ntypes] = {
#define OBTYPE(nm,prefix,abbrev,ver) &nm##_SerType,
#include "OBTYPES.def"
} ;

#define OBTYPE(nm,prefix,abbrev,ver) \
  struct SerialType nm##_SerType = { TY_##nm, ver, #nm, #abbrev, prefix##_deserialize, prefix##_serialize, prefix##_show };
#include "OBTYPES.def"

SerialType *
ser_find_type(unsigned long t)
{
  unsigned u;

  for (u = 0; u < TY_ntypes; u++) {
    if (serTypes[u] && (serTypes[u]->typ) == t)
      return serTypes[u];
  }

  return 0;
}

/* #define CROSS_CHECK */
const char *
ser_getTrueName(const void *s)
{
  /* We must always recompute this, because allegedly frozen objects
     are modified in-place on the client and then re-presented at the
     repository interface for upload. */

  const char *tn;
#ifdef CROSS_CHECK
  const char *tnchk;
#endif

#if 0
  {
    Serializable *ser = (Serializable *) s;
    const char *stn = ser->ser_trueName;

    if (stn)
      return stn;
  }
#endif

#ifdef CROSS_CHECK
  /* The definitive computation of a truename is to write the object
     to a raw stream and then compute an SHA1 hash on the resulting
     data.  This creates a duplicated buffer, and is therefore memory
     intensive. We have therefore implemented a special stream that
     doesn't actually store a duplicate buffer, but computes the SHA1
     "on the fly". This check is here to allow us to verify that the
     computed result is identical to the definitive one. */
  {
    SDR_stream *strm = stream_createBuffer(SDR_BINARY);
    char *buf;
    unsigned len;

    sdr_write("ENTITY", strm, s);
    stream_close(strm);
    stream_reread(strm);

    len = stream_length(strm);
    buf = buffer_asString(stream_asBuffer(strm));

    tnchk = 
      truename_FromBytes(((Serializable *)s)->ser_type->prefix, len, buf);
  }
#endif

  {
    SDR_stream *shastrm = stream_create_sha1();
    char buf[30];
    unsigned len;
    sdr_write("ENTITY", shastrm, s);
    stream_reread(shastrm);

    len = stream_length(shastrm);

    assert(len < 29);

    stream_read(shastrm, buf, len);
    buf[len] = 0;

    tn = 
      truename_FromHash(((Serializable *)s)->ser_type->prefix, buf);

    stream_close(shastrm);
  }

#ifdef CROSS_CHECK
  if (!nmequal(tn, tnchk)) {
    xprintf("Truename mismatch: %s, %s\n", tn, tnchk);
    assert(FALSE);
  }
#endif

  return tn;
}
