#ifndef COMMON_PTRARRAY_H
#define COMMON_PTRARRAY_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

typedef struct ObVec ObVec;
struct ObVec {
  Serializable ser;

  unsigned      size;
  unsigned      maxSize;
  const void  **elements;
};

ObVec *obvec_create(void);
void   obvec_append(ObVec *vec, const void *vp);
void   obvec_insert(ObVec *vec, const void *vp, unsigned ndx);
void   obvec_set(ObVec *vec, const void *vp, unsigned ndx);
void   obvec_sort(ObVec *vec);
void   obvec_sort_using(ObVec *vec, int (*cmp)(const void *, const void *));
ObVec *obvec_shallow_copy(ObVec *vec);

typedef struct StrVec StrVec;
struct StrVec {
  Serializable ser;
  
  unsigned     size;
  unsigned     maxSize;
  const char **elements;
};

StrVec * strvec_create(void);
void     strvec_append(StrVec *vec, const char *s);
void     strvec_insert(StrVec *vec, const char *s, unsigned ndx);
void     strvec_set(StrVec *vec, const char *s, unsigned ndx);
char *   strvec_flatten(StrVec *vec);
void     strvec_sort(StrVec *vec);
void     strvec_bremove(StrVec *vec, const char *s); /* use when sorted */
int      strvec_bsearch(StrVec *vec, const char *s); /* use when sorted */

typedef struct StrVec TnVec;

TnVec   *tnvec_create(void);
void    tnvec_append(TnVec *vec, const char *s);
void    tnvec_insert(TnVec *vec, const char *s, unsigned ndx);
void    tnvec_set(TnVec *vec, const char *s, unsigned ndx);
void    tnvec_sort(TnVec *vec);
void    tnvec_bremove(TnVec *vec, const char *s); /* use when sorted */
int     tnvec_bsearch(StrVec *vec, const char *s); /* use when sorted */

#define vec_size(vec)       ((vec)->size)
#define vec_fetch(vec,ndx)  ((vec)->elements[(ndx)])

/* These leverage the underlying representation pun... */
extern void vec_remove(void *vec, unsigned ndx);
extern void vec_reset(void *vec);
extern void* vec_dup(void *vec);

#endif /* COMMON_PTRARRAY_H */
