/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

Group *
group_create(void)
{
  Group *g = (Group *) GC_MALLOC(sizeof(Group));

  /* FiX: Make sure nickname doesn't contain spaces.  Replace all spaces
   * with underline???  */

  g->serType = &Group_SerType;
  SER_MODIFIED(g);

  g->members = strvec_create();

  return g;
}

void
group_show(const void *vp)
{
  const Group *g = vp;
  
  xprintf("TrueName     %s\n", ser_getTrueName(g));
  xprintf("Members:     %u\n", vec_size(g->members));
  if (opt_Verbosity > 0) {
    unsigned u;
    
    for (u = 0; u < vec_size(g->members); u++)
      xprintf("      %s\n", (const char *)(vec_fetch(g->members, u)));
  }
}

void
group_serialize(SDR_stream *strm, const void *ob)
{
  const Group *g = ob;
  
  sdr_write("members", strm, g->members);
}

void *
group_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  Group *g = (Group *) GC_MALLOC(sizeof(Group));

  g->serType     = &Group_SerType;
  SER_MODIFIED(g);

  g->members    = sdr_read("members", strm);

  return g;
}

OC_bool
group_IsMember(Group *g, const char *uri)
{
  int u;
  for (u = 0; u < vec_size(g->members); u++) {
    if (nmequal(uri, (const char *)vec_fetch(g->members, u)))
      return TRUE;
  }
  return FALSE;
}

void
group_append(Group *g, const char *uri)
{
  if (!group_IsMember(g, uri)) {
    strvec_append(g->members, uri);
    SER_MODIFIED(g);
  }
}

void
group_remove(Group *g, const char *uri)
{
  int u;
  for (u = 0; u < vec_size(g->members); u++) {
    if (nmequal(uri, (const char *)vec_fetch(g->members, u))) {
      vec_remove(g->members, u);
      SER_MODIFIED(g);
      break;
    }
  }
}
