#ifndef CLIENT_COMMAND_H
#define CLIENT_COMMAND_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Commands implemented by the OPENCM user agent, plus supporting logic: */

/*
 * Command table -- logic for this is borrowed from Mach debugger.
 */
struct command {
  char		*name;		/* command name */
				/* function to call */
  void		(*fcn)(WorkSpace *ws, int argc, char **argv);

#define CF_OPTARGS      0x01u	/* command takes optional arguments */
#define CF_NOCONNECT    0x02u	/* no connection should be made */
#define CF_OPTCONNECT   0x04u	/* connection is optional */
#define CF_WSINIT       0x08u	/* initialize the workspace */
#define CF_NAME         0x10u	/* command requires --name */
#define CF_ADMIN        0x20u	/* admin command */
#define CF_NOROOTSEARCH 0x40u	/* do not hunt down project root --
				   only check local directory (import) */

#define CMD_ISFLAG(cmd,flg) (cmd->flags & (flg))

  int             nargs;

  unsigned        flags;

  struct command *more;	/* another level of command */

  const char *docFile;
};

struct found_command {
  struct command *cmd;
  int argc;
  char **argv;
};

extern struct found_command
opencm_find_command(int argc, char **argv);

extern void opencm_server(WorkSpace *, int argc, char **argv);

extern void opencm_create_branch(WorkSpace *, int argc, char **argv);
extern void opencm_rename(WorkSpace *, int argc, char **argv);
extern void opencm_version(WorkSpace *, int argc, char **argv);
extern void opencm_checkout(WorkSpace *, int argc, char **argv);
extern void opencm_dump(WorkSpace *, int argc, char **argv);
extern void opencm_status(WorkSpace *, int argc, char **argv);

extern void opencm_add_file(WorkSpace *, int argc, char **argv);
extern void opencm_remove_file(WorkSpace *, int argc, char **argv);
extern void opencm_enumerate(WorkSpace *, int argc, char **argv);
extern void opencm_commit(WorkSpace *, int argc, char **argv);
extern void opencm_revert(WorkSpace *, int argc, char **argv);
extern void opencm_import(WorkSpace *, int argc, char **argv);
extern void opencm_preds(WorkSpace *, int argc, char **argv);
extern void opencm_diff(WorkSpace *, int argc, char **argv);
extern void opencm_ndiff(WorkSpace *, int argc, char **argv);
extern void opencm_merge(WorkSpace *, int argc, char **argv);
extern void opencm_update(WorkSpace *, int argc, char **argv);
extern void opencm_note(WorkSpace *, int argc, char **argv);
extern void opencm_show_notes(WorkSpace *, int argc, char **argv);
extern void opencm_create_repository(WorkSpace *, int argc, char **argv);
extern void opencm_log(WorkSpace *, int argc, char **argv);

/* For replication: */
extern void opencm_clone_project(WorkSpace *, int argc, char **argv);
extern void opencm_clone_branch(WorkSpace *, int argc, char **argv);

/* User groups: */
extern void opencm_create_group(WorkSpace *, int argc, char **argv);
extern void opencm_add_member(WorkSpace *, int argc, char **argv);
extern void opencm_remove_member(WorkSpace *, int argc, char **argv);
extern void opencm_add_user(WorkSpace *, int argc, char **argv);
extern void opencm_create_user(WorkSpace *, int argc, char **argv);

/* For maintaining read/mod access: */
extern void opencm_set_group(WorkSpace *, int argc, char **argv);
extern void opencm_set_user(WorkSpace *, int argc, char **argv);

/* For mutable maintenance: */
extern void opencm_set_name(WorkSpace *, int argc, char **argv);
extern void opencm_set_desc(WorkSpace *, int argc, char **argv);

/* Directory (namespace) maintenance */
extern void opencm_ls(WorkSpace *, int argc, char **argv);
extern void opencm_mkdir(WorkSpace *, int argc, char **argv);
extern void opencm_bind(WorkSpace *, int argc, char **argv);
extern void opencm_unbind(WorkSpace *, int argc, char **argv);
extern void opencm_rebind(WorkSpace *, int argc, char **argv);
extern void opencm_tag(WorkSpace *, int argc, char **argv);

extern void opencm_resolve(WorkSpace *, int argc, char **argv);
extern void opencm_browse(WorkSpace *, int argc, char **argv);

extern void opencm_whoami(WorkSpace *, int argc, char **argv);

extern void opencm_xdcs_insert(WorkSpace *, int argc, char **argv);
extern void opencm_xdcs_extract(WorkSpace *, int argc, char **argv);
extern void opencm_xdcs_ls(WorkSpace *, int argc, char **argv);

extern void opencm_logmail(WorkSpace *, int argc, char **argv);
extern void opencm_vcmp(WorkSpace *, int argc, char **argv);

extern void opencm_set_workspace_repos(WorkSpace *, int argc, char **argv);
extern void opencm_set_workspace_user(WorkSpace *, int argc, char **argv);
extern void opencm_show_object(WorkSpace *, int argc, char **argv);
extern void opencm_show_workspace_repos(WorkSpace *, int argc, char **argv);
extern void opencm_show_workspace_user(WorkSpace *, int argc, char **argv);

void list_commands(command *table);

#endif /* CLIENT_COMMAND_H */
