/* -*- Mode: c -*- */
/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

%{
#include <string.h>
#include <stdarg.h>
#include <opencm.h>
#include "browseconfig.h"
  
#define YY_NO_UNPUT

#define YY_MALLOC_DECL
#define malloc(x) GC_malloc_atomic(x)
#define free(x) 
extern void exit(int);

/* Suppress compiler complaint about yy_flex_realloc: */
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ))
  __attribute__((unused));

static const Buffer *buffer;
static ocmoff_t position;

static int showshell_lex( SDR_stream *strm );
#define YY_DECL int showshell_lex( SDR_stream *strm )

#define ECHO do_html_output(strm, yytext, yyleng)

int show_shell(SDR_stream *strm, const Buffer *input);

int show_shell(SDR_stream *strm, const Buffer *input)
{
  int result;

  buffer = input;
  position = 0;

  stream_printf(strm, "<br><tt>\n");
  html_output_init();

  result = showshell_lex(strm);

  stream_printf(strm, "</tt>\n");

  return result;
}

#define YY_INPUT(buf,result,max_size) \
   { \
     if (position == buffer_length(buffer)) \
       result = YY_NULL; \
     else { \
       buf[0] = buffer_getc(buffer, position++); \
       result = 1; \
     } \
   }

#ifndef output
#define output(x) stream_putc(strm, yyout);
#endif

#undef yyunput
%}

KWD ((if)|(then)|(else)|(elif)|(fi)|(case)|(esac)|(exit)|(for)|(do)|(done)|(set))
IDENT [a-zA-Z_][a-zA-Z0-9_]*
     
%x EOL_COMMENT FUNCNAME STRING SQSTRING
%%
#     { html_begin(strm,begin_comment); ECHO; BEGIN(EOL_COMMENT); }
{KWD} { html_begin(strm,begin_kwd); ECHO; html_end(strm,end_kwd); }
\"    { ECHO; html_begin(strm,begin_string); BEGIN(STRING); }
\'    { ECHO; html_begin(strm,begin_string); BEGIN(SQSTRING); }
^{IDENT}/\(     { html_begin(strm,begin_func); ECHO; html_end(strm,end_func); }
{IDENT} { ECHO; }

<EOL_COMMENT>\n { html_end(strm,end_comment); ECHO; BEGIN(0); }

<STRING>\"  { html_end(strm,end_string); ECHO; BEGIN(0); }
<STRING>[^\\]\\\" { ECHO; }

<SQSTRING>\'  { html_end(strm,end_string); ECHO; BEGIN(0); }
<SQSTRING>[^\\]\\\' { ECHO; }

<*>\<     { ECHO; }
<*>\>     { ECHO; }
<*>&      { ECHO; }
<*>" "    { ECHO; }
<*>\n     { ECHO; }
<*>.      { ECHO; }

%%

int yywrap()
{
  return 1;
}
