#ifndef CLIENT_WORKSPACE_H
#define CLIENT_WORKSPACE_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

struct WorkSpace {
  OC_bool        haveProject;
  const char *projPath;
  const char *topDir;
  const char *startDir;
  const char *relStartDir;
  PendingChange *pc;

  Repository *r;		/* IFF connected */
};

WorkSpace *ws_Init(struct command *cmd, const char *rootPath);

void ws_Connect(WorkSpace *ws, PubKey *pk);
void ws_RewriteWorkspace(WorkSpace *);
WsEntity *ws_Lookup(WorkSpace *, const char *);
WsEntity *ws_AddFile(WorkSpace *, const char *);
void ws_RemoveFile(WorkSpace *, const char *);
void ws_Rename(WorkSpace *, const char *old, const char *new);
void ws_PruneWorkspace(WorkSpace *ws);

/* ??? */
void ws_BuildPendingChange(WorkSpace *ws, 
			   Repository *r,
			   const char *branchURI,
			   oc_uint64_t rev);
  
void ws_Populate(WorkSpace *);
void ws_Revert(WorkSpace *);

#define WSR_CHECKCOLLIDE  0x1u
#define WSR_FORCE         0x2u

void ws_RestoreFiles(WorkSpace *, unsigned flags);
  
#define WSE_FILTER   0x1u
#define WSE_FILES    0x2u
#define WSE_DIRS     0x4u
#define WSE_SYMLINKS 0x8u

#define WSE_NORMAL      (WSE_FILES|WSE_SYMLINKS|WSE_FILTER)
#define WSE_UNFILTERED  (WSE_FILES|WSE_SYMLINKS)

void ws_EnumeratePath(WorkSpace *, StrVec *names, const char *path, 
		      unsigned flags, 
		      OC_bool (*filter)(WorkSpace *, const char *));

StrVec *ws_Enumerate(WorkSpace *, unsigned flags, OC_bool (*fn)(WorkSpace *, const char *));

void ws_Commit(WorkSpace *ws, StrVec *names);
void ws_Update(WorkSpace *ws);

/* Convert all paths to workspace-relative path */
const char *ws_NormalizePath(WorkSpace *ws, const char *path);

/* Implemented in Merge.c: */
OC_bool ws_mergeFrom(WorkSpace *ws, Repository *r, const char *mURI, 
		  Change *other, OC_bool isUpdate);

void ws_diff_against_change(Change *chg, Repository *r, 
			    const char *branchURI, StrVec *nmList);

#endif /* CLIENT_WORKSPACE_H */
