/* $Id: procuid.c,v 1.4 2002/08/30 18:58:00 nino Exp $ */

/* Copyright (C) 2001 Nils Nordman <nino@nforced.com>

   LibGTop is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License,
   or (at your option) any later version.

   LibGTop is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with LibGTop; see the file COPYING. If not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

/* XXX - Implement unstable stuff for this stuff
   Also, implement session "id" as well then. Don't bother now since we can
   avoid kmem not doing this.
*/

#include <glibtop.h>
#include <glibtop/error.h>
#include <glibtop/procuid.h>

#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/proc.h>

static const unsigned long _glibtop_sysdeps_proc_uid =
(1L << GLIBTOP_PROC_UID_UID) +
(1L << GLIBTOP_PROC_UID_EUID) +
(1L << GLIBTOP_PROC_UID_GID) +
(1L << GLIBTOP_PROC_UID_EGID) +
(1L << GLIBTOP_PROC_UID_PID) +
(1L << GLIBTOP_PROC_UID_PPID) +
(1L << GLIBTOP_PROC_UID_PGRP) +
/*  (1L << GLIBTOP_PROC_UID_SESSION) + */
(1L << GLIBTOP_PROC_UID_TTY) +
(1L << GLIBTOP_PROC_UID_TPGID) +
(1L << GLIBTOP_PROC_UID_PRIORITY) +
(1L << GLIBTOP_PROC_UID_NICE);


/* Init function. */

void
glibtop_init_proc_uid_s (glibtop *server)
{
	server->sysdeps.proc_uid = _glibtop_sysdeps_proc_uid;
}

/* Provides detailed information about a process. */

void
glibtop_get_proc_uid_s(glibtop *server, glibtop_proc_uid *buf,
			pid_t pid)
{
	int proc_mib[] = { CTL_KERN, KERN_PROC, KERN_PROC_PID, pid };
	size_t mib_size = 4;
	size_t proc_size = sizeof(struct kinfo_proc);
	struct kinfo_proc p;

	glibtop_init_s( server, (1L << GLIBTOP_SYSDEPS_PROC_UID), 0 );
	memset( buf, 0x0, sizeof(glibtop_proc_uid) );

	/* fetch the proc */
	if (sysctl(proc_mib, mib_size, &p, &proc_size, NULL, 0) == -1) {
	        glibtop_warn_io_r(server, "sysctl kern.kern_proc");
                return;
	}
	buf->euid = p.kp_eproc.e_ucred.cr_uid;
	buf->gid = p.kp_eproc.e_pcred.p_rgid;
	buf->egid = p.kp_eproc.e_ucred.cr_gid;
	buf->uid = p.kp_eproc.e_pcred.p_ruid;
	buf->pid = pid;
	buf->ppid = p.kp_eproc.e_ppid;
	buf->pgrp = p.kp_eproc.e_pgid;
/*  	buf->session = ; */
	buf->tty = p.kp_eproc.e_tdev;
	buf->tpgid = p.kp_eproc.e_tpgid;
	buf->priority = p.kp_proc.p_priority;
	buf->nice = p.kp_proc.p_nice;
	buf->flags = _glibtop_sysdeps_proc_uid;
}
