/* $Id: netload.c,v 1.5 2002/08/16 16:27:17 nino Exp $ */

/* Copyright (C) 2002 Nils Nordman <nino@nforced.com>

   LibGTop is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License,
   or (at your option) any later version.

   LibGTop is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with LibGTop; see the file COPYING. If not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <ifaddrs.h>
#include <netinet/in.h>

#include <glibtop.h>
#include <glibtop/error.h>
#include <glibtop/netload.h>

static const unsigned long _glibtop_sysdeps_netload =
(1L << GLIBTOP_NETLOAD_IF_FLAGS) +
(1L << GLIBTOP_NETLOAD_MTU) +
(1L << GLIBTOP_NETLOAD_SUBNET) +
(1L << GLIBTOP_NETLOAD_ADDRESS) +
(1L << GLIBTOP_NETLOAD_PACKETS_IN) +
(1L << GLIBTOP_NETLOAD_PACKETS_OUT) +
(1L << GLIBTOP_NETLOAD_PACKETS_TOTAL) +
(1L << GLIBTOP_NETLOAD_BYTES_IN) +
(1L << GLIBTOP_NETLOAD_BYTES_OUT) +
(1L << GLIBTOP_NETLOAD_BYTES_TOTAL) +
(1L << GLIBTOP_NETLOAD_ERRORS_IN) +
(1L << GLIBTOP_NETLOAD_ERRORS_OUT) +
(1L << GLIBTOP_NETLOAD_ERRORS_TOTAL) +
(1L << GLIBTOP_NETLOAD_COLLISIONS);

/* Init function. */

void
glibtop_init_netload_s (glibtop *server)
{
	server->sysdeps.netload = _glibtop_sysdeps_netload;
}

/* Provides Network statistics. */

void
glibtop_get_netload_s (glibtop *server, glibtop_netload *buf,
		       const char *interface)
{
	struct ifaddrs *ifap, *iface;
	struct if_data *data;
	struct sockaddr_in *sin;
	
	memset (buf, 0, sizeof (glibtop_netload));

	if (getifaddrs(&ifap) < 0) {
		glibtop_warn_io_r (server, "getifaddrs");
                return;
	}

	for (iface = ifap; iface; iface = iface->ifa_next) {
		if (iface->ifa_addr->sa_family != AF_INET || strcmp(interface, iface->ifa_name))
			continue;

		data = (struct if_data *)iface->ifa_data;

		buf->flags = _glibtop_sysdeps_netload;
		
		if (iface->ifa_flags & IFF_UP)
			buf->if_flags |= GLIBTOP_IF_FLAGS_UP;
		if (iface->ifa_flags & IFF_BROADCAST)
			buf->if_flags |= GLIBTOP_IF_FLAGS_BROADCAST;
		if (iface->ifa_flags & IFF_DEBUG)
			buf->if_flags |= GLIBTOP_IF_FLAGS_DEBUG;
		if (iface->ifa_flags & IFF_LOOPBACK)
			buf->if_flags |= GLIBTOP_IF_FLAGS_LOOPBACK;
		if (iface->ifa_flags & IFF_POINTOPOINT)
			buf->if_flags |= GLIBTOP_IF_FLAGS_POINTOPOINT;
		if (iface->ifa_flags & IFF_RUNNING)
			buf->if_flags |= GLIBTOP_IF_FLAGS_RUNNING;
		if (iface->ifa_flags & IFF_NOARP)
			buf->if_flags |= GLIBTOP_IF_FLAGS_NOARP;
		if (iface->ifa_flags & IFF_PROMISC)
			buf->if_flags |= GLIBTOP_IF_FLAGS_PROMISC;
		if (iface->ifa_flags & IFF_ALLMULTI)
			buf->if_flags |= GLIBTOP_IF_FLAGS_ALLMULTI;
		if (iface->ifa_flags & IFF_OACTIVE)
			buf->if_flags |= GLIBTOP_IF_FLAGS_OACTIVE;
		if (iface->ifa_flags & IFF_SIMPLEX)
			buf->if_flags |= GLIBTOP_IF_FLAGS_SIMPLEX;
		if (iface->ifa_flags & IFF_LINK0)
			buf->if_flags |= GLIBTOP_IF_FLAGS_LINK0;
		if (iface->ifa_flags & IFF_LINK1)
			buf->if_flags |= GLIBTOP_IF_FLAGS_LINK1;
		if (iface->ifa_flags & IFF_LINK2)
			buf->if_flags |= GLIBTOP_IF_FLAGS_LINK2;
		if (iface->ifa_flags & IFF_MULTICAST)
			buf->if_flags |= GLIBTOP_IF_FLAGS_MULTICAST;


		buf->mtu = data->ifi_mtu;
		sin = (struct sockaddr_in *)iface->ifa_addr;
		buf->address = sin->sin_addr.s_addr;
		sin = (struct sockaddr_in *)iface->ifa_netmask;
		buf->subnet = buf->address & sin->sin_addr.s_addr;
		buf->packets_in = data->ifi_ipackets;
		buf->packets_out = data->ifi_opackets;
		buf->packets_total = buf->packets_in + buf->packets_out;
		buf->bytes_in = data->ifi_ibytes;
		buf->bytes_out = data->ifi_obytes;
		buf->bytes_total = buf->bytes_in + buf->bytes_out;
		buf->errors_in = data->ifi_ierrors;
		buf->errors_out = data->ifi_oerrors;
		buf->errors_total = buf->errors_in + buf->errors_out;
		buf->collisions = data->ifi_collisions;

		break;
	}
}
