/* $Id: mem.c,v 1.3 2002/08/30 18:58:00 nino Exp $ */

/* Copyright (C) 2002 Nils Nordman <nino@nforced.com>

   LibGTop is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License,
   or (at your option) any later version.

   LibGTop is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with LibGTop; see the file COPYING. If not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <glibtop.h>
#include <glibtop/error.h>
#include <glibtop/mem.h>

#include <sys/param.h>
#include <sys/sysctl.h>
#include <uvm/uvm_extern.h>


static const unsigned long _glibtop_sysdeps_mem =
(1L << GLIBTOP_MEM_TOTAL) + 
(1L << GLIBTOP_MEM_USED) +
(1L << GLIBTOP_MEM_FREE);
/*  (1L << GLIBTOP_MEM_SHARED) + */
/*  (1L << GLIBTOP_MEM_BUFFER) + */
/*  (1L << GLIBTOP_MEM_CACHED) + */
/*  (1L << GLIBTOP_MEM_USER) + */
/*  (1L << GLIBTOP_MEM_LOCKED); */

/* Init function. */

void
glibtop_init_mem_s (glibtop *server)
{
	server->sysdeps.mem = _glibtop_sysdeps_mem;
}

/* Provides information about memory usage. */

void
glibtop_get_mem_s (glibtop *server, glibtop_mem *buf)
{
	int uvm_mib[] = { CTL_VM, VM_UVMEXP };
	struct uvmexp uexp;
	size_t size;
	
  	glibtop_init_s (&server, (1 << GLIBTOP_SYSDEPS_MEM), 0);
	memset (buf, 0, sizeof (glibtop_mem));

	size = sizeof(uexp);
	if (sysctl(uvm_mib, 2, &uexp, &size, NULL, 0) == -1) {
	        glibtop_warn_io_r (server, "sysctl vm.uvmexp");
                return;
	}
	buf->total = uexp.npages * uexp.pagesize;
	buf->free = uexp.free * uexp.pagesize;
	buf->used  = buf->total - buf->free;
	buf->flags = _glibtop_sysdeps_mem;
}
