/* $Id: cpu.c,v 1.3 2002/08/30 18:58:00 nino Exp $ */

/* Copyright (C) 2001 Nils Nordman <nino@nforced.com>

   LibGTop is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License,
   or (at your option) any later version.

   LibGTop is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with LibGTop; see the file COPYING. If not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <glibtop.h>
#include <glibtop/error.h>
#include <glibtop/cpu.h>

#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/dkstat.h>
#include <sys/time.h>

static const unsigned long _glibtop_sysdeps_cpu = \
(1L << GLIBTOP_CPU_TOTAL) + \
(1L << GLIBTOP_CPU_USER) + \
(1L << GLIBTOP_CPU_NICE) + \
(1L << GLIBTOP_CPU_SYS) + \
(1L << GLIBTOP_CPU_IDLE) + \
(1L << GLIBTOP_CPU_FREQUENCY);

/* Init function. */

void
glibtop_init_cpu_s (glibtop *server)
{
	server->sysdeps.cpu = _glibtop_sysdeps_cpu;
}

/* Provides information about cpu usage. */

void
glibtop_get_cpu_s (glibtop *server, glibtop_cpu *buf)
{
        int cp_time_mib[] = { CTL_KERN, KERN_CPTIME };
        int clockrate_mib[] = { CTL_KERN, KERN_CLOCKRATE };
	size_t  size;
	struct clockinfo ci;
	long times[CPUSTATES];

        glibtop_init_s (&server, (1L << GLIBTOP_SYSDEPS_CPU), 0);
	memset( buf, 0x0, sizeof(glibtop_cpu) );

	/* get clock freq */
	size = sizeof(ci);
	if (sysctl(clockrate_mib, 2, &ci, &size, NULL, 0) == -1) {
	        glibtop_warn_io_r (server, "sysctl kern.clockrate");
                return;
	}

	/* get the times */
	size = sizeof( times );
	if (sysctl(cp_time_mib, 2, &times, &size, NULL, 0) == -1) {
	        glibtop_warn_io_r (server, "sysctl kern.cp_time");
                return;
	}
	buf->frequency = ci.hz;
	buf->user = times[CP_USER];
	buf->nice = times[CP_NICE];
	buf->idle = times[CP_IDLE];
	buf->sys = times[CP_SYS];
  	buf->total = buf->user + buf->nice + buf->idle + buf->sys + times[CP_INTR];
	buf->flags = _glibtop_sysdeps_cpu;
}
